select t1.sys_reportid,
       t1.siteid,
       t1.reporttype,
       t1.filename,
       t1.jimu_report_id,
       t1.systemappid,
       t1.isused,
       t1.languagecode,
       t2.systemappname,
       case when t1.reporttype = '积木报表' then t3.type else 'datainfo' end           as type,
       case when t1.reporttype = '积木报表' then t3.name else t1.name end              as name,
       case when t1.reporttype = '积木报表' then t3.create_time else t1.createdate end as create_time,
       case when t1.reporttype = '积木报表' then t3.update_time else t1.createdate end as update_time,
       case when t1.reporttype = '积木报表' then t3.view_count else t1.viewcount end   as view_count
from sys_report t1
         left join sys_systemapp t2 on t1.systemappid = t2.systemappid
         left join jimu_report t3 on t1.jimu_report_id = t3.id
where t1.reporttype in ('birt报表', '润乾报表')
   or (t1.reporttype = '积木报表' and t3.id is not null)
