/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.work.send;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import utility.wechat.work.GetAccessToken;
import utility.wechat.work.Parameter;

public class QYWechatMsgSender {
    private String address = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=";
    private URLConnection connection;
    private OutputStreamWriter out;
    private URL url;
    private String agentid = "0";

    public QYWechatMsgSender(String systemclient) throws IOException, YosException {
        this.address = this.address + GetAccessToken.get(systemclient);
        this.url = new URL(this.address);
        this.connection = this.url.openConnection();
        this.connection.setDoOutput(true);
        this.out = new OutputStreamWriter(this.connection.getOutputStream(), StandardCharsets.UTF_8);
        this.agentid = Parameter.getWorkParameter(systemclient).getString("work_agentid");
    }

    public QYWechatMsgSender(String systemclient, String agentid) throws IOException, YosException {
        this.address = this.address + GetAccessToken.get(systemclient);
        this.url = new URL(this.address);
        this.connection = this.url.openConnection();
        this.connection.setDoOutput(true);
        this.out = new OutputStreamWriter(this.connection.getOutputStream(), StandardCharsets.UTF_8);
        this.agentid = agentid;
    }

    public String sendTextMsg(String users2, String content) throws IOException {
        ArrayList<String> tousers = new ArrayList<String>();
        tousers.add(users2);
        return this.sendTextMsg(tousers, content);
    }

    public String sendTextMsg(ArrayList<String> tousers, String content) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", (Object)this.join(tousers));
        object.put("toparty", (Object)null);
        object.put("totag", (Object)null);
        object.put("msgtype", (Object)"text");
        object.put("agentid", (Object)this.agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("content", (Object)content);
        object.put("text", (Object)textobject);
        object.put("safe", (Object)"0");
        return this.Send(object);
    }

    public String sendImageMsg(String users2, String MEDIA_ID) throws IOException {
        ArrayList<String> tousers = new ArrayList<String>();
        tousers.add(users2);
        return this.sendImageMsg(tousers, MEDIA_ID);
    }

    public String sendImageMsg(ArrayList<String> tousers, String MEDIA_ID) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", (Object)this.join(tousers));
        object.put("toparty", (Object)null);
        object.put("totag", (Object)null);
        object.put("msgtype", (Object)"image");
        object.put("agentid", (Object)this.agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", (Object)MEDIA_ID);
        object.put("image", (Object)textobject);
        object.put("safe", (Object)"0");
        return this.Send(object);
    }

    public String sendVoiceMsg(String users2, String MEDIA_ID) throws IOException {
        ArrayList<String> tousers = new ArrayList<String>();
        tousers.add(users2);
        return this.sendVoiceMsg(tousers, MEDIA_ID);
    }

    public String sendVoiceMsg(ArrayList<String> tousers, String MEDIA_ID) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", (Object)this.join(tousers));
        object.put("toparty", (Object)null);
        object.put("totag", (Object)null);
        object.put("msgtype", (Object)"voice");
        object.put("agentid", (Object)this.agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", (Object)MEDIA_ID);
        object.put("voice", (Object)textobject);
        object.put("safe", (Object)"0");
        return this.Send(object);
    }

    public String sendVideoMsg(String users2, String MEDIA_ID, String Title, String Description) throws IOException {
        ArrayList<String> tousers = new ArrayList<String>();
        tousers.add(users2);
        return this.sendVideoMsg(tousers, MEDIA_ID, Title, Description);
    }

    public String sendVideoMsg(ArrayList<String> tousers, String MEDIA_ID, String Title, String Description) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", (Object)this.join(tousers));
        object.put("toparty", (Object)null);
        object.put("totag", (Object)null);
        object.put("msgtype", (Object)"video");
        object.put("agentid", (Object)this.agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", (Object)MEDIA_ID);
        textobject.put("title", (Object)Title);
        textobject.put("description", (Object)Description);
        object.put("video", (Object)textobject);
        object.put("safe", (Object)"0");
        return this.Send(object);
    }

    public String sendfileMsg(String users2, String MEDIA_ID) throws IOException {
        ArrayList<String> tousers = new ArrayList<String>();
        tousers.add(users2);
        return this.sendfileMsg(tousers, MEDIA_ID);
    }

    public String sendfileMsg(ArrayList<String> tousers, String MEDIA_ID) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", (Object)this.join(tousers));
        object.put("toparty", (Object)null);
        object.put("totag", (Object)null);
        object.put("msgtype", (Object)"file");
        object.put("agentid", (Object)this.agentid);
        JSONObject textobject = new JSONObject();
        textobject.put("media_id", (Object)MEDIA_ID);
        object.put("file", (Object)textobject);
        object.put("safe", (Object)"0");
        return this.Send(object);
    }

    public String sendNewsMsg(String users2, List<Map<String, String>> news) throws IOException {
        ArrayList<String> tousers = new ArrayList<String>();
        tousers.add(users2);
        return this.sendNewsMsg(tousers, news);
    }

    public String sendNewsMsg(ArrayList<String> tousers, List<Map<String, String>> news) throws IOException {
        JSONObject object = new JSONObject();
        object.put("touser", (Object)this.join(tousers));
        object.put("toparty", (Object)null);
        object.put("totag", (Object)null);
        object.put("msgtype", (Object)"news");
        object.put("agentid", (Object)this.agentid);
        JSONObject newsobject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (Map<String, String> map : news) {
            JSONObject newobject = new JSONObject();
            newobject.put("title", (Object)map.get("title"));
            newobject.put("description", (Object)map.get("description"));
            newobject.put("url", (Object)map.get("url"));
            newobject.put("picurl", (Object)map.get("picurl"));
            jsonArray.add((Object)newobject);
        }
        newsobject.put("articles", (Object)jsonArray);
        object.put("news", (Object)newsobject);
        return this.Send(object);
    }

    private String Send(JSONObject object) throws IOException {
        this.out.write(object.toString());
        this.out.flush();
        this.out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
        String line = null;
        StringBuffer content = new StringBuffer();
        while ((line = in.readLine()) != null) {
            content.append(line);
        }
        in.close();
        return content.toString();
    }

    public String join(ArrayList<String> a) {
        String b = null;
        if (a == null) {
            return b;
        }
        for (String c : a) {
            if (b == null || b.equals("")) {
                b = c;
                continue;
            }
            b = b + "|" + c;
        }
        return b;
    }
}

