/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.wechatpay.POJO;

import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import utility.tools.WebRequest;
import utility.wechat.wechatpay.POJO.Base;
import utility.wechat.wechatpay.POJO.CloseOrderResponse;

public class CloseOrderRequest
extends Base {
    private String appid;
    private String mch_id;
    private String nonce_str;
    private String out_trade_no;

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMch_id() {
        return this.mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public String getNonce_str() {
        return this.nonce_str;
    }

    public void setNonce_str(String nonce_str) {
        this.nonce_str = nonce_str;
    }

    public String getOut_trade_no() {
        return this.out_trade_no;
    }

    public void setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
    }

    public CloseOrderResponse getOrderResponse(String mch_key) {
        String requestxml = this.asXml(mch_key);
        String res = new WebRequest().doPost(requestxml, "https://api.mch.weixin.qq.com/pay/unifiedorder");
        return this.getCloseOrderResponse(res);
    }

    private String asXml(String mch_key) {
        DOMElement request = new DOMElement("xml");
        request.addElement("appid").addText(this.appid);
        request.addElement("mch_id").addText(this.mch_id);
        request.addElement("nonce_str").addText(this.createNonce_str(this.out_trade_no + this.appid));
        request.addElement("out_trade_no").addText(this.out_trade_no);
        this.createSign(request, mch_key);
        return request.asXML();
    }

    private CloseOrderResponse getCloseOrderResponse(String response) {
        CloseOrderResponse orderResponse = new CloseOrderResponse();
        try {
            Document respones = DocumentHelper.parseText((String)response);
            Iterator it = respones.getRootElement().elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String key = element.getName();
                String text = element.getText();
                switch (key) {
                    case "return_code": {
                        orderResponse.setReturn_code(text);
                        break;
                    }
                    case "return_msg": {
                        orderResponse.setReturn_msg(text);
                        break;
                    }
                    case "appid": {
                        orderResponse.setAppid(text);
                        break;
                    }
                    case "mch_id": {
                        orderResponse.setMch_id(text);
                        break;
                    }
                    case "nonce_str": {
                        orderResponse.setNonce_str(text);
                        break;
                    }
                    case "sign": {
                        orderResponse.setSign(text);
                        break;
                    }
                    case "result_code": {
                        orderResponse.setResult_code(text);
                        break;
                    }
                    case "result_msg": {
                        orderResponse.setResult_msg(text);
                        break;
                    }
                    case "err_code": {
                        orderResponse.setErr_code(text);
                        break;
                    }
                    case "err_code_des": {
                        orderResponse.setErr_code_des(text);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderResponse;
    }
}

