/*
 * Decompiled with CFR 0.152.
 */
package utility.bankdocking.boc.tool;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class Tool {
    public static String sendMd5(String version2, String merid, String trancode, String tmp, String charset, String password, String transtime) {
        String returnStr = Tool.md5(Tool.md5("version=" + version2 + "&merId=" + merid + "&tranCode=" + trancode + "&reqData=" + tmp, charset).toUpperCase() + "SEPGARAYJTOR" + Tool.md5(password + transtime, charset).toUpperCase(), charset).toUpperCase();
        return returnStr;
    }

    public static String returnMd5(String retxml, String merid, String orderid, String charset, String password, String transtime) {
        String returnStr = Tool.md5(Tool.md5("reqData=" + retxml + "&merId=" + merid + "&orderId=" + orderid, charset).toUpperCase() + "SEPGARAYJTOR" + Tool.md5(password + transtime, charset).toUpperCase(), charset).toUpperCase();
        return returnStr;
    }

    public static String md5(String str, String charset) {
        if (str == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes(charset));
        }
        catch (NoSuchAlgorithmException e) {
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return md5StrBuff.toString();
    }

    public static HashMap loadConfig(String path) throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        FileInputStream fs = null;
        InputStreamReader isr = null;
        try {
            fs = new FileInputStream(path);
            isr = new InputStreamReader(fs);
            BufferedReader br = new BufferedReader(isr);
            String data = "";
            while ((data = br.readLine()) != null) {
                if (data.equals("") || data.charAt(0) == '#') continue;
                Vector vvv = Tool.splitString("|", data);
                if (vvv.size() == 1) {
                    hm.put(vvv.get(0).toString(), "");
                }
                if (vvv.size() == 2) {
                    hm.put(vvv.get(0).toString(), vvv.get(1).toString());
                    continue;
                }
                hm.put("", "");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
        return hm;
    }

    public static Vector splitString(String sign, String sourceString) {
        Vector<String> splitArrays = new Vector<String>();
        int i = 0;
        int j = 0;
        if (sourceString.length() == 0) {
            return splitArrays;
        }
        while (i <= sourceString.length()) {
            j = sourceString.indexOf(sign, i);
            if (j < 0) {
                j = sourceString.length();
            }
            splitArrays.addElement(sourceString.substring(i, j));
            i = j + 1;
        }
        return splitArrays;
    }

    public static boolean checkTranstime(String time) {
        String now;
        long t1;
        if (time == null || time.length() != 14) {
            return false;
        }
        long t = Long.parseLong(time.substring(0, 8)) * 10000L + Long.parseLong(time.substring(8, 10)) * 60L + Long.parseLong(time.substring(10, 12));
        return t - (t1 = Long.parseLong((now = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())).substring(0, 8)) * 10000L + Long.parseLong(now.substring(8, 10)) * 60L + Long.parseLong(now.substring(10, 12))) <= 15L && t - t1 >= -15L;
    }

    public String getWEBINFPath() {
        try {
            String path = URLDecoder.decode(new URL(this.getClass().getClassLoader().getResource("").toString()).getPath(), "UTF-8");
            System.out.println("path" + path.substring(0, path.indexOf("classes")));
            return path.substring(0, path.indexOf("classes"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean checkSigntime(String time) {
        if (time == null || time.length() != 19) {
            return false;
        }
        try {
            Date d = new Date();
            String now = new SimpleDateFormat("yyyyMMddHHmmss").format(d);
            long h = Long.parseLong(now.substring(8, 10));
            long m = Long.parseLong(now.substring(10, 12));
            String t_y = time.substring(0, 4);
            String t_m = time.substring(5, 7);
            String t_d = time.substring(8, 10);
            String t_h = time.substring(11, 13);
            String t_mi = time.substring(14, 16);
            if (h == 23L && m >= 45L || h == 0L && m <= 15L) {
                Calendar c = Calendar.getInstance();
                c.set(1, Integer.parseInt(t_y));
                c.set(2, Integer.parseInt(t_m) - 1);
                c.set(5, Integer.parseInt(t_d));
                c.set(11, Integer.parseInt(t_h));
                c.set(12, Integer.parseInt(t_mi));
                c.set(13, 0);
                c.set(14, 0);
                long l = c.getTimeInMillis() - d.getTime();
                if (l > 900000L || l < -900000L) {
                    return false;
                }
            } else {
                long t1 = Long.parseLong(now.substring(0, 8)) * 1440L + h * 60L + m;
                long t = Long.parseLong(t_y + t_m + t_d) * 1440L + Long.parseLong(t_h) * 60L + Long.parseLong(t_mi);
                if (t - t1 > 15L || t - t1 < -15L) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isNotNull(String name) {
        return name != null && name.length() != 0;
    }
}

