/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.work.stopusing.media;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import utility.wechat.work.GetAccessToken;

public class DownLoad {
    long file_size = 0L;

    public DownLoad(String systemclient, String MediaId, String savefile) {
        try {
            String access_token = GetAccessToken.get(systemclient);
            URL url = new URL("https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=" + access_token + "&media_id=" + MediaId);
            this.down(url, savefile);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public DownLoad(String systemclient, String appid, String MediaId, String savefile) {
        try {
            String access_token = GetAccessToken.get(systemclient);
            URL url = new URL("https://qyapi.weixin.qq.com/cgi-bin/material/get?access_token=" + access_token + "&media_id=" + MediaId + "&agentid=" + appid);
            this.down(url, savefile);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void down(URL url, String savefile) throws IOException {
        int byteread = 0;
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream fs = new FileOutputStream(savefile);
        byte[] buffer = new byte[1024];
        while ((byteread = inStream.read(buffer)) != -1) {
            fs.write(buffer, 0, byteread);
        }
        this.file_size = conn.getContentLengthLong();
        inStream.close();
        fs.close();
    }

    public String getfilesize() {
        double max = 1024.0;
        if ((double)this.file_size / max == 0.0) {
            return this.file_size + "bit";
        }
        if ((double)this.file_size / max < 1024.0) {
            return (double)this.file_size / max + "kb";
        }
        if ((double)this.file_size / (max * max) < 1024.0) {
            return (double)this.file_size / (max * max) + "mb";
        }
        return (double)this.file_size / (max * max * max) + "gb";
    }
}

