/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.wechatpay;

import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.util.ArrayList;
import utility.wechat.wechatpay.POJO.CloseOrderRequest;
import utility.wechat.wechatpay.POJO.CloseOrderResponse;
import utility.wechat.wechatpay.POJO.CreateOrderRequest;
import utility.wechat.wechatpay.POJO.CreateOrderResponse;
import utility.wechat.wechatpay.POJO.QueryOrderRequest;
import utility.wechat.wechatpay.POJO.WechatOrder;

public class WechatPay
extends BaseClass {
    private String appid;
    private String mch_id;
    private String mch_key;
    private String notify_url = "";

    private WechatPay() {
    }

    public WechatPay(String systemclient) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select appid,secret,mch_id from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.mch_id = rows.get(0).getString("mch_id");
            this.mch_key = rows.get(0).getString("mch_key");
        }
    }

    public CreateOrderResponse createPayOrder(String out_trade_no, String trade_type, String openid, String custip, String ordertype, String title) throws YosException {
        int order_amount = 0;
        Rows sys_payorderRows = this.dbConnect.runSqlQuery("select amount from sys_payorder where out_trade_no='" + out_trade_no + "'");
        if (sys_payorderRows.isNotEmpty()) {
            order_amount = new Double(sys_payorderRows.get(0).getDouble("amount") * 100.0).intValue();
        }
        CreateOrderRequest order = new CreateOrderRequest();
        order.setAppid(this.appid);
        order.setBody(title);
        order.setMch_id(this.mch_id);
        order.setNotify_url(this.notify_url);
        order.setOpenid(openid);
        order.setOut_trade_no(out_trade_no);
        order.setSpbill_create_ip(custip);
        order.setTotal_fee(order_amount);
        order.setTrade_type(trade_type);
        CreateOrderResponse response = order.getOrderResponse(this.mch_key);
        return response;
    }

    public void queryOrder(String out_trade_no) throws YosException {
        QueryOrderRequest queryOrderRequest = new QueryOrderRequest();
        queryOrderRequest.setAppid(this.appid);
        queryOrderRequest.setMch_id(this.mch_id);
        queryOrderRequest.setOut_trade_no(out_trade_no);
        WechatPay.updatePayOrder(queryOrderRequest.getOrder(this.mch_key));
    }

    public CloseOrderResponse closeOrder(String out_trade_no) {
        CloseOrderRequest closeOrderRequest = new CloseOrderRequest();
        closeOrderRequest.setAppid(this.appid);
        closeOrderRequest.setMch_id(this.mch_id);
        closeOrderRequest.setOut_trade_no(out_trade_no);
        return closeOrderRequest.getOrderResponse(this.mch_key);
    }

    public static boolean updatePayOrder(WechatOrder wechatOrder) throws YosException {
        WechatPay wechatPay = new WechatPay();
        String trade_state = wechatOrder.getTrade_state();
        String out_trade_no = wechatOrder.getOut_trade_no();
        Rows sys_payorderRows = wechatPay.dbConnect.runSqlQuery("select * from sys_payorder where orderno='" + out_trade_no + "'");
        for (Row sys_payorderRow : sys_payorderRows) {
            ArrayList<String> sqllist = new ArrayList<String>();
            sqllist.add("update sys_payorder set wechatpayorder='" + wechatOrder + "' where orderno='" + out_trade_no + "'");
            if ("SUCCESS".equalsIgnoreCase(trade_state)) {
                sqllist.add("update sys_payorder set ispaid=1,paytime=" + wechatOrder.getTime_end() + " where orderno='" + out_trade_no + "'");
            }
            wechatPay.dbConnect.runSqlUpdate(sqllist);
        }
        return true;
    }
}

