/*
 * Decompiled with CFR 0.152.
 */
package service;

import beans.parameter.Parameter;
import common.ServiceController;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import utility.huawei.obs.BucketFile;
import utility.huawei.obs.mpc.MpcFactory;
import utility.huawei.obs.mpc.MpcFile;

public class HWOBSMPCTaskQuery
extends ServiceController {
    @Override
    public void serviceRun() throws Exception {
        if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
            Rows rows = this.dbConnect.runSqlQuery("select siteid,attachmentid,mpctaskid,postfix,document,url from sys_attachment where ifnull(mpctaskid,'') !='' and mpctaskstatus=0");
            for (Row row : rows) {
                long attachmentid = row.getLong("attachmentid");
                String mpctaskid = row.getString("mpctaskid");
                String siteid = row.getString("siteid");
                String postfix = row.getString("postfix");
                String document = row.getString("document");
                MpcFactory mpcFactory = new MpcFactory();
                MpcFile mpcFile = mpcFactory.queryTranscodingTask(mpctaskid);
                if (mpcFile == null) continue;
                if (mpcFile.isSuccessed()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_attachment");
                    insertSQL.setValue("parentid", attachmentid);
                    insertSQL.setValue("attachmentid", this.createTableID("sys_attachment"));
                    insertSQL.setValue("siteid", siteid);
                    insertSQL.setValue("createby", "admin");
                    insertSQL.setValue("type", "hls");
                    insertSQL.setValue("postfix", postfix);
                    insertSQL.setValue("serialnumber", mpcFile.getObject());
                    insertSQL.setValue("document", document);
                    insertSQL.setValue("url", new BucketFile(siteid).getFileUrl(mpcFile.getObject() + "/" + mpcFile.getOutput_file_name()) + "?attname=" + document);
                    insertSQL.setValue("contentlength", 0);
                    insertSQL.insert();
                    this.dbConnect.runSqlUpdate("update sys_attachment set mpctaskstatus=1 where attachmentid=" + attachmentid);
                    continue;
                }
                this.dbConnect.runSqlUpdate("update sys_attachment set mpctaskstatus=-1 where attachmentid=" + attachmentid);
            }
        }
    }
}

