/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.system.attachment.huawei;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.obs.services.model.HttpMethodEnum;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import restcontroller.R;
import restcontroller.system.attachment.Attachment;
import utility.huawei.obs.BucketFile;
import utility.huawei.obs.mpc.MediaMetaData;
import utility.huawei.obs.mpc.MpcFactory;
import utility.huawei.obs.mpc.MpcFile;

@API(title="\u9644\u4ef6\u7ba1\u7406")
public class OBS
extends Controller {
    public static HashMap<String, HashMap<String, String>> obsfilemap = new HashMap();

    public OBS(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u534e\u4e3a\u4e91\u4e0a\u4f20\u83b7\u53d6obs\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0", apiversion=R.ID10019701.v1.class)
    public String getFileName() {
        JSONObject object = new JSONObject();
        try {
            String filename = this.content.getString("filename");
            String filetype = this.content.getString("filetype");
            String contentType = this.content.getStringValue("contentType");
            String parentid = this.content.getString("parentid");
            HttpMethodEnum HttpMethod = HttpMethodEnum.PUT;
            if (this.content.containsKey("HttpMethod")) {
                if ("post".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                    HttpMethod = HttpMethodEnum.POST;
                } else if ("get".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                    HttpMethod = HttpMethodEnum.GET;
                }
            }
            String serialnumber = this.createMD5FileName() + "." + filetype;
            BucketFile bucketFile = new BucketFile(this.siteid);
            String uploadurl = "";
            if (contentType.equalsIgnoreCase("")) {
                BucketFile.FileType fileType = BucketFile.FileType.other;
                for (BucketFile.FileType f : BucketFile.FileType.values()) {
                    if (!f.name().equalsIgnoreCase(filetype)) continue;
                    fileType = f;
                    break;
                }
                uploadurl = bucketFile.getUploadUrl(fileType, serialnumber, HttpMethod);
            } else {
                uploadurl = bucketFile.getUploadUrl(contentType, serialnumber, HttpMethod);
            }
            bucketFile.close();
            object.put("serialfilename", (Object)serialnumber);
            object.put("uploadurl", (Object)uploadurl);
            object.put("filename", (Object)filename);
            object.put("filetype", (Object)filetype);
            object.put("parentid", (Object)parentid);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("filename", filename);
            map.put("filetype", filetype);
            map.put("parentid", parentid);
            obsfilemap.put(serialnumber, map);
        }
        catch (Exception e) {
            return this.getErrReturnObject().setErrMsg(e.getMessage()).toString();
        }
        return this.getSucReturnObject().setData(object).toString();
    }

    @API(title="\u534e\u4e3a\u4e91\u4e0a\u4f20\u6279\u91cf\u83b7\u53d6obs\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0", apiversion=R.ID10019801.v1.class)
    public String getFileNames() throws YosException {
        JSONArray returnarray = new JSONArray();
        JSONArray filesArray = this.content.getJSONArray("files");
        for (int i = 0; i < filesArray.size(); ++i) {
            try {
                JSONObject fileobject = filesArray.getJSONObject(i);
                String filename = fileobject.getString("filename");
                String filetype = fileobject.getString("filetype");
                String contentType = this.content.getStringValue("contentType");
                String parentid = fileobject.getString("parentid");
                HttpMethodEnum HttpMethod = HttpMethodEnum.PUT;
                if (this.content.containsKey("HttpMethod")) {
                    if ("post".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                        HttpMethod = HttpMethodEnum.POST;
                    } else if ("get".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                        HttpMethod = HttpMethodEnum.GET;
                    }
                }
                String serialnumber = this.createMD5FileName() + "." + filetype;
                BucketFile bucketFile = new BucketFile(this.siteid);
                String url = "";
                if (contentType.equalsIgnoreCase("")) {
                    BucketFile.FileType fileType = BucketFile.FileType.other;
                    for (BucketFile.FileType f : BucketFile.FileType.values()) {
                        if (!f.name().equalsIgnoreCase(filetype)) continue;
                        fileType = f;
                        break;
                    }
                    url = bucketFile.getUploadUrl(fileType, serialnumber, HttpMethod);
                } else {
                    url = bucketFile.getUploadUrl(contentType, serialnumber, HttpMethod);
                }
                bucketFile.close();
                JSONObject object = new JSONObject();
                object.put("serialfilename", (Object)serialnumber);
                object.put("uploadurl", (Object)url);
                object.put("filename", (Object)filename);
                object.put("filetype", (Object)filetype);
                object.put("parentid", (Object)parentid);
                returnarray.add((Object)object);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filename", filename);
                map.put("filetype", filetype);
                map.put("parentid", parentid);
                obsfilemap.put(serialnumber, map);
                continue;
            }
            catch (Exception e) {
                return this.getErrReturnObject().setErrMsg(e.getMessage()).toString();
            }
        }
        return this.getSucReturnObject().setData(returnarray).toString();
    }

    @API(title="\u534e\u4e3a\u4e91\u4e0a\u4f20\u6210\u529f\u53cd\u9988", apiversion=R.ID10019901.v1.class)
    public String uploadSuccess() throws YosException {
        String serialfilename = this.content.getString("serialfilename");
        if (!obsfilemap.containsKey(serialfilename)) {
            return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e91\u5b58\u50a8\u6587\u4ef6").toString();
        }
        String filename = obsfilemap.get(serialfilename).get("filename");
        String filetype = obsfilemap.get(serialfilename).get("filetype");
        String parentid = obsfilemap.get(serialfilename).get("parentid");
        filename = filename.replace("'", "");
        JSONArray attachmentidsarray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        try {
            ArrayList<String> SQlist = new ArrayList<String>();
            BucketFile bucketFile = new BucketFile(this.siteid);
            if (!bucketFile.doesObjectExist(serialfilename)) {
                return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e91\u5b58\u50a8\u6587\u4ef6").toString();
            }
            String mpctaskid = "null";
            String thumbnail_serialfilename = this.createMD5FileName() + ".jpg";
            int duration = 0;
            boolean thumbnail_succsed = false;
            try {
                if (this.isVideo(filetype)) {
                    MpcFactory mpcFactory = new MpcFactory();
                    MediaMetaData data = mpcFactory.getMetaData(this.siteid, serialfilename);
                    duration = data.getDuration();
                    if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
                        if (filetype.equalsIgnoreCase("mp4")) {
                            if (data != null) {
                                long kbitrate = data.getBitrate();
                                long size = data.getSize();
                                if (kbitrate > 5000L || size / 0x100000L > 500L) {
                                    mpctaskid = mpcFactory.createTranscodingTask(this.siteid, serialfilename);
                                }
                            }
                        } else if (filetype.equalsIgnoreCase("mov")) {
                            mpctaskid = mpcFactory.createTranscodingTask(this.siteid, serialfilename);
                        }
                    }
                    if (data != null && Parameter.get("attachment_huawei_obs_mpc_createthumbnails").equalsIgnoreCase("true")) {
                        thumbnail_succsed = mpcFactory.createThumbnailsTask(this.siteid, serialfilename, thumbnail_serialfilename, data.getWidth(), data.getHeight(), 1);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long attachmentid = this.createTableID("sys_attachment");
            attachmentidsarray.add((Object)attachmentid);
            long contentlength = bucketFile.getObjectMetadata(serialfilename).getContentLength();
            SQLFactory sqlFactory = new SQLFactory(this, "\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
            sqlFactory.addParameter("parentid", parentid.equals("") || parentid.equals("0") ? "null" : parentid);
            sqlFactory.addParameter("attachmentid", attachmentid);
            sqlFactory.addParameter("siteid", this.siteid);
            sqlFactory.addParameter("createby", this.username);
            sqlFactory.addParameter("type", "sourcefile");
            sqlFactory.addParameter("postfix", filetype);
            sqlFactory.addParameter("serialnumber", serialfilename);
            sqlFactory.addParameter("document", filename);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(serialfilename) + "?attname=" + filename);
            sqlFactory.addParameter("mpctaskid", mpctaskid);
            sqlFactory.addParameter("duration", duration);
            sqlFactory.addParameter("contentlength", contentlength);
            SQlist.add(sqlFactory.getSQL());
            if (thumbnail_succsed) {
                sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "cover");
                sqlFactory.addParameter("postfix", "jpg");
                sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
                sqlFactory.addParameter("document", thumbnail_serialfilename);
                sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename) + "?attname=" + thumbnail_serialfilename);
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
            }
            if (this.isImage(filetype) && contentlength / 0x100000L <= 24L) {
                sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "thumbnail");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", "s_" + serialfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getMinImageUrl(serialfilename) + "?attname=s_" + filename);
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("s_" + serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
                sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "compressed");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", "c_" + serialfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getCompressImageUrl(serialfilename) + "?attname=c_" + filename);
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("c_" + serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
            }
            bucketFile.close();
            this.dbConnect.runSqlUpdate(SQlist);
            obsfilemap.remove(serialfilename);
            beans.attachment.Attachment.RefreshFolderPath(this, attachmentid);
            resultObject.put("code", (Object)1);
            resultObject.put("msg", (Object)"\u6210\u529f");
            JSONObject object = new JSONObject();
            object.put("attachmentids", (Object)attachmentidsarray);
            resultObject.put("data", (Object)object);
            if (!"".equals(this.content.getStringValue("ownertable")) && this.content.getLongValue("ownerid") > 0L && !"".equals(this.content.getString("usetype"))) {
                this.content.put("attachmentids", (Object)attachmentidsarray);
                Attachment attachment = new Attachment(this.content);
                attachment.createFileLink();
                if (this.content.getBooleanValue("single")) {
                    this.content.put("attachmentid", (Object)attachmentid);
                }
                resultObject.put("attinfos", (Object)attachment.queryFileLink());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            resultObject.put("code", (Object)0);
            resultObject.put("msg", (Object)exception.getMessage());
        }
        return resultObject.toString();
    }

    @API(title="\u534e\u4e3a\u4e91\u6279\u91cf\u4e0a\u4f20\u6210\u529f\u53cd\u9988", apiversion=R.ID10020001.v1.class)
    public String uploadSuccesses() throws YosException {
        JSONArray obsfilenamesArray = this.content.getJSONArray("serialfilenames");
        Iterator it = obsfilenamesArray.iterator();
        ArrayList<String> SQLlist = new ArrayList<String>();
        JSONArray attachmentidsarray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        while (it.hasNext()) {
            String obsfilename = (String)it.next();
            if (!obsfilemap.containsKey(obsfilename)) continue;
            String filename = obsfilemap.get(obsfilename).get("filename");
            String filetype = obsfilemap.get(obsfilename).get("filetype");
            String parentid = obsfilemap.get(obsfilename).get("parentid");
            filename = filename.replace("'", "");
            try {
                BucketFile bucketFile = new BucketFile(this.siteid);
                if (!bucketFile.doesObjectExist(obsfilename)) continue;
                String mpctaskid = "null";
                int duration = 0;
                String thumbnail_serialfilename = this.createMD5FileName() + ".jgp";
                boolean thumbnail_succsed = false;
                try {
                    if (this.isVideo(filetype)) {
                        MpcFactory mpcFactoryV2 = new MpcFactory();
                        MediaMetaData data = mpcFactoryV2.getMetaData(this.siteid, obsfilename);
                        duration = data.getDuration();
                        if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
                            if (filetype.equalsIgnoreCase("mp4")) {
                                if (data != null) {
                                    long kbitrate = data.getBitrate();
                                    long size = data.getSize();
                                    if (kbitrate > 5000L || size / 0x100000L > 500L) {
                                        mpctaskid = mpcFactoryV2.createTranscodingTask(this.siteid, obsfilename);
                                    }
                                }
                            } else if (filetype.equalsIgnoreCase("mov")) {
                                mpctaskid = mpcFactoryV2.createTranscodingTask(this.siteid, obsfilename);
                            }
                        }
                        thumbnail_succsed = mpcFactoryV2.createThumbnailsTask(this.siteid, obsfilename, thumbnail_serialfilename, data.getWidth(), data.getHeight(), 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long attachmentid = this.createTableID("sys_attachment");
                long contentlength = bucketFile.getObjectMetadata(obsfilename).getContentLength();
                SQLFactory sqlFactory = new SQLFactory(this, "\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", parentid.equals("") || parentid.equals("0") ? "null" : parentid);
                sqlFactory.addParameter("attachmentid", attachmentid);
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "sourcefile");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", obsfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getFileUrl(obsfilename) + "?attname=" + filename);
                sqlFactory.addParameter("mpctaskid", mpctaskid);
                sqlFactory.addParameter("duration", duration);
                sqlFactory.addParameter("contentlength", contentlength);
                SQLlist.add(sqlFactory.getSQL());
                if (this.isVideo(filetype) && thumbnail_succsed) {
                    sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", this.siteid);
                    sqlFactory.addParameter("createby", this.username);
                    sqlFactory.addParameter("type", "cover");
                    sqlFactory.addParameter("postfix", "jpg");
                    sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
                    sqlFactory.addParameter("document", thumbnail_serialfilename);
                    sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename) + "?attname=" + thumbnail_serialfilename);
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                }
                if (this.isImage(filetype) && contentlength / 0x100000L <= 24L) {
                    sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", this.siteid);
                    sqlFactory.addParameter("createby", this.username);
                    sqlFactory.addParameter("type", "thumbnail");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", "s_" + (String)obsfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getMinImageUrl(obsfilename) + "?attname=s_" + filename);
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("s_" + (String)obsfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                    sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", this.siteid);
                    sqlFactory.addParameter("createby", this.username);
                    sqlFactory.addParameter("type", "compressed");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", "c_" + (String)obsfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getCompressImageUrl(obsfilename) + "?attname=c_" + filename);
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("c_" + (String)obsfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                }
                obsfilemap.remove(obsfilename);
                bucketFile.close();
                attachmentidsarray.add((Object)attachmentid);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.dbConnect.runSqlUpdate(SQLlist);
        for (Object o : attachmentidsarray) {
            beans.attachment.Attachment.RefreshFolderPath(this, (Long)o);
        }
        JSONObject object = new JSONObject();
        object.put("attachmentids", (Object)attachmentidsarray);
        resultObject.put("data", (Object)object);
        int filecount = obsfilenamesArray.size();
        if (filecount == SQLlist.size()) {
            resultObject.put("code", (Object)1);
            resultObject.put("msg", (Object)("\u6210\u529f\u4e0a\u4f20" + filecount + "\u4e2a\u6587\u4ef6"));
        } else if (filecount > SQLlist.size() && SQLlist.size() > 0) {
            resultObject.put("code", (Object)1);
            resultObject.put("msg", (Object)("\u6210\u529f\u4e0a\u4f20" + SQLlist.size() + "\u4e2a\u6587\u4ef6,\u5931\u8d25" + (filecount - SQLlist.size()) + "\u4e2a"));
        } else if (SQLlist.size() == 0) {
            resultObject.put("code", (Object)0);
            resultObject.put("msg", (Object)"\u4e0a\u4f20\u5931\u8d25");
        }
        if (!"".equals(this.content.getString("ownertable")) && this.content.getLongValue("ownerid") > 0L && !"".equals(this.content.getString("usetype"))) {
            this.content.put("attachmentids", (Object)attachmentidsarray);
            Attachment attachment = new Attachment(this.content);
            try {
                attachment.createFileLink();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resultObject.put("attinfos", (Object)attachment.queryFileLink());
        }
        return resultObject.toString();
    }

    @API(title="\u83b7\u53d6\u534e\u4e3a\u4e91\u6587\u4ef6\u5939\u4e0b\u8f7d\u8def\u5f84", apiversion=R.ID10020101.v1.class)
    public String createAndGetPackFileUrl() throws YosException {
        String url = "";
        long folderid = this.content.getLong("attachmentid");
        Rows folderrows = this.dbConnect.runSqlQuery("select * from sys_attachment where siteid='" + this.siteid + "' and isfolder=1 and attachmentid='" + folderid + "'");
        BucketFile bucketFile = new BucketFile(this.siteid);
        if (folderrows.isNotEmpty()) {
            String foldername = folderrows.get(0).getString("document");
            String packfilepath = "cacheFiles/" + Calendar.getInstance().getTimeInMillis() + "/" + foldername + ".zip";
            SQLFactory sqlFactory = new SQLFactory(this, "\u6587\u4ef6\u5939\u5185\u9644\u4ef6\u4fe1\u606f\u67e5\u8be2");
            sqlFactory.addParameter("attachmentid", folderid);
            sqlFactory.addParameter("siteid", this.siteid);
            Rows subrows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
            JSONArray filesArray = new JSONArray();
            HashMap<String, String> filenamemap = new HashMap<String, String>();
            for (Row subrow : subrows) {
                String document = subrow.getString("document");
                String serialnumber = subrow.getString("serialnumber");
                String attachmentid = subrow.getString("attachmentid");
                String parentid = subrow.getString("parentid");
                boolean isfolder = subrow.getBoolean("isfolder");
                if (Long.parseLong(parentid) == folderid || !filenamemap.containsKey(parentid)) {
                    filenamemap.put(attachmentid, document);
                } else if (filenamemap.containsKey(parentid)) {
                    filenamemap.put(attachmentid, (String)filenamemap.get(parentid) + "/" + document);
                }
                if (isfolder || !bucketFile.doesObjectExist(serialnumber)) continue;
                JSONObject fileObject = new JSONObject();
                fileObject.put("filepath", (Object)serialnumber);
                fileObject.put("packpath", filenamemap.get(attachmentid));
                filesArray.add((Object)fileObject);
            }
            url = bucketFile.getPackFileUrl(packfilepath, filesArray);
        }
        return this.getSucReturnObject().addKeyValue("url", url).toString();
    }

    private boolean isImage(String filetype) {
        String[] imagetypes;
        for (String imagetype : imagetypes = new String[]{"JPG", "JPEG", "PNG", "webp"}) {
            if (!filetype.equalsIgnoreCase(imagetype)) continue;
            return true;
        }
        return false;
    }

    private boolean isVideo(String filetype) {
        String[] videotypes;
        for (String videotype : videotypes = new String[]{"mp4", "mov", "m4v", "3gp", "mkv", "rm", "rmvb", "wmv", "mpg", "avi", "mpeg"}) {
            if (!filetype.equalsIgnoreCase(videotype)) continue;
            return true;
        }
        return false;
    }

    @API(title="\u4e3a\u6307\u5b9a\u7684\u89c6\u9891\u521b\u5efa\u8f6c\u7801\u4efb\u52a1", apiversion=R.ID2024061812201801.v1.class)
    public String createTranscodingTask() throws YosException {
        if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
            long attachmentid = this.content.getLong("attachmentid");
            Rows rows = this.dbConnect.runSqlQuery("select * from sys_attachment where attachmentid=" + attachmentid);
            for (Row row : rows) {
                String filetype = row.getString("postfix");
                String serialnumber = row.getString("serialnumber");
                String att_siteid = row.getString("siteid");
                if (!this.isVideo(filetype)) continue;
                String mpctaskid = new MpcFactory().createTranscodingTask(att_siteid, serialnumber);
                this.dbConnect.runSqlUpdate("update sys_attachment set mpctaskid='" + mpctaskid + "',mpctaskstatus=0 where attachmentid='" + attachmentid + "'");
                try {
                    if (!this.dbConnect.runSqlQuery("select * from sys_attachment where parentid=" + attachmentid + " and type='cover' and postfix='jpg'").isEmpty()) continue;
                    this.createthumbnail();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.getSucReturnObject().toString();
    }

    @API(title="\u67e5\u8be2\u8f6c\u7801\u4efb\u52a1", apiversion=R.ID2024061812421301.v1.class)
    public String queryTranscodingTask() throws YosException {
        long attachmentid = this.content.getLong("attachmentid");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_attachment where attachmentid='" + attachmentid + "'");
        for (Row row : rows) {
            String mpctaskid = row.getString("mpctaskid");
            int mpctaskstatus = row.getInteger("mpctaskstatus");
            if (mpctaskid.equals("") || mpctaskstatus != 0) {
                return this.getErrReturnObject().setErrMsg("\u5f53\u524d\u89c6\u9891\u6ca1\u6709\u6b63\u5728\u6267\u884c\u7684\u8f6c\u7801\u4efb\u52a1").toString();
            }
            String postfix = row.getString("postfix");
            String document = row.getString("document");
            String att_siteid = row.getString("siteid");
            MpcFactory mpcFactory = new MpcFactory();
            MpcFile mpcFile = mpcFactory.queryTranscodingTask(mpctaskid);
            if (mpcFile == null) continue;
            if (mpcFile.isSuccessed()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_attachment");
                insertSQL.setValue("parentid", attachmentid);
                insertSQL.setValue("attachmentid", this.createTableID("sys_attachment"));
                insertSQL.setValue("siteid", att_siteid);
                insertSQL.setValue("createby", this.username);
                insertSQL.setValue("type", "hls");
                insertSQL.setValue("postfix", postfix);
                insertSQL.setValue("serialnumber", mpcFile.getObject());
                insertSQL.setValue("document", document);
                insertSQL.setValue("url", new BucketFile(att_siteid).getFileUrl(mpcFile.getObject() + "/" + mpcFile.getOutput_file_name()) + "?attname=" + document);
                insertSQL.setValue("contentlength", 0);
                insertSQL.insert();
                this.dbConnect.runSqlUpdate("update sys_attachment set mpctaskstatus=1 where attachmentid=" + attachmentid);
                continue;
            }
            this.dbConnect.runSqlUpdate("update sys_attachment set mpctaskstatus=-1 where attachmentid=" + attachmentid);
            return this.getErrReturnObject().setErrMsg("\u8f6c\u7801\u5931\u8d25").toString();
        }
        return this.getSucReturnObject().toString();
    }

    @API(title="\u4e3a\u6307\u5b9a\u7684\u89c6\u9891\u9644\u4ef6\u751f\u6210\u4e00\u4e2a\u89c6\u9891\u5c01\u9762\u622a\u56fe", apiversion=R.ID10020201.v1.class)
    public String createthumbnail() throws YosException {
        MediaMetaData mediaMetaData;
        long attachmentid = this.content.getLong("attachmentid");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_attachment where attachmentid=" + attachmentid);
        if (rows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230id\u4e3a" + attachmentid + "\u7684\u89c6\u9891\u9644\u4ef6\u4fe1\u606f").toString();
        }
        String serialnumber = rows.get(0).getString("serialnumber");
        String att_siteid = rows.get(0).getString("siteid");
        BucketFile bucketFile = new BucketFile(att_siteid);
        if (!bucketFile.doesObjectExist(serialnumber)) {
            return this.getErrReturnObject().setErrMsg("OBS\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89c6\u9891\u6587\u4ef6").toString();
        }
        MpcFactory mpcFactoryV2 = new MpcFactory();
        String thumbnail_serialfilename = this.createMD5FileName() + ".jpg";
        boolean thumbnail_succsed = mpcFactoryV2.createThumbnailsTask(att_siteid, serialnumber, thumbnail_serialfilename, (mediaMetaData = mpcFactoryV2.getMetaData(att_siteid, serialnumber)).getWidth(), mediaMetaData.getHeight(), 1);
        if (thumbnail_succsed) {
            SQLFactory sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
            sqlFactory.addParameter("parentid", attachmentid);
            sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
            sqlFactory.addParameter("siteid", att_siteid);
            sqlFactory.addParameter("createby", this.username);
            sqlFactory.addParameter("type", "cover");
            sqlFactory.addParameter("postfix", "jpg");
            sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
            sqlFactory.addParameter("document", thumbnail_serialfilename);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename) + "?attname=" + thumbnail_serialfilename);
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
            this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
            beans.attachment.Attachment.RefreshFolderPath(this, attachmentid);
            return this.getSucReturnObject().setData(this.getAttachmentUrl(attachmentid).getRow(0)).toString();
        }
        return this.getErrReturnObject().toString();
    }
}

