/*
 * Decompiled with CFR 0.152.
 */
package common.mq;

import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;

public class MQJMX {
    BrokerViewMBean brokerViewMBean;
    MBeanServerConnection connection;

    public MQJMX() throws Exception {
        String jmxserviceURL = "service:jmx:rmi:///jndi/rmi://192.168.0.201:1099/jmxrmi";
        String objectName = "org.apache.activemq:brokerName=localhost,type=Broker";
        JMXServiceURL url = new JMXServiceURL(jmxserviceURL);
        String[] credentials = new String[]{"admin", "public"};
        HashMap<String, String[]> props = new HashMap<String, String[]>();
        props.put("jmx.remote.credentials", credentials);
        JMXConnector connector = JMXConnectorFactory.connect(url, props);
        connector.connect();
        this.connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName(objectName);
        this.brokerViewMBean = MBeanServerInvocationHandler.newProxyInstance(this.connection, name, BrokerViewMBean.class, true);
    }

    public BrokerViewMBean getBrokerViewMBean() {
        return this.brokerViewMBean;
    }

    public long getCurrentConnectionsCount() throws Exception {
        return this.brokerViewMBean.getCurrentConnectionsCount();
    }

    public long getTotalConsumerCount() throws Exception {
        return this.brokerViewMBean.getTotalConsumerCount();
    }

    public long getMemoryLimit() {
        return this.brokerViewMBean.getMemoryLimit();
    }

    public long getMemoryPercentUsage() {
        return this.brokerViewMBean.getMemoryPercentUsage();
    }

    public ObjectName[] getTopics() throws Exception {
        return this.brokerViewMBean.getTopics();
    }

    public ObjectName[] getTopicSubscribers() throws Exception {
        return this.brokerViewMBean.getTopicSubscribers();
    }

    public ObjectName[] getDurableTopicSubscribers() throws Exception {
        return this.brokerViewMBean.getDurableTopicSubscribers();
    }

    public ObjectName[] getInactiveDurableTopicSubscribers() throws Exception {
        return this.brokerViewMBean.getInactiveDurableTopicSubscribers();
    }

    public void destroyDurableSubscriber(String clientid, String subscriberName) throws Exception {
        this.brokerViewMBean.destroyDurableSubscriber(clientid, subscriberName);
    }

    public void removeTopic(String topic) throws Exception {
        this.brokerViewMBean.removeTopic(topic);
    }
}

