/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import com.sun.management.OperatingSystemMXBean;
import common.BaseClass;
import common.YosException;
import common.YosLogger;
import common.data.Rows;
import common.data.db.DBConnect;
import common.parameter.License;
import common.parameter.properties;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import utility.tools.Math;

public class DBConnectPool
implements YosLogger {
    public static HashMap<String, Properties> propertiesMap = new HashMap();
    public static HashMap<String, LinkedList<YosConnection>> POOLS_MAP = new HashMap();
    public static HashMap<String, LinkedList<String>> useingConnectionkeyMap = new HashMap();
    public static Boolean isstarting = false;
    public static ArrayList<Long> connectionIDList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YosConnection getConnect(String datakey) {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            YosConnection yosconnection = null;
            if (POOLS_MAP.containsKey(datakey) && POOLS_MAP.get(datakey).size() > 0) {
                yosconnection = POOLS_MAP.get(datakey).remove(0);
            } else if (!POOLS_MAP.containsKey(datakey)) {
                POOLS_MAP.put(datakey, new LinkedList());
                useingConnectionkeyMap.put(datakey, new LinkedList());
            }
            try {
                if (yosconnection == null || yosconnection.getConnection() == null || yosconnection.getConnection().isClosed()) {
                    yosconnection = DBConnectPool.buildConnect(datakey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            useingConnectionkeyMap.get(datakey).add(yosconnection.getConkey());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return yosconnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static YosConnection buildConnect(String datakey) throws YosException {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            YosConnection yosConnection;
            Properties prop;
            if (!propertiesMap.containsKey(datakey) && (prop = DBConnectPool.getDataSource(datakey)) != null && !prop.isEmpty()) {
                propertiesMap.put(datakey, prop);
            }
            Properties p = propertiesMap.get(datakey);
            try {
                Class.forName(p.getProperty("system.db.driver"));
                Connection conn = DriverManager.getConnection(p.getProperty("system.db.url"), p.getProperty("system.db.username"), p.getProperty("system.db.password"));
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(2);
                yosConnection = new YosConnection(datakey, conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
                DBConnectPool.restartMySqlService(datakey, e);
                throw new YosException("\u521b\u5efa" + datakey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
            }
            catch (ClassNotFoundException e) {
                throw new YosException("\u521b\u5efa" + datakey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01\u627e\u4e0d\u5230\u9a71\u52a8" + p.getProperty("system.db.driver"));
            }
            return yosConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartMySqlService(String datakey, SQLException e) {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            if (!isstarting.booleanValue() && datakey.equals("default") && e.getSQLState().equals("08S01")) {
                isstarting = true;
                try {
                    OperatingSystemMXBean system2 = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                    if (system2.getName().contains("Windows")) {
                        ProcessBuilder processBuilder = new ProcessBuilder("net", "start", properties.getYosProperties().getProperty("system.db.servicename", "mysql80"));
                        processBuilder.redirectErrorStream(true);
                        Process process = processBuilder.start();
                        process.waitFor();
                        logger.info((Object)"MySQL service restarted.");
                        Thread.sleep(2000L);
                    }
                }
                catch (IOException | InterruptedException e2) {
                    e2.printStackTrace();
                }
                isstarting = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(YosConnection yosConnection) {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            try {
                if (yosConnection.isneedclose()) {
                    yosConnection.close();
                } else if (!yosConnection.isClosed()) {
                    POOLS_MAP.get(yosConnection.datakey).add(yosConnection);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.err.println(yosConnection.datakey + "\u8fde\u63a5\u5173\u95ed\u5931\u8d25" + BaseClass.getDateTime_Str() + e.getMessage());
            }
            finally {
                useingConnectionkeyMap.get(yosConnection.datakey).remove(yosConnection.getConkey());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Properties getDataSource(String datakey) throws YosException {
        Properties prop = new Properties();
        switch (datakey) {
            case "default": {
                return properties.getYosProperties();
            }
        }
        DBConnect dbConnect = new DBConnect();
        String sql = "select driver,username,password,url,isdataarchive,dbname from sys_datasource where datakey='" + datakey + "'";
        Rows rows = dbConnect.runSqlQuery(sql);
        if (!rows.isEmpty()) {
            if (rows.get(0).getBoolean("isdataarchive")) {
                Properties sysp = properties.getYosProperties();
                prop.setProperty("system.db.driver", sysp.getProperty("system.db.driver"));
                prop.setProperty("system.db.username", sysp.getProperty("system.db.username"));
                prop.setProperty("system.db.password", sysp.getProperty("system.db.password"));
                String url = sysp.getProperty("system.db.url");
                url = url.replace(url.substring(url.lastIndexOf("/") + 1), rows.get(0).getString("dbname"));
                prop.setProperty("system.db.url", url);
                prop.setProperty("system.db.isdataarchive", "1");
            } else {
                prop.setProperty("system.db.driver", rows.get(0).getString("driver"));
                prop.setProperty("system.db.username", rows.get(0).getString("username"));
                prop.setProperty("system.db.password", rows.get(0).getString("password"));
                prop.setProperty("system.db.url", rows.get(0).getString("url"));
                prop.setProperty("system.db.isdataarchive", "0");
            }
        } else {
            return null;
        }
        return prop;
    }

    public static class YosConnection {
        private Connection connection;
        private Long createtime = Calendar.getInstance().getTimeInMillis();
        private String datakey;
        private String conkey;
        private Long conid;

        private YosConnection(String datakey, Connection connection) {
            this.datakey = datakey;
            this.connection = connection;
            this.conkey = this.datakey + "-" + this.createtime + "-" + Math.random(5);
            try {
                if (this.connection.getMetaData().getDatabaseProductName().equalsIgnoreCase("mysql")) {
                    PreparedStatement statement = this.connection.prepareStatement("SELECT CONNECTION_ID() as conid;");
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        this.conid = resultSet.getLong("conid");
                        connectionIDList.add(this.conid);
                    }
                    statement.executeUpdate("set GLOBAL innodb_lock_wait_timeout=15");
                    resultSet.close();
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Connection getConnection() {
            return this.connection;
        }

        public String getDatakey() {
            return this.datakey;
        }

        public String getConkey() {
            return this.conkey;
        }

        public boolean isneedclose() {
            if (Calendar.getInstance().getTimeInMillis() - this.createtime > 3600000L || POOLS_MAP.get(this.datakey).size() + useingConnectionkeyMap.get(this.datakey).size() > License.get().getMaxDBConCount()) {
                return true;
            }
            try {
                if (!this.getConnection().isValid(1000)) {
                    return true;
                }
            }
            catch (Exception e) {
                return true;
            }
            return false;
        }

        private void close() throws SQLException {
            if (!this.isClosed()) {
                this.connection.close();
            }
            connectionIDList.remove(this.conid);
        }

        public boolean isClosed() throws SQLException {
            return this.connection.isClosed();
        }
    }
}

