/*
 * Decompiled with CFR 0.152.
 */
package beans.remind;

import beans.parameter.Parameter;
import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.InsertSQL;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.parameter;
import common.websocket.WebSocket;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import utility.email.Email;
import utility.email.EmailContent;
import utility.sms.Sms;

public class Remind {
    private String type = "\u7cfb\u7edf";
    private String title = "";
    private String content = "";
    private ArrayList<String> tophonenumber = new ArrayList();
    private ArrayList<String> toemail = new ArrayList();
    private String objectname = "null";
    private Long objectid = 0L;
    private Controller controller;
    private String siteid = "";
    private JSONArray systemappids = new JSONArray();
    private ArrayList<Long> touserid = new ArrayList();
    private EmailContent emailContent = null;

    public static void autoRemind(Controller controller, String remindname, long dataid) throws YosException {
        Remind.autoRemind(controller, remindname, dataid, "");
    }

    public static void autoRemind(Controller controller, String remindname, long dataid, String content) throws YosException {
        Rows sys_remind_configsRows = controller.dbConnect.runSqlQuery("select t2.ownertable,t1.remindtitle,t1.remindmode,t1.content,t1.isrole,t1.roleids,t1.isuser,t1.userids,t1.issql,t1.sqlstr,t1.systemappids from sys_remind_configs t1 inner join sys_remind_config t2 on t1.sys_remind_configid=t2.sys_remind_configid where siteid='" + controller.siteid + "' and t2.remindname='" + remindname + "'");
        if (sys_remind_configsRows.isNotEmpty()) {
            int end;
            int start;
            String parm;
            String sql;
            Rows rows;
            Rows datarows;
            String ownertable = sys_remind_configsRows.get(0).getString("ownertable");
            String remindtitle = sys_remind_configsRows.get(0).getString("remindtitle");
            JSONArray remindmodeArray = sys_remind_configsRows.get(0).getJSONArray("remindmode");
            if (content.equals("")) {
                content = sys_remind_configsRows.get(0).getString("content");
            }
            boolean isrole = sys_remind_configsRows.get(0).getBoolean("isrole");
            boolean isuser = sys_remind_configsRows.get(0).getBoolean("isuser");
            boolean issql = sys_remind_configsRows.get(0).getBoolean("issql");
            JSONArray systemappids = sys_remind_configsRows.get(0).getJSONArray("systemappids");
            LinkedHashSet useridList = new LinkedHashSet();
            if (isrole) {
                JSONArray roleids = sys_remind_configsRows.get(0).getJSONArray("roleids");
                for (Object o : roleids) {
                    useridList.addAll(controller.dbConnect.runSqlQuery("select userid from sys_userrole where siteid='" + controller.siteid + "' and roleid=" + o).toArrayList("userid", new ArrayList()));
                }
            }
            if (isuser) {
                JSONArray userids = sys_remind_configsRows.get(0).getJSONArray("userids");
                for (Object o : userids) {
                    useridList.add(Long.parseLong(o.toString()));
                }
            }
            if (issql) {
                Rows datarows2;
                String sqlstr = sys_remind_configsRows.get(0).getString("sqlstr");
                if (sqlstr.contains(":") && (datarows2 = controller.dbConnect.runSqlQuery("select * from " + ownertable + " where " + controller.getuniquecolumnname(ownertable) + "=" + dataid)).isNotEmpty()) {
                    for (String key : datarows2.get(0).keySet()) {
                        if (!sqlstr.contains(":" + key)) continue;
                        sqlstr = sqlstr.replace(":" + key, "'" + datarows2.get(0).getString(key) + "'");
                    }
                }
                try {
                    useridList.addAll(controller.dbConnect.runSqlQuery(sqlstr).toArrayList("userid", new ArrayList()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (content.contains(":") && (datarows = controller.dbConnect.runSqlQuery("select * from " + ownertable + " where " + controller.getuniquecolumnname(ownertable) + "=" + dataid)).isNotEmpty()) {
                for (String key : datarows.get(0).keySet()) {
                    if (!content.contains(":" + key)) continue;
                    content = content.replace(":" + key, "'" + datarows.get(0).getString(key) + "'");
                }
            }
            int max = 10;
            while (content.contains("{") && content.contains("}") && (rows = controller.dbConnect.runSqlQuery(sql = (parm = content.substring(start = content.indexOf("{"), (end = content.indexOf("}")) + 1)).replace("{", "").replace("}", ""))).size() == 1 && rows.getFieldList().size() == 1) {
                String value = rows.get(0).getString(rows.getFieldList().get(0));
                content = content.replace(parm, value);
                if (max-- != 0) continue;
                break;
            }
            block23: for (Object o : remindmodeArray) {
                String remindmode;
                switch (remindmode = (String)o) {
                    case "\u90ae\u4ef6": {
                        for (Long userid : useridList) {
                            try {
                                EmailContent emailContent = new EmailContent();
                                emailContent.addText(content);
                                Remind remind = new Remind(controller);
                                remind.setTitle(remindtitle);
                                remind.setToemail(User.getUserMailAddress(controller, userid));
                                remind.setContent(emailContent);
                                remind.sendByMail();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue block23;
                    }
                    case "\u77ed\u4fe1": {
                        Remind remind;
                        for (Long userid : useridList) {
                            try {
                                remind = new Remind(controller);
                                remind.setContent(content);
                                remind.setTophonenumber(User.getUserPhonenumber(controller, (long)userid));
                                remind.sendBySms();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue block23;
                    }
                    case "\u5f39\u6846": {
                        Remind remind;
                        for (Long userid : useridList) {
                            try {
                                remind = new Remind(controller);
                                remind.setTitle(remindtitle);
                                remind.setContent(content);
                                remind.setTouserid(userid);
                                remind.setTophonenumber(User.getUserPhonenumber(controller, (long)userid));
                                remind.setSystemappids(systemappids);
                                remind.sendByDialogMsg();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static void autoDataRemind(String siteid, String remindname, String ownertable, long dataid) throws YosException {
        Remind.autoDataRemind(siteid, remindname, ownertable, dataid, "");
    }

    public static void autoDataRemind(String siteid, String remindname, String ownertable, long dataid, String content) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows sys_remind_configsRows = dbConnect.runSqlQuery("select t2.ownertable,t1.remindtitle,t1.remindmode,t1.content,t1.isrole,t1.roleids,t1.isuser,t1.userids,t1.issql,t1.sqlstr,t1.siteid,t1.systemappids from sys_remind_configs t1 inner join sys_remind_config t2 on t1.sys_remind_configid=t2.sys_remind_configid where t2.remindname='" + remindname + "' and t2.ownertable='" + ownertable + "' and t1.ownerid='" + dataid + "' and t1.siteid='" + siteid + "'");
        if (sys_remind_configsRows.isNotEmpty()) {
            int end;
            int start;
            String parm;
            String sql;
            Rows rows;
            Rows datarows;
            String remindtitle = sys_remind_configsRows.get(0).getString("remindtitle");
            JSONArray remindmodeArray = sys_remind_configsRows.get(0).getJSONArray("remindmode");
            if (content.equalsIgnoreCase("")) {
                content = sys_remind_configsRows.get(0).getString("content");
            }
            JSONArray systemappids = sys_remind_configsRows.get(0).getJSONArray("systemappids");
            boolean isrole = sys_remind_configsRows.get(0).getBoolean("isrole");
            boolean isuser = sys_remind_configsRows.get(0).getBoolean("isuser");
            boolean issql = sys_remind_configsRows.get(0).getBoolean("issql");
            LinkedHashSet useridList = new LinkedHashSet();
            if (isrole) {
                JSONArray roleids = sys_remind_configsRows.get(0).getJSONArray("roleids");
                for (Object o : roleids) {
                    useridList.addAll(dbConnect.runSqlQuery("select userid from sys_userrole where siteid='" + siteid + "' and roleid=" + o).toArrayList("userid", new ArrayList()));
                }
            }
            if (isuser) {
                JSONArray userids = sys_remind_configsRows.get(0).getJSONArray("userids");
                for (Object o : userids) {
                    useridList.add(Long.parseLong(o.toString()));
                }
            }
            if (issql) {
                Rows datarows2;
                String sqlstr = sys_remind_configsRows.get(0).getString("sqlstr");
                if (sqlstr.contains(":") && (datarows2 = dbConnect.runSqlQuery("select * from " + ownertable + " where " + new BaseClass().getuniquecolumnname(ownertable) + "=" + dataid)).isNotEmpty()) {
                    for (String key : datarows2.get(0).keySet()) {
                        if (!sqlstr.contains(":" + key)) continue;
                        sqlstr = sqlstr.replace(":" + key, "'" + datarows2.get(0).getString(key) + "'");
                    }
                }
                try {
                    useridList.addAll(dbConnect.runSqlQuery(sqlstr).toArrayList("userid", new ArrayList()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (content.contains(":") && (datarows = dbConnect.runSqlQuery("select * from " + ownertable + " where " + new BaseClass().getuniquecolumnname(ownertable) + "=" + dataid)).isNotEmpty()) {
                for (String key : datarows.get(0).keySet()) {
                    if (!content.contains(":" + key)) continue;
                    content = content.replace(":" + key, "'" + datarows.get(0).getString(key) + "'");
                }
            }
            int max = 10;
            while (content.contains("{") && content.contains("}") && (rows = dbConnect.runSqlQuery(sql = (parm = content.substring(start = content.indexOf("{"), (end = content.indexOf("}")) + 1)).replace("{", "").replace("}", ""))).size() == 1 && rows.getFieldList().size() == 1) {
                String value = rows.get(0).getString(rows.getFieldList().get(0));
                content = content.replace(parm, value);
                if (max-- != 0) continue;
                break;
            }
            block23: for (Object o : remindmodeArray) {
                String remindmode;
                switch (remindmode = (String)o) {
                    case "\u90ae\u4ef6": {
                        for (Long userid : useridList) {
                            try {
                                EmailContent emailContent = new EmailContent();
                                emailContent.addText(content);
                                Remind remind = new Remind(siteid);
                                remind.setTitle(remindtitle);
                                remind.setToemail(User.getUserMailAddress(dbConnect, siteid, userid));
                                remind.setContent(emailContent);
                                remind.sendByMail();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue block23;
                    }
                    case "\u77ed\u4fe1": {
                        Remind remind;
                        for (Long userid : useridList) {
                            try {
                                remind = new Remind(siteid);
                                remind.setContent(content);
                                remind.setTophonenumber(User.getUserPhonenumber(dbConnect, (long)userid));
                                remind.sendBySms();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue block23;
                    }
                    case "\u5f39\u6846": {
                        Remind remind;
                        for (Long userid : useridList) {
                            try {
                                remind = new Remind(siteid);
                                remind.setTitle(remindtitle);
                                remind.setContent(content);
                                remind.setTouserid(userid);
                                remind.setTophonenumber(User.getUserPhonenumber(dbConnect, (long)userid));
                                remind.setSystemappids(systemappids);
                                remind.sendByDialogMsg();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public Remind(Controller controller) {
        this.controller = controller;
        this.siteid = this.controller.siteid;
    }

    public Remind(String siteid) throws YosException {
        this.siteid = siteid;
        JSONObject object = new JSONObject();
        object.put("siteid", (Object)siteid);
        this.controller = new Controller(object);
        this.controller.siteid = this.siteid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContent(EmailContent emailContent) {
        this.emailContent = emailContent;
    }

    public void setTophonenumber(String phonenumber) {
        this.tophonenumber.add(phonenumber);
    }

    public void setTophonenumber(ArrayList<String> tophonenumber) {
        this.tophonenumber = tophonenumber;
    }

    public void setToemail(String toemail) {
        this.toemail.add(toemail);
    }

    public void setToemail(ArrayList<String> toemail) {
        this.toemail = toemail;
    }

    public void setToemail(Long userid) throws YosException {
        this.toemail = User.getUserMailAddress(this.controller, userid);
    }

    public void setObjectname(String objectname) {
        this.objectname = objectname;
    }

    public void setObjectid(Long objectid) {
        this.objectid = objectid;
    }

    public void setTouserid(ArrayList<Long> userid) {
        this.touserid = userid;
    }

    public void setTouserid(long userid) {
        this.touserid.add(userid);
    }

    public void setType(String type) {
        this.type = type;
    }

    public JSONArray getSystemappids() {
        return this.systemappids;
    }

    public void setSystemappids(JSONArray systemappids) {
        this.systemappids = systemappids;
    }

    public Remind sendByMail() throws YosException {
        if (!Parameter.get(this.siteid, "remind_mail").equalsIgnoreCase("1")) {
            return this;
        }
        if (this.siteid.equals("") || this.title.equals("") || this.toemail.size() == 0 || this.emailContent == null && this.content.equals("")) {
            return this;
        }
        try {
            Email email = new Email(this.siteid, this.title, this.toemail);
            if (this.emailContent == null) {
                EmailContent content = new EmailContent();
                content.addText(this.title);
                content.addBr();
                content.addText(this.content);
                email.send(this.siteid, content);
            } else {
                email.send(this.siteid, this.emailContent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new YosException(e.toString());
        }
        return this;
    }

    public Remind sendBySms() throws YosException {
        if (this.siteid.equals("") || this.content.equals("") || this.tophonenumber.size() == 0) {
            return this;
        }
        for (String phonenumber : this.tophonenumber) {
            Sms sms = new Sms();
            sms.sendout(this.siteid, phonenumber, this.content);
        }
        return this;
    }

    public Remind sendByDialogMsg() throws YosException {
        if (this.type.equals("") || this.title.equals("") || this.content.equals("") || this.touserid.size() == 0) {
            return this;
        }
        for (Long userid : this.touserid) {
            for (long usersiteid : User.getUserSiteid(this.controller, userid)) {
                boolean isread = false;
                if (parameter.websocketClients.containsKey(usersiteid)) {
                    JSONObject methodobject = new JSONObject();
                    methodobject.put("class", (Object)"remind");
                    methodobject.put("type", (Object)this.type);
                    methodobject.put("title", (Object)this.title);
                    methodobject.put("text", (Object)this.content);
                    for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                        webClientSocket.sendSystemMessage(methodobject);
                    }
                    isread = true;
                }
                InsertSQL insertSQL = SQLFactory.createInsertSQL(new DBConnect(), "sys_message");
                insertSQL.setValue("siteid", this.siteid);
                insertSQL.setValue("userid", userid);
                insertSQL.setValue("title", this.title);
                insertSQL.setValue("message", this.content);
                if (!this.systemappids.isEmpty()) {
                    insertSQL.setValue("systemappids", this.systemappids);
                    insertSQL.setValue("type", "\u5e94\u7528");
                } else {
                    insertSQL.setValue("type", this.type);
                }
                insertSQL.setValue("isread", isread);
                if (isread) {
                    insertSQL.setDateValue("readdate");
                }
                insertSQL.setDateValue("createdate");
                insertSQL.insert();
            }
        }
        return this;
    }

    public void createSys_message() throws YosException {
        if (this.siteid.equals("") || this.type.equals("") || this.title.equals("") || this.content.equals("") || this.touserid.size() == 0) {
            return;
        }
        for (Long userid : this.touserid) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(new DBConnect(), "sys_message");
            insertSQL.setValue("siteid", this.siteid);
            insertSQL.setValue("userid", userid);
            insertSQL.setValue("title", this.title);
            insertSQL.setValue("message", this.content);
            insertSQL.setValue("isread", 0);
            if (!this.systemappids.isEmpty()) {
                insertSQL.setValue("systemappids", this.systemappids);
                insertSQL.setValue("type", "\u5e94\u7528");
            } else {
                insertSQL.setValue("type", this.type);
            }
            insertSQL.setDateValue("createdate");
            insertSQL.insert();
        }
    }
}

