/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.miniprogram;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import java.util.Calendar;
import utility.tools.WebRequest;
import utility.wechat.miniprogram.WechatUserID;
import utility.wechat.wechatpay.POJO.CreateOrderResponse;
import utility.wechat.wechatpay.WechatPay;

public class WechatMiniProgram
extends BaseClass {
    private String appid;
    private String secret;
    private String mch_id;
    private String mch_key;
    private String systemclient;
    private static String access_token = "";
    private static long access_token_timelimit = 0L;
    private static String jsapi_ticket = "";
    private static long jsapi_ticket_timelimit = 0L;

    public WechatMiniProgram(String appid, String secret, String mch_id, String mch_key) {
        this.appid = appid;
        this.secret = secret;
        this.mch_id = mch_id;
        this.mch_key = mch_key;
    }

    public WechatMiniProgram(String systemclient) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select appid,secret,mch_id,mch_key,isvisitor,siteid,visitor_roleid from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.secret = rows.get(0).getString("secret");
            this.mch_id = rows.get(0).getString("mch_id");
            this.mch_key = rows.get(0).getString("mch_key");
        }
        this.systemclient = systemclient;
    }

    public String getMch_key() {
        return this.mch_key;
    }

    public WechatUserID getWechatUserID(String wechat_code) throws YosException {
        WechatUserID wechatUserID = new WechatUserID();
        WebRequest request = new WebRequest();
        String result = request.doGet("https://api.weixin.qq.com/sns/jscode2session?appid=" + this.appid + "&secret=" + this.secret + "&js_code=" + wechat_code + "&grant_type=authorization_code");
        JSONObject openidobject = JSONObject.parseObject((String)result);
        wechatUserID.setSucc(openidobject.containsKey("openid"));
        if (openidobject.containsKey("openid")) {
            wechatUserID.setOpenid(openidobject.getString("openid"));
        }
        if (openidobject.containsKey("unionid")) {
            wechatUserID.setUnionid(openidobject.getString("unionid"));
        }
        if (openidobject.containsKey("session_key")) {
            wechatUserID.setSession_key(openidobject.getString("session_key"));
        }
        wechatUserID.setResult(result);
        return wechatUserID;
    }

    public JSONObject getWechatUserPhonenumber(String code) throws YosException {
        WebRequest webRequest = new WebRequest();
        JSONObject object = new JSONObject();
        object.put("code", (Object)code);
        String result = webRequest.doPost(object.toString(), "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + this.getAccessToken());
        JSONObject resultObject = JSON.parseObject((String)result);
        if (resultObject.containsKey("errcode") && resultObject.getInteger("errcode") == 0 && resultObject.containsKey("phone_info")) {
            JSONObject phone_infoObject = resultObject.getJSONObject("phone_info");
            phone_infoObject.remove("watermark");
            return phone_infoObject;
        }
        return null;
    }

    public CreateOrderResponse createPayOrder(String out_trade_no, String trade_type, String wechat_code, String custip, String ordertype, String title) throws YosException {
        WechatPay wechatPay = new WechatPay(this.systemclient);
        return wechatPay.createPayOrder(out_trade_no, trade_type, this.getWechatUserID(wechat_code).getOpenid(), custip, ordertype, title);
    }

    private String getAccessToken() throws YosException {
        String url;
        String res;
        JSONObject resobject;
        long nowtime = Calendar.getInstance().getTimeInMillis();
        if (access_token_timelimit < nowtime && (resobject = JSONObject.parseObject((String)(res = new WebRequest().doGet(url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appid + "&secret=" + this.secret)))).containsKey("access_token")) {
            access_token = resobject.getString("access_token");
            access_token_timelimit = nowtime + 1000L * (long)resobject.getIntValue("expires_in");
        }
        return access_token;
    }

    public String getJsApi_Ticket() throws YosException {
        long nowtime = Calendar.getInstance().getTimeInMillis();
        if (jsapi_ticket_timelimit < nowtime) {
            WebRequest webRequest = new WebRequest();
            String res = webRequest.doGet("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + this.getAccessToken() + "&type=jsapi");
            JSONObject resobject = JSONObject.parseObject((String)res);
            if (resobject.getIntValue("errcode") == 0 && resobject.containsKey("ticket")) {
                jsapi_ticket = resobject.getString("ticket");
                jsapi_ticket_timelimit = nowtime + 1000L * (long)resobject.getIntValue("expires_in");
            } else {
                throw new YosException(res);
            }
        }
        return jsapi_ticket;
    }

    public class Analysis {
        public void getUserPortrait() throws YosException {
            WebRequest webRequest = new WebRequest();
            JSONObject object = new JSONObject();
            object.put("begin_date", (Object)"20220728");
            object.put("end_date", (Object)"20220728");
            String result = webRequest.doPost(object.toString(), "https://api.weixin.qq.com/datacube/getweanalysisappiduserportrait?access_token=" + WechatMiniProgram.this.getAccessToken());
            JSONObject resultObject = JSON.parseObject((String)result);
            System.out.println(resultObject);
        }

        public void getVisitPage() throws YosException {
            WebRequest webRequest = new WebRequest();
            JSONObject object = new JSONObject();
            object.put("begin_date", (Object)"20220727");
            object.put("end_date", (Object)"20220727");
            String result = webRequest.doPost(object.toString(), "https://api.weixin.qq.com/datacube/getweanalysisappidvisitpage?access_token=" + WechatMiniProgram.this.getAccessToken());
            JSONObject resultObject = JSON.parseObject((String)result);
            System.out.println(resultObject);
        }
    }
}

