/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.attachment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import restcontroller.R;

public class Attachment
extends Controller {
    public Attachment(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u5a92\u4f53\u6587\u4ef6\u67e5\u8be2", apiversion=R.ID2024061710590401.v1.class)
    public String queryAttachment() throws YosException {
        QuerySQL attachmentQuerySQL = SQLFactory.createQuerySQL(this, "sys_attachment", new String[0]).setTableAlias("t1");
        attachmentQuerySQL.setPage(this.pageSize, this.pageNumber);
        if (!this.content.getStringValue("siteid").equals("")) {
            attachmentQuerySQL.setSiteid(this.content.getString("siteid"));
        }
        if (!this.content.getStringValue("ownertable").equals("")) {
            attachmentQuerySQL.setWhere("exists(select * from sys_attachment_links where sys_attachment_links.ownertable='" + this.content.getString("ownertable") + "'and t1.attachmentid=sys_attachment_links.attachmentid )");
        }
        if (!this.content.getStringValue("postfix").equals("")) {
            attachmentQuerySQL.setWhere("t1.postfix", this.content.getStringValue("postfix"));
        }
        if (this.content.getLongValue("ownerid") > 0L) {
            attachmentQuerySQL.setWhere("exists(select * from sys_attachment_links where sys_attachment_links.ownerid=" + this.content.getLong("ownerid") + " and t1.attachmentid=sys_attachment_links.attachmentid )");
        }
        if (this.content.getLongValue("attachmentid") > 0L) {
            if (this.content.getBooleanValue("getsub")) {
                Rows rows = beans.attachment.Attachment.get((Controller)this, this.content.getLong("attachmentid"));
                if (rows.isNotEmpty()) {
                    attachmentQuerySQL.setWhere("(parentid=" + this.content.getLong("attachmentid") + ")");
                }
            } else {
                attachmentQuerySQL.setWhere("attachmentid", this.content.getLong("attachmentid"));
            }
        } else {
            attachmentQuerySQL.setWhere("(ifnull(parentid,0)<=0 or exists(select * from sys_attachment t2 where t1.parentid=t2.attachmentid and t2.isfolder=1) )");
        }
        attachmentQuerySQL.setCondition("document", "serialnumber", "url", "createby");
        attachmentQuerySQL.setOrderBy("t1.attachmentid desc");
        Rows attachmentRows = attachmentQuerySQL.query();
        QuerySQL attachment_linksQuerySQL = SQLFactory.createQuerySQL(this, "sys_attachment_links", new String[0]).setTableAlias("t1");
        attachment_linksQuerySQL.addJoinTable(BaseClass.JOINTYPE.left, "sys_attachment_linkdatashow", "t2", "t1.ownertable=t2.ownertable", new String[0]);
        attachment_linksQuerySQL.addQueryFields("t1.attachmentid,t1.siteid,t1.jumpurl,t1.sequence,t1.changeby,t1.changedate,t1.linksid,t1.ownerid,t1.ownertable,t1.usetype,t1.createby,t1.createdate,t2.appname,t2.datafields");
        attachment_linksQuerySQL.setWhere("attachmentid", attachmentRows.toArrayList("attachmentid"));
        RowsMap attachment_linksRowsMap = attachment_linksQuerySQL.query().toRowsMap("attachmentid");
        for (Row attachmentRow : attachmentRows) {
            Rows attachment_linksRows = attachment_linksRowsMap.get(attachmentRow.getString("attachmentid"));
            for (Row attachment_linksRow : attachment_linksRows) {
                String ownertable = attachment_linksRow.getString("ownertable");
                long ownerid = attachment_linksRow.getLong("ownerid");
                if (this.dbConnect.runSqlQuery("select * from sys_object where table_name='" + ownertable + "'").isNotEmpty()) {
                    QuerySQL linkdataQuery = SQLFactory.createQuerySQL(this, ownertable, new String[0]);
                    linkdataQuery.setUniqueid(ownerid);
                    Rows linkdataRows = linkdataQuery.query();
                    if (linkdataRows.isNotEmpty()) {
                        attachment_linksRow.put("data", linkdataRows.get(0));
                        continue;
                    }
                    attachment_linksRow.put("data", new JSONObject());
                    attachment_linksRow.put("datastatus", "\u6570\u636e\u4e22\u5931");
                    continue;
                }
                attachment_linksRow.put("data", new JSONObject());
                attachment_linksRow.put("datastatus", "\u8868\u4e22\u5931");
            }
            attachmentRow.put("links", attachment_linksRows);
            long contentlength = attachmentRow.getLong("contentlength");
            if (contentlength == 0L) {
                attachmentRow.put("contentlength", "");
            } else if (contentlength / 0x100000L < 1L) {
                attachmentRow.put("contentlength", contentlength / 1024L + "KB");
            } else if (contentlength / 0x40000000L < 1L) {
                attachmentRow.put("contentlength", contentlength / 0x100000L + "MB");
            } else {
                attachmentRow.put("contentlength", contentlength / 0x40000000L + "GB");
            }
            attachmentRow.put("isImage", this.isImage(attachmentRow.getString("postfix")));
            attachmentRow.put("isVideo", this.isVideo(attachmentRow.getString("postfix")));
        }
        return this.getSucReturnObject().setData(attachmentRows).toString();
    }

    private boolean isVideo(String filetype) {
        String[] videotypes;
        for (String videotype : videotypes = new String[]{"mp4", "mov", "m4v", "3gp", "mkv", "rm", "rmvb", "wmv", "mpg", "avi", "mpeg"}) {
            if (!filetype.equalsIgnoreCase(videotype)) continue;
            return true;
        }
        return false;
    }

    private boolean isImage(String postfix) {
        String[] imagetypes;
        for (String videotype : imagetypes = new String[]{"jpg", "gif", "png", "svg", "jpeg", "webp"}) {
            if (!postfix.equalsIgnoreCase(videotype)) continue;
            return true;
        }
        return false;
    }

    @API(title="\u6570\u636e\u5173\u8054\u5c55\u793a\u89c4\u5219\u5217\u8868\u67e5\u8be2", apiversion=R.ID10008201.v1.class)
    public String querylinkdatashow() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "\u6570\u636e\u5173\u8054\u5c55\u793a\u89c4\u5219\u5217\u8868\u67e5\u8be2");
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            row.put("datafields", row.getJSONArray("datafields"));
        }
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u6570\u636e\u5173\u8054\u5c55\u793a\u89c4\u5219\u65b0\u589e\u3001\u4fee\u6539", apiversion=R.ID10008301.v1.class)
    public String insertorupdatelinkdatashow() throws YosException {
        SQLFactory sqlFactory;
        String ownertable = this.content.getString("ownertable");
        String appname = this.content.getString("appname");
        JSONArray datafields = this.content.getJSONArray("datafields");
        if (this.dbConnect.runSqlQuery("select * from sys_attachment_linkdatashow where ownertable='" + ownertable + "'").isEmpty()) {
            sqlFactory = new SQLFactory(this, "\u6570\u636e\u5173\u8054\u5c55\u793a\u89c4\u5219\u65b0\u589e");
            sqlFactory.addParameter("sys_attachment_linkdatashowid", this.createTableID("sys_attachment_linkdatashow"));
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("appname", appname);
            sqlFactory.addParameter("datafields", datafields.toJSONString());
        } else {
            sqlFactory = new SQLFactory(this, "\u6570\u636e\u5173\u8054\u5c55\u793a\u89c4\u5219\u4fee\u6539");
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("appname", appname);
            sqlFactory.addParameter("datafields", datafields.toJSONString());
        }
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u5173\u8054\u5c55\u793a\u89c4\u5219\u65b0\u589e\u3001\u4fee\u6539", apiversion=R.ID10008401.v1.class)
    public String deletelinkdatashow() throws YosException {
        String ownertable = this.content.getString("ownertable");
        this.dbConnect.runSqlUpdate("delete from sys_attachment_linkdatashow where ownertable='" + ownertable + "'");
        return this.getSucReturnObject().toString();
    }
}

