/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.BucketRetentionRules;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import com.influxdb.query.FluxTable;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InfluxDBConnect {
    private static HashMap<String, InfluxDBConnect> cmap = new HashMap();
    private InfluxDBClient influxDBClient;
    private String org;
    private String siteid;

    public InfluxDBClient getInfluxDBClient() {
        return this.influxDBClient;
    }

    public void setInfluxDBClient(InfluxDBClient influxDBClient) {
        this.influxDBClient = influxDBClient;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getSiteid() {
        return this.siteid;
    }

    public void setSiteid(String siteid) {
        this.siteid = siteid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static InfluxDBConnect getConnect(String siteid) throws YosException {
        if (cmap.containsKey(siteid)) return cmap.getOrDefault(siteid, null);
        Class<InfluxDBConnect> clazz = InfluxDBConnect.class;
        synchronized (InfluxDBConnect.class) {
            Rows rows = new DBConnect().runSqlQuery("select servername,org,orgid,token,url from sys_site t1 inner join sys_influxdb t2 on t1.sys_influxdbid=t2.sys_influxdbid where t1.siteid='" + siteid + "'");
            if (!rows.isNotEmpty()) return cmap.getOrDefault(siteid, null);
            InfluxDBConnect influxClient = new InfluxDBConnect();
            influxClient.setInfluxDBClient(InfluxDBClientFactory.create((String)rows.get(0).getString("url"), (char[])rows.get(0).getString("token").toCharArray()));
            influxClient.setOrg(rows.get(0).getString("org"));
            influxClient.setSiteid(siteid);
            cmap.put(siteid, influxClient);
            try {
                Bucket bucket = cmap.get(siteid).getInfluxDBClient().getBucketsApi().findBucketByName(siteid);
                if (bucket != null) return cmap.getOrDefault(siteid, null);
                BucketRetentionRules bucketRetentionRules = new BucketRetentionRules();
                bucketRetentionRules.setEverySeconds(Integer.valueOf(0));
                cmap.get(siteid).getInfluxDBClient().getBucketsApi().createBucket(siteid, bucketRetentionRules, rows.get(0).getString("orgid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cmap.getOrDefault(siteid, null);
        }
    }

    public static List<FluxTable> runSqlQuery(String siteid, String query) throws YosException {
        InfluxDBConnect influxDBConnect = InfluxDBConnect.getConnect(siteid);
        if (influxDBConnect != null) {
            return influxDBConnect.getInfluxDBClient().getQueryApi().query(query, influxDBConnect.getOrg());
        }
        return new ArrayList<FluxTable>();
    }

    public static void runSqlUpdate(String siteid, long w_productid, long w_deviceid, Row valueRow, HashMap<String, String> column_types, long time) throws YosException {
        InfluxDBConnect influxDBConnect = InfluxDBConnect.getConnect(siteid);
        if (influxDBConnect != null) {
            System.out.println("influxdb\u5b58\u50a8 w_productid:" + w_productid + ";w_deviceid:" + w_deviceid + "value:" + valueRow.toJsonObject() + "time:" + time);
            HashMap<String, String> tagsToAdd = new HashMap<String, String>();
            tagsToAdd.put("deviceid", String.valueOf(w_deviceid));
            Point point = Point.measurement((String)String.valueOf(w_productid));
            point.addTags(tagsToAdd);
            block12: for (String key : valueRow.keySet()) {
                switch (column_types.get(key)) {
                    case "double": {
                        point.addField(key, valueRow.getDouble(key));
                        continue block12;
                    }
                    case "int": {
                        point.addField(key, (long)valueRow.getInteger(key));
                        continue block12;
                    }
                    case "long": {
                        point.addField(key, valueRow.getLong(key));
                        continue block12;
                    }
                    case "boolean": {
                        point.addField(key, valueRow.getBoolean(key));
                        continue block12;
                    }
                }
                point.addField(key, valueRow.getString(key));
            }
            point.time(Long.valueOf(time), WritePrecision.MS);
            WriteApiBlocking writeApi = influxDBConnect.getInfluxDBClient().getWriteApiBlocking();
            writeApi.writePoint(siteid, influxDBConnect.getOrg(), point);
            System.out.println("influxdb\u5b58\u50a8\u5b8c\u6210");
        }
    }
}

