/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Controller;
import common.YosException;
import common.YosLogger;
import common.annotation.Param;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class DataFunction
implements YosLogger {
    public Controller controller;
    public DBConnect dbConnect;
    public DBConnect sysdbConnect;
    public String functionname;
    public String type;
    public String datakey;
    private String sqlstr;
    private boolean queryforpage;
    private int pageNumber = 1;
    private int pageSize = 20;
    private HashMap<String, Field> classfieldMap = new HashMap();
    private HashMap<String, Object> sys_parametermap = new HashMap();
    private HashMap<String, Object> parametermap = new HashMap();
    private HashMap<String, String[]> parametermap_array = new HashMap();

    public static DataFunction get(Controller controller, String functionname) throws YosException {
        DataFunction dataFunction = DataFunction.get(controller.dbConnect, functionname);
        dataFunction.controller = controller;
        return dataFunction;
    }

    public static DataFunction get(String functionname) throws YosException {
        return DataFunction.get(new DBConnect(), functionname);
    }

    private static DataFunction get(DBConnect dbConnect, String functionname) throws YosException {
        DataFunction dataFunction = null;
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where functionname='" + functionname + "' and status='\u542f\u7528'");
        if (rows.isNotEmpty()) {
            String classname = rows.get(0).getString("classname");
            String datakey = rows.get(0).getString("datakey").equals("") ? "default" : rows.get(0).getString("datakey");
            try {
                Class<?> clz = null;
                clz = classname.equals("") ? Class.forName("common.DataFunction") : Class.forName("function." + classname);
                Constructor<?> cla = clz.getDeclaredConstructor(new Class[0]);
                dataFunction = (DataFunction)cla.newInstance(new Object[0]);
                dataFunction.getClass().getMethod("init", DBConnect.class, Row.class).invoke((Object)dataFunction, datakey.equals(dbConnect.databasekey) ? dbConnect : new DBConnect(datakey), rows.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new YosException(e.getMessage());
            }
        }
        return dataFunction;
    }

    public void init(Controller controller, Row sys_datafunctionRow) throws YosException {
        this.controller = controller;
        this.init(controller.dbConnect, sys_datafunctionRow);
    }

    public void init(DBConnect dbConnect, Row sys_datafunctionRow) throws YosException {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            this.classfieldMap.put(field.getName(), field);
        }
        this.dbConnect = dbConnect;
        this.sysdbConnect = dbConnect.databasekey.equals("default") ? dbConnect : new DBConnect();
        this.functionname = sys_datafunctionRow.getString("functionname");
        this.type = sys_datafunctionRow.getString("type");
        this.datakey = sys_datafunctionRow.getString("datakey").equals("") ? "default" : sys_datafunctionRow.getString("datakey");
        this.sqlstr = sys_datafunctionRow.getString("sqlstr");
        this.queryforpage = sys_datafunctionRow.getBoolean("queryforpage");
        if (!sys_datafunctionRow.getBoolean("isused")) {
            this.sysdbConnect.runSqlUpdate("update sys_datafunction set isused=1 where functionname='" + this.functionname + "'");
        }
        Rows param_rows = this.sysdbConnect.runSqlQuery("select param,value from sys_datafunction_params where sys_datafunctionid=" + sys_datafunctionRow.getLong("sys_datafunctionid"));
        for (Row param_row : param_rows) {
            String key = param_row.getString("param");
            String value = param_row.getString("value");
            this.sys_parametermap.put(key, value);
            this.parametermap.put(key, value);
            try {
                if (!this.classfieldMap.containsKey(key)) continue;
                Field field = this.classfieldMap.get(key);
                field.setAccessible(true);
                switch (field.getType().getSimpleName()) {
                    case "String": {
                        field.set(this, value);
                        break;
                    }
                    case "Integer": {
                        if (!value.equals("")) {
                            field.set(this, Integer.parseInt(value));
                            break;
                        }
                        field.set(this, 0);
                        break;
                    }
                    case "Long": {
                        if (!value.equals("")) {
                            field.set(this, Long.parseLong(value));
                            break;
                        }
                        field.set(this, 0L);
                        break;
                    }
                    case "Double": {
                        if (!value.equals("")) {
                            field.set(this, Double.parseDouble(value));
                            break;
                        }
                        field.set(this, 0.0);
                        break;
                    }
                    case "Boolean": {
                        field.set(this, value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("Y"));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new YosException(e.getMessage());
            }
        }
    }

    public int action() throws YosException {
        if (!this.sqlstr.equals("")) {
            return this.dbConnect.runSqlUpdate(this.getSQL());
        }
        return 0;
    }

    public String getSQL() throws YosException {
        if (!this.sqlstr.equals("")) {
            for (String parameter2 : this.parametermap.keySet()) {
                String value = String.valueOf(this.parametermap.get(parameter2));
                String key = "$" + parameter2 + "$";
                if (value == null || "null".equalsIgnoreCase(value)) {
                    this.sqlstr = this.sqlstr.replace(key, "NULL");
                    continue;
                }
                this.sqlstr = this.sqlstr.replace(key, "'" + value + "'");
            }
            for (String parameter2 : this.parametermap_array.keySet()) {
                String sqlkey = "$" + parameter2 + "$";
                String[] values = this.parametermap_array.get(parameter2);
                if (values == null || values.length == 0) {
                    this.sqlstr = this.sqlstr.replace(sqlkey, "('')");
                    continue;
                }
                StringBuilder instr = new StringBuilder();
                for (String value : values) {
                    if (instr.toString().equals("")) {
                        if (String.valueOf(value).equalsIgnoreCase("null")) {
                            instr = new StringBuilder("NULL");
                            continue;
                        }
                        instr = new StringBuilder("'" + value + "'");
                        continue;
                    }
                    if (String.valueOf(value).equalsIgnoreCase("null")) {
                        instr.append(",NULL");
                        continue;
                    }
                    instr.append(",'").append(value).append("'");
                }
                this.sqlstr = this.sqlstr.replace(sqlkey, "(" + instr + ")");
            }
            if (this.controller != null) {
                this.sqlstr = this.controller.SQLSystemParamHandle(this.sqlstr);
            }
            if (this.datakey.equals("sqliteCache")) {
                if (this.type.equals("query") && this.queryforpage) {
                    this.sqlstr = this.sqlstr.replaceFirst("(?i)select", "select " + this.pageNumber + " as pageNumber," + this.pageSize + " as pageSize,");
                    this.sqlstr = this.sqlstr + " limit " + (this.pageNumber - 1) * this.pageSize + "," + this.pageSize;
                }
            } else {
                switch (this.dbConnect.getDBProduct()) {
                    case "MySQL": {
                        if (!this.type.equals("query") || !this.queryforpage) break;
                        this.sqlstr = this.sqlstr.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + this.pageNumber + " as pageNumber," + this.pageSize + " as pageSize,");
                        this.sqlstr = this.sqlstr + " limit " + (this.pageNumber - 1) * this.pageSize + "," + this.pageSize;
                        break;
                    }
                    case "SQL Server": {
                        break;
                    }
                }
            }
        }
        return this.sqlstr;
    }

    public Rows getList() throws YosException {
        if (!this.sqlstr.equals("")) {
            if (this.datakey.equals("default")) {
                return this.dbConnect.runSqlQuery(this.getSQL());
            }
            if (this.datakey.equals("sqliteCache")) {
                return SQLiteMemory.runSqlQuery(this.getSQL());
            }
            return this.dbConnect.runSqlQuery(this.getSQL());
        }
        return new Rows();
    }

    public void addParameter(String key, Object value) throws YosException {
        if (this.sys_parametermap.getOrDefault(key, "").equals("")) {
            int i;
            String[] values;
            if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                values = new String[list.size()];
                for (i = 0; i < values.length; ++i) {
                    values[i] = list.get(i).toString();
                }
                this.parametermap_array.put(key, values);
            } else if (value.getClass().isArray()) {
                Object[] Objectarray = (Object[])value;
                values = new String[Objectarray.length];
                for (i = 0; i < values.length; ++i) {
                    values[i] = Objectarray[i].toString();
                }
                this.parametermap_array.put(key, values);
            } else {
                this.parametermap.put(key, value);
            }
            try {
                if (this.classfieldMap.containsKey(key)) {
                    Field field = this.classfieldMap.get(key);
                    field.setAccessible(true);
                    switch (field.getType().getSimpleName()) {
                        case "String": {
                            field.set(this, value.toString());
                            break;
                        }
                        case "Integer": {
                            field.set(this, Integer.parseInt(value.toString()));
                            break;
                        }
                        case "Long": {
                            field.set(this, Long.parseLong(value.toString()));
                            break;
                        }
                        case "Double": {
                            field.set(this, Double.parseDouble(value.toString()));
                            break;
                        }
                        case "Boolean": {
                            field.set(this, value.toString().equalsIgnoreCase("true") || value.toString().equals("1") || value.toString().equalsIgnoreCase("Y"));
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new YosException(e.getMessage());
            }
        }
    }

    public Object getParamValue(String param) {
        if (this.parametermap.containsKey(param)) {
            return this.parametermap.get(param);
        }
        if (this.parametermap_array.containsKey(param)) {
            return this.parametermap_array.get(param);
        }
        return null;
    }
}

