/*
 * Decompiled with CFR 0.152.
 */
package service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.YosException;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import java.util.ArrayList;

public class DataArchiving
extends ServiceController {
    @Override
    public void serviceRun() throws Exception {
        this.dbConnect.setGroup_concat_max_len(1000000000000000L);
        this.databaseinit();
        this.archiveData();
        this.archiveSiteData();
    }

    private void archiveData() throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select table_name,sqlcondition,foreign_table from sys_dataarchiving where issite=0 and isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            String fieldstr = this.dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + this.dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "'").get(0).getString("fieldstr");
            String sqlcondition = row.getString("sqlcondition").trim();
            sqlcondition = sqlcondition.equals("") ? " 1=2 " : sqlcondition;
            JSONArray foreign_tables = row.getJSONArray("foreign_table");
            ArrayList<String> sqllist = new ArrayList<String>();
            String database2 = this.dbConnect.getDBName() + "_archive";
            Row datarow = this.dbConnect.runSqlQuery("select count(0)as datacount, GROUP_CONCAT(" + this.getuniquecolumnname(table_name) + ") as dataidsstr from ( select " + this.getuniquecolumnname(table_name) + " from " + table_name + " where (" + sqlcondition + ") order by " + this.getuniquecolumnname(table_name) + " limit 1000) as " + table_name).get(0);
            long datacount = datarow.getLong("datacount");
            if (datacount <= 0L) continue;
            String dataidsstr = datarow.getString("dataidsstr");
            while (dataidsstr.endsWith(",")) {
                dataidsstr = dataidsstr.substring(0, dataidsstr.length() - 1);
            }
            String insertSqlBuffer = "insert into " + database2 + "." + table_name + "(" + fieldstr + ")select " + fieldstr + " from " + table_name + " where " + this.getuniquecolumnname(table_name) + " in (" + dataidsstr + ")";
            sqllist.add(insertSqlBuffer);
            for (int i = 0; i < foreign_tables.size(); ++i) {
                JSONObject foreign_table = foreign_tables.getJSONObject(i);
                String foreign_table_name = foreign_table.getString("table_name");
                String foreign_sqlcondition = foreign_table.getString("sqlcondition").trim();
                foreign_sqlcondition = foreign_sqlcondition.equals("") ? " 1=2 " : foreign_sqlcondition;
                String foreign_fieldstr = this.dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + this.dbConnect.getDBName() + "' and TABLE_NAME='" + foreign_table_name + "'").get(0).getString("fieldstr");
                Row foreign_datarow = this.dbConnect.runSqlQuery("select count(0) as datacount,GROUP_CONCAT(distinct " + foreign_table_name + "." + this.getuniquecolumnname(foreign_table_name) + ") as dataidsstr from " + foreign_table_name + " inner join " + table_name + " on " + foreign_sqlcondition + " where " + table_name + "." + this.getuniquecolumnname(table_name) + " in (" + dataidsstr + ")").get(0);
                long foreign_datacount = foreign_datarow.getLong("datacount");
                if (foreign_datacount <= 0L) continue;
                String foreign_dataidsstr = foreign_datarow.getString("dataidsstr");
                while (foreign_dataidsstr.endsWith(",")) {
                    foreign_dataidsstr = foreign_dataidsstr.substring(0, foreign_dataidsstr.length() - 1);
                }
                String foreign_InsertSqlBuffer = "insert into " + database2 + "." + foreign_table_name + "(" + foreign_fieldstr + ")select " + foreign_fieldstr + " from " + foreign_table_name + " where " + this.getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")";
                sqllist.add(foreign_InsertSqlBuffer);
                sqllist.add("delete from " + foreign_table_name + " where " + this.getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")");
            }
            sqllist.add("delete from " + table_name + " where " + this.getuniquecolumnname(table_name) + " in (" + dataidsstr + ")");
            this.dbConnect.runSqlUpdate(sqllist);
        }
    }

    private void archiveSiteData() throws YosException {
        ArrayList<String> siteids = this.dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = this.dbConnect.runSqlQuery("select table_name,sqlcondition,foreign_table from sys_dataarchiving where issite=1 and isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            String fieldstr = this.dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + this.dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "'").get(0).getString("fieldstr");
            String sqlcondition = row.getString("sqlcondition").trim();
            sqlcondition = sqlcondition.equals("") ? " 1=2 " : sqlcondition;
            JSONArray foreign_tables = row.getJSONArray("foreign_table");
            for (String siteid : siteids) {
                ArrayList<String> sqllist = new ArrayList<String>();
                String database2 = this.dbConnect.getDBName() + "_archive_" + siteid;
                Row datarow = this.dbConnect.runSqlQuery("select count(0)as datacount, GROUP_CONCAT(" + this.getuniquecolumnname(table_name) + ") as dataidsstr from ( select " + this.getuniquecolumnname(table_name) + " from " + table_name + " where siteid='" + siteid + "' and (" + sqlcondition + ") order by " + this.getuniquecolumnname(table_name) + " limit 1000) as " + table_name).get(0);
                long datacount = datarow.getLong("datacount");
                if (datacount <= 0L) continue;
                String dataidsstr = datarow.getString("dataidsstr");
                while (dataidsstr.endsWith(",")) {
                    dataidsstr = dataidsstr.substring(0, dataidsstr.length() - 1);
                }
                String insertSqlBuffer = "insert into " + database2 + "." + table_name + "(" + fieldstr + ")select " + fieldstr + " from " + table_name + " where " + this.getuniquecolumnname(table_name) + " in (" + dataidsstr + ")";
                sqllist.add(insertSqlBuffer);
                for (int i = 0; i < foreign_tables.size(); ++i) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    String foreign_table_name = foreign_table.getString("table_name");
                    String foreign_sqlcondition = foreign_table.getString("sqlcondition").trim();
                    foreign_sqlcondition = foreign_sqlcondition.equals("") ? " 1=2 " : foreign_sqlcondition;
                    String foreign_fieldstr = this.dbConnect.runSqlQuery("SELECT GROUP_CONCAT(COLUMN_NAME) as fieldstr FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + this.dbConnect.getDBName() + "' and TABLE_NAME='" + foreign_table_name + "'").get(0).getString("fieldstr");
                    Row foreign_datarow = this.dbConnect.runSqlQuery("select count(0) as datacount,GROUP_CONCAT(distinct " + foreign_table_name + "." + this.getuniquecolumnname(foreign_table_name) + ") as dataidsstr from " + foreign_table_name + " inner join " + table_name + " on " + foreign_sqlcondition + " where " + table_name + "." + this.getuniquecolumnname(table_name) + " in (" + dataidsstr + ")").get(0);
                    long foreign_datacount = foreign_datarow.getLong("datacount");
                    if (foreign_datacount <= 0L) continue;
                    String foreign_dataidsstr = foreign_datarow.getString("dataidsstr");
                    while (foreign_dataidsstr.endsWith(",")) {
                        foreign_dataidsstr = foreign_dataidsstr.substring(0, foreign_dataidsstr.length() - 1);
                    }
                    String foreign_InsertSqlBuffer = "insert into " + database2 + "." + foreign_table_name + "(" + foreign_fieldstr + ")select " + foreign_fieldstr + " from " + foreign_table_name + " where " + this.getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")";
                    sqllist.add(foreign_InsertSqlBuffer);
                    sqllist.add("delete from " + foreign_table_name + " where " + this.getuniquecolumnname(foreign_table_name) + " in (" + foreign_dataidsstr + ")");
                }
                sqllist.add("delete from " + table_name + " where " + this.getuniquecolumnname(table_name) + " in (" + dataidsstr + ")");
                this.dbConnect.runSqlUpdate(sqllist);
            }
        }
    }

    private void databaseinit() throws YosException {
        ArrayList<String> siteids = this.dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = this.dbConnect.runSqlQuery("select issite,table_name,foreign_table from sys_dataarchiving where isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");
            ArrayList<String> databaseList = new ArrayList<String>();
            if (row.getBoolean("issite")) {
                for (String siteid : siteids) {
                    databaseList.add(this.dbConnect.getDBName() + "_archive_" + siteid);
                }
            } else {
                databaseList.add(this.dbConnect.getDBName() + "_archive");
            }
            for (String database2 : databaseList) {
                this.createDataBase(database2, table_name);
                for (int i = 0; i < foreign_tables.size(); ++i) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    this.createDataBase(database2, foreign_table.getString("table_name"));
                }
            }
        }
    }

    private void createDataBase(String database2, String table_name) throws YosException {
        if (this.dbConnect.runSqlQuery("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '" + database2 + "'").isEmpty()) {
            this.dbConnect.runSqlUpdate("CREATE DATABASE `" + database2 + "` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_datasource");
            insertSQL.setValue("datakey", database2);
            insertSQL.setValue("dbname", database2);
            insertSQL.setValue("isdataarchive", 1);
            insertSQL.setValue("driver", "");
            insertSQL.setValue("username", "");
            insertSQL.setValue("password", "");
            insertSQL.setValue("url", "");
            insertSQL.insert();
        }
        ArrayList<String> sqllist = new ArrayList<String>();
        if (this.dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" + database2 + "' AND table_name = '" + table_name + "'").isEmpty()) {
            sqllist.add(this.dbConnect.runSqlQuery("SHOW CREATE table " + table_name).get(0).getString("Create Table"));
        } else {
            Rows tablecolrows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "'");
            for (Row tablecolrow : tablecolrows) {
                String column_name = tablecolrow.getString("column_name");
                String column_type = tablecolrow.getString("column_type");
                int numeric_precision = tablecolrow.getInteger("numeric_precision");
                int numeric_scale = tablecolrow.getInteger("numeric_scale");
                String type = this.getColumn_type(column_type, numeric_precision, numeric_scale);
                Rows cr = this.dbConnect.runSqlQuery("SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + database2 + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'");
                if (cr.isEmpty()) {
                    sqllist.add("alter table " + table_name + " add " + column_name + " " + type + " null;");
                    continue;
                }
                if (cr.get(0).getString("COLUMN_TYPE").equalsIgnoreCase(type)) continue;
                sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + " null;");
            }
        }
        if (!sqllist.isEmpty()) {
            new DBConnect(database2).runSqlUpdate(sqllist);
        }
    }

    private String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        }
        if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        }
        if (column_type.equals("integer")) {
            return "int";
        }
        return column_type;
    }
}

