/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.apimanage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import java.util.Calendar;
import java.util.HashMap;
import restcontroller.R;
import utility.tools.Encryption;

@API(title="\u7ba1\u7406\u7aef-\u5f00\u53d1-API\u63a5\u53e3\u76d1\u63a7")
public class ApiMonitor
extends Controller {
    public ApiMonitor(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u63a5\u53e3\u4fe1\u606f\u67e5\u8be2", apiversion=R.ID10004301.v1.class, intervaltime=2000L)
    public String queryApiList() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where")) {
            JSONObject whereObject = this.content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.classname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.method like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.apiid ='").append(whereObject.getString("condition")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("iscacheing") && !"".equals(whereObject.getString("iscacheing"))) {
                where.append(" and(");
                where.append("t2.iscacheing ='").append(whereObject.getString("iscacheing")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("accesstoken") && !"".equals(whereObject.getString("accesstoken"))) {
                where.append(" and(");
                where.append("t2.accesstoken ='").append(whereObject.getString("accesstoken")).append("' ");
                where.append(")");
            }
        }
        Rows methodrows = null;
        if (this.content.getBooleanValue("simple")) {
            methodrows = this.content.getBooleanValue("apiwithid") ? SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where t2.apiid!='' and " + where + " order by t1.classname,t2.method") : SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by t1.classname,t2.method");
        } else {
            Rows methodrows_count = SQLiteMemory.runSqlQuery("select t1.classname,t2.method,round(avg(ifnull(t3.runtime,0))) avgruntime from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname left join apirequestlog t3 on t2.classname=t3.classname and t2.method=t3.method where" + where + " group by t1.classname,t2.method");
            for (Row row : methodrows_count) {
                SQLiteMemory.runSqlUpdate("update apimethod set requesttimelong_avg=" + row.getBigDecimal("avgruntime").longValue() + " where  classname='" + row.getString("classname") + "' and method='" + row.getString("method") + "'");
            }
            this.pageSorting = this.pageSorting.equals("''") ? "t1.classname,t2.method" : this.pageSorting;
            methodrows = SQLiteMemory.runSqlQuery("select t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated,t2.requesttimes,t2.lastrequesttime,t2.requesttimelong_last,t2.requesttimelong_avg from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by " + this.pageSorting + " LIMIT " + this.pageSize + " OFFSET " + this.pageSize * (this.pageNumber - 1));
            methodrows.totalPage = new Double(Math.ceil((double)methodrows_count.size() / (double)this.pageSize)).longValue();
            methodrows.totalRows = methodrows_count.size();
            for (Row methodrow : methodrows) {
                JSONObject requestmsg = new JSONObject(true);
                requestmsg.put("requesttimes", (Object)methodrow.getLong("requesttimes"));
                requestmsg.put("readcachetimes", (Object)methodrow.getLong("readcachetimes"));
                requestmsg.put("requesttimelong_last", (Object)methodrow.getLong("requesttimelong_last"));
                requestmsg.put("requesttimelong_avg", (Object)methodrow.getLong("requesttimelong_avg"));
                requestmsg.put("lastrequesttime", (Object)methodrow.getString("lastrequesttime"));
                methodrow.put("requestmsg", requestmsg);
                methodrow.put("cleandatas", JSON.parseArray((String)methodrow.getString("cleandatas")));
                Rows apidocrows = this.dbConnect.runSqlQuery("select requestjson,requestnotes,responsejson,responsenotes from sys_apidoc where apiid='" + methodrow.getString("apiid") + "' and apiversion='" + methodrow.getString("apiversion") + "'");
                if (apidocrows.isEmpty()) {
                    JSONObject requestjsonObject = new JSONObject();
                    requestjsonObject.put("accesstoken", (Object)Encryption.Encode_MD5(String.valueOf(Calendar.getInstance().getTimeInMillis())));
                    requestjsonObject.put("id", (Object)methodrow.getString("apiid"));
                    requestjsonObject.put("content", (Object)new JSONObject());
                    methodrow.put("requestjson", requestjsonObject);
                    methodrow.put("responsejson", new JSONObject());
                    methodrow.put("requestnotes", "");
                    methodrow.put("responsenotes", "");
                    continue;
                }
                methodrow.put("requestjson", apidocrows.get(0).getJSONObject("requestjson"));
                methodrow.put("responsejson", apidocrows.get(0).getJSONObject("responsejson"));
                methodrow.put("requestnotes", apidocrows.get(0).getString("requestnotes"));
                methodrow.put("responsenotes", apidocrows.get(0).getString("responsenotes"));
            }
        }
        Rows approws = this.dbConnect.runSqlQuery("select t1.apiid,t1.apiversion,t2.systemappname from sys_apiapps t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");
        RowsMap appidrowsMap = approws.toRowsMap("apiid");
        HashMap<String, String> codermap = this.getOptionType("coder");
        for (Row row : methodrows) {
            RowsMap apiversionMap;
            row.put("apps", new JSONArray());
            String apiid = row.getString("apiid");
            String apiversion = row.getString("apiversion");
            if (appidrowsMap.containsKey(apiid) && (apiversionMap = appidrowsMap.get(apiid).toRowsMap("apiversion")).containsKey(apiversion)) {
                row.put("apps", apiversionMap.get(apiversion).toJsonArray("systemappname"));
            }
            if (apiid != null && !apiid.equals("")) {
                row.put("coder", codermap.getOrDefault(apiid.substring(apiid.length() - 2), ""));
                row.put("intervaltime_active", YOSAPI.getApi(Long.parseLong(apiid), Integer.parseInt(apiversion)).getApiIntervaltime());
                continue;
            }
            row.put("coder", "");
            row.put("intervaltime_active", "");
        }
        return this.getSucReturnObject().setData(methodrows).toString();
    }

    @API(title="\u63a5\u53e3\u8bf7\u6c42\u65e5\u5fd7\u67e5\u8be2", apiversion=R.ID10004401.v1.class)
    public String queryApiRequestLog() throws YosException {
        SQLiteTable sqLiteTable;
        String classname = this.content.getString("classname");
        classname = classname.replace("restcontroller.", "");
        String method = this.content.getString("method");
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where")) {
            JSONObject whereObject = this.content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("request like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or usermsg like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.getBooleanValue("withoutcacheing")) {
                where.append(" and ifnull(iscacheing,0) = 0");
            }
        }
        if (!(sqLiteTable = SQLiteTable.getTable("apirequestlog")).dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select requestlogid,createdate,request,usermsg,iscacheing from apirequestlog where classname ='" + classname + "' and method ='" + method + "' and " + where + " order by createdate desc LIMIT " + this.pageSize + " OFFSET " + this.pageSize * (this.pageNumber - 1));
            for (Row row : rows) {
                row.put("request", JSONObject.parseObject((String)row.getString("request")));
                row.put("usermsg", JSONObject.parseObject((String)row.getString("usermsg")));
            }
            Rows rowscount = SQLiteMemory.runSqlQuery("select count(0) as count from apirequestlog where classname='" + classname + "' and method='" + method + "' and " + where);
            rows.totalPage = new Double(Math.ceil((double)rowscount.get(0).getLong("count") / (double)this.pageSize)).longValue();
            rows.totalRows = rowscount.get(0).getLong("count");
            return this.getSucReturnObject().setData(rows).toString();
        }
        return this.getSucReturnObject().setData(new Rows()).toString();
    }

    @API(title="\u63a5\u53e3\u8bf7\u6c42SQL\u65e5\u5fd7\u67e5\u8be2", apiversion=R.ID10004501.v1.class)
    public String queryApiRequestSQLLog() throws YosException {
        String requestlogid = this.content.getString("requestlogid");
        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestsqllog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select sql,runtime,success,errmsg,numofaffectedrows,classname,method from apirequestsqllog where requestlogid='" + requestlogid + "' order by createtimeinmillis");
            return this.getSucReturnObject().setData(rows).toString();
        }
        return this.getSucReturnObject().setData(new Rows()).toString();
    }
}

