/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BaseClass;
import common.InitService;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import java.util.Calendar;
import utility.tools.MessageMonitoringStation;

public abstract class ServiceController
extends BaseClass
implements Runnable {
    public long service_runcount = 0L;
    public String classname = this.getClass().getSimpleName();
    public long serviceid = 0L;
    public String type = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            long starttime = Calendar.getInstance().getTimeInMillis();
            try {
                if (!this.checkService()) break block18;
                ++this.service_runcount;
                String errmessage = "";
                logger.info((Object)("\u81ea\u52a8\u4efb\u52a1\uff1a" + this.classname + "\u7b2c" + this.service_runcount + "\u6b21\u8fd0\u884c"));
                SQLFactory.createUpdateSQL(this.dbConnect, "sys_services").setUniqueid(this.serviceid).setDateValue("lastruntime").update();
                int successed = 1;
                try {
                    this.serviceRun();
                }
                catch (Exception e) {
                    successed = 0;
                    errmessage = e.getMessage() + "\n" + e.getStackTrace()[0].toString();
                    MessageMonitoringStation.send("\n\u81ea\u52a8\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff01\n\u4efb\u52a1\u540d\u79f0\uff1a" + this.classname + "\n\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage() + "\n\u5f02\u5e38\u4f4d\u7f6e\uff1a\n" + e.getStackTrace()[0].toString() + "\n\n\u76f8\u5173\u4eba\u5458\u8bf7\u53ca\u65f6\u5904\u7406\uff01");
                    logger.error((Object)e);
                }
                finally {
                    try {
                        UpdateSQL sysServiceUpdate = SQLFactory.createUpdateSQL(this.dbConnect, "sys_services").setUniqueid(this.serviceid);
                        sysServiceUpdate.setValue("successed", successed);
                        sysServiceUpdate.setValue("timelong", Calendar.getInstance().getTimeInMillis() - starttime);
                        sysServiceUpdate.setValue("errmessage", errmessage);
                        sysServiceUpdate.setValue("isrestarting", 0);
                        if (this.type.equalsIgnoreCase("month")) {
                            Thread.sleep(2000L);
                            InitService.startService(new DBConnect().runSqlQuery("select * from sys_services where classname='" + this.classname + "'").get(0));
                        } else {
                            sysServiceUpdate.setValue("nextruntime", InitService.getNextRunTime(this.classname));
                        }
                        sysServiceUpdate.update();
                    }
                    catch (YosException e) {
                        logger.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                MessageMonitoringStation.send("\n\u81ea\u52a8\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff01\n\u4efb\u52a1\u540d\u79f0\uff1a" + this.classname + "\n\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage() + "\n\u5f02\u5e38\u4f4d\u7f6e\uff1a\n" + e.getStackTrace()[0].toString() + "\n\n\u76f8\u5173\u4eba\u5458\u8bf7\u53ca\u65f6\u5904\u7406\uff01");
            }
            finally {
                InitService.restartErrService();
            }
        }
    }

    public abstract void serviceRun() throws Exception;

    public ServiceParam paramSet() {
        return null;
    }

    private boolean checkService() throws YosException {
        Rows sys_servicesRows = this.dbConnect.runSqlQuery("select * from sys_services where classname='" + this.classname + "'");
        if (sys_servicesRows.isEmpty()) {
            return false;
        }
        Row sys_servicesRow = sys_servicesRows.get(0);
        if (!sys_servicesRow.getBoolean("isused")) {
            return false;
        }
        if (sys_servicesRow.getString("type").equals("once") && this.service_runcount > 1L) {
            return false;
        }
        this.serviceid = sys_servicesRow.getLong("serviceid");
        this.type = sys_servicesRow.getString("type");
        return true;
    }

    public static enum RunType {
        once,
        second,
        minute,
        hour,
        day,
        week,
        month;

    }

    public class ServiceParam {
        String remarks = "";
        RunType type;
        int count = 1;
        String time;
        boolean isused = false;

        public ServiceParam(String remarks, int count, RunType type) {
            this.remarks = remarks;
            this.count = count;
            this.type = type;
            this.setTime("");
        }

        public ServiceParam(String remarks, int count, RunType type, String time) {
            this.remarks = remarks;
            this.count = count;
            this.type = type;
            this.setTime(time);
        }

        public ServiceParam autoUsed(boolean used) {
            this.isused = used;
            return this;
        }

        private void setTime(String time) {
            this.time = this.type.equals((Object)RunType.hour) ? (time.isEmpty() ? "00:00" : time) : (this.type.equals((Object)RunType.day) ? (time.isEmpty() ? "00:00:00" : time) : "");
        }
    }
}

