/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BaseClass;
import common.ServiceController;
import common.YosException;
import common.YosLogger;
import common.data.DeleteSQL;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.License;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import utility.tools.MessageMonitoringStation;

public class InitService
extends BaseClass
implements Runnable,
YosLogger {
    private static boolean isfirstrun = true;
    static ScheduledExecutorService service;
    public static HashMap<String, ScheduledFuture<?>> scheduledFutureMap;
    private static boolean isrestartrunning;

    @Override
    public void run() {
        try {
            if (isfirstrun) {
                this.initialize();
                service = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);
                service.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        InitService.restartErrService();
                    }
                }, 60L, 60L, TimeUnit.SECONDS);
                logger.info((Object)"\u542f\u52a8\u81ea\u52a8\u4efb\u52a1");
                isfirstrun = false;
                Rows rows = this.dbConnect.runSqlQuery("select classname,isused,remarks,lastruntime,type,count,time from sys_services");
                for (Row row : rows) {
                    InitService.startService(row);
                }
            }
        }
        catch (YosException e) {
            logger.error((Object)e);
        }
    }

    public static void startService(Row row) {
        try {
            String classname = row.getString("classname");
            String remarks = row.getString("remarks");
            String type = row.getString("type");
            int count = row.getInteger("count") <= 0 ? 1 : row.getInteger("count");
            boolean isused = row.getBoolean("isused");
            if (scheduledFutureMap.containsKey(classname)) {
                logger.info((Object)("\u670d\u52a1\u5378\u8f7d\uff1a" + classname + ";" + remarks));
                scheduledFutureMap.get(classname).cancel(false);
                scheduledFutureMap.remove(classname);
            }
            Class<?> clz = Class.forName("service." + classname);
            Constructor<?> cla = clz.getDeclaredConstructor(new Class[0]);
            ServiceController controller = (ServiceController)cla.newInstance(new Object[0]);
            logger.info((Object)("\u670d\u52a1\u52a0\u8f7d\uff1a" + classname + "," + type + "," + (isused ? "\u542f\u7528" : "\u505c\u7528") + ";" + remarks));
            Calendar calendar = Calendar.getInstance();
            ScheduledFuture<?> scheduledFuture = null;
            long initialDelay = 0L;
            switch (type) {
                case "once": {
                    initialDelay = 10L;
                    scheduledFuture = service.scheduleWithFixedDelay(controller, initialDelay, 300L, TimeUnit.SECONDS);
                    break;
                }
                case "second": {
                    initialDelay = 10L;
                    scheduledFuture = service.scheduleWithFixedDelay(controller, initialDelay, count, TimeUnit.SECONDS);
                    break;
                }
                case "minute": {
                    initialDelay = 60 - calendar.get(13);
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, (long)count * 60L, TimeUnit.SECONDS);
                    break;
                }
                case "hour": {
                    int syssecond;
                    String[] times;
                    int schedulesecond;
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00";
                    }
                    initialDelay = (initialDelay = (long)((schedulesecond = Integer.parseInt((times = time.split(":"))[0]) * 60 + Integer.parseInt(times[1])) - (syssecond = calendar.get(12) * 60 + calendar.get(13)))) < 0L ? initialDelay + 3600L : initialDelay;
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, (long)count * 60L * 60L, TimeUnit.SECONDS);
                    break;
                }
                case "day": {
                    int syssecond;
                    String[] times;
                    int schedulesecond;
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00:00";
                    }
                    initialDelay = (initialDelay = (long)((schedulesecond = Integer.parseInt((times = time.split(":"))[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2])) - (syssecond = calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)))) < 0L ? initialDelay + 86400L : initialDelay;
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, (long)count * 60L * 60L * 24L, TimeUnit.SECONDS);
                    break;
                }
                case "week": {
                    int syssecond;
                    String[] times;
                    int schedulesecond;
                    int day_of_week = row.getInteger("day_of_week");
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00:00";
                    }
                    initialDelay = (initialDelay = (long)((schedulesecond = day_of_week * 60 * 60 * 24 + Integer.parseInt((times = time.split(":"))[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2])) - (syssecond = (calendar.get(7) - 1) * 60 * 60 * 24 + calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)))) < 0L ? initialDelay + 604800L : initialDelay;
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, (long)count * 60L * 60L * 24L * 7L, TimeUnit.SECONDS);
                    break;
                }
                case "month": {
                    int syssecond;
                    String[] times;
                    int schedulesecond;
                    int day_of_month = row.getInteger("day_of_month");
                    String time = row.getString("time");
                    if (time.isEmpty()) {
                        time = "00:00:00";
                    }
                    if ((initialDelay = (long)((schedulesecond = day_of_month * 60 * 60 * 24 + Integer.parseInt((times = time.split(":"))[0]) * 60 * 60 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2])) - (syssecond = calendar.get(5) * 60 * 60 * 24 + calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)))) < 0L) {
                        Calendar nexttime = Calendar.getInstance();
                        nexttime.add(2, count);
                        nexttime.set(5, day_of_month);
                        nexttime.set(11, Integer.parseInt(times[0]));
                        nexttime.set(12, Integer.parseInt(times[1]));
                        nexttime.set(13, Integer.parseInt(times[2]));
                        initialDelay = (nexttime.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
                    }
                    scheduledFuture = service.scheduleAtFixedRate(controller, initialDelay, (long)count * 60L * 60L * 24L * 31L, TimeUnit.SECONDS);
                    break;
                }
            }
            if (scheduledFuture != null) {
                scheduledFutureMap.put(classname, scheduledFuture);
                if (!type.equalsIgnoreCase("once")) {
                    if (isused) {
                        calendar.add(13, (int)initialDelay);
                        new DBConnect().runSqlUpdate("update sys_services set nextruntime='" + InitService.getDateTime_Str(calendar.getTime()) + "' where classname='" + classname + "'");
                    } else {
                        new DBConnect().runSqlUpdate("update sys_services set nextruntime=null where classname='" + classname + "'");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        try {
            ArrayList<String> servlist = SQLFactory.createQuerySQL(this.dbConnect, "sys_services", new String[0]).query().toArrayList("classname");
            ArrayList<String> sqlist = new ArrayList<String>();
            Reflections reflections = new Reflections("service", new Scanner[0]);
            Set subTypes = reflections.getSubTypesOf(ServiceController.class);
            for (Class clazz : subTypes) {
                String classname = clazz.getSimpleName();
                servlist.remove(classname);
                if (!((QuerySQL)SQLFactory.createQuerySQL(this.dbConnect, "sys_services", new String[0]).setWhere("classname", classname)).query().isEmpty()) continue;
                Object obj = clazz.newInstance();
                ServiceController.ServiceParam paramSet = (ServiceController.ServiceParam)obj.getClass().getMethod("paramSet", new Class[0]).invoke(obj, new Object[0]);
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_services");
                insertSQL.setValue("classname", classname);
                insertSQL.setValue("isused", paramSet == null ? false : paramSet.isused);
                insertSQL.setValue("remarks", paramSet == null ? "" : paramSet.remarks);
                insertSQL.setValue("type", paramSet == null ? "minute" : paramSet.type);
                insertSQL.setValue("count", paramSet == null ? 1 : paramSet.count);
                insertSQL.setValue("time", paramSet == null ? "" : paramSet.time);
                sqlist.add(insertSQL.getSQL());
            }
            sqlist.add(((DeleteSQL)SQLFactory.createDeleteSQL(this.dbConnect, "sys_services").setWhere("classname", servlist)).getSQL());
            new DBConnect().runSqlUpdate(sqlist);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (License.get().getLicenseType().equals("Development Certificate")) {
                    this.dbConnect.runSqlUpdate("update sys_services set isused=0 where classname!='MySqlDataBackUp'");
                }
                this.dbConnect.runSqlUpdate("update sys_services set nextruntime=null,isrestarting=0");
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public static Date getNextRunTime(String classname) {
        try {
            if (scheduledFutureMap.containsKey(classname)) {
                ScheduledFuture<?> scheduledFuture = scheduledFutureMap.get(classname);
                Field periodField = scheduledFuture.getClass().getDeclaredField("period");
                periodField.setAccessible(true);
                long period = Math.abs((Long)periodField.get(scheduledFuture));
                Field timeField = scheduledFuture.getClass().getDeclaredField("time");
                timeField.setAccessible(true);
                long nextRunTime = (Long)timeField.get(scheduledFuture);
                long delayMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nextRunTime + period);
                return new Date(System.currentTimeMillis() + delayMillis);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static void restartErrService() {
        if (!isrestartrunning) {
            isrestartrunning = true;
            new Thread(() -> {
                try {
                    QuerySQL serviceQuery = SQLFactory.createQuerySQL(new DBConnect(), "sys_services", new String[0]);
                    ((QuerySQL)((QuerySQL)serviceQuery.setWhere("isused", true)).setWhere("isrestarting", false)).setWhere("type!='once'");
                    serviceQuery.setWhere("lastruntime>'" + InitService.getDateTime_Str(ManagementFactory.getRuntimeMXBean().getStartTime()) + "'");
                    serviceQuery.setWhere("DATE_ADD(nextruntime,INTERVAL 5 MINUTE)<now()");
                    Rows rows = serviceQuery.query();
                    for (Row row : rows) {
                        try {
                            long serviceid = row.getLong("serviceid");
                            new DBConnect().runSqlUpdate("update sys_services set isrestarting=1,restartcount=ifnull(restartcount,0)+1 where serviceid='" + serviceid + "'");
                            InitService.startService(row);
                            logger.info((Object)("\u76d1\u6d4b\u5230\u81ea\u52a8\u4efb\u52a1\uff1a" + row.getString("classname") + "\u5728\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u672a\u6210\u529f\u6267\u884c\uff0c\u53ef\u80fd\u505c\u6b62\u8fd0\u884c\uff0c\u5df2\u91cd\u8f7d"));
                            MessageMonitoringStation.send("\u76d1\u6d4b\u5230\u81ea\u52a8\u4efb\u52a1\uff1a" + row.getString("classname") + "\u5728\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u672a\u6210\u529f\u6267\u884c\uff0c\u53ef\u80fd\u505c\u6b62\u8fd0\u884c\uff0c\u5df2\u91cd\u8f7d");
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                finally {
                    isrestartrunning = false;
                }
            }).start();
        }
    }

    static {
        scheduledFutureMap = new HashMap();
        isrestartrunning = false;
    }
}

