package utility.kuaidi100;

import beans.parameter.Parameter;
import common.YosException;
import common.parameter.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class kuaidi100Vip {
    /**
     * @param com 快递公司编码
     * @param num 快递单号
     * @return
     */
    public static String queryKuaiDi100(String siteid, String com, String num) throws YosException {
        String phone = "";                //手机号码后四位
        String from = "";                //出发地
        String to = "";                    //目的地
        int resultv2 = 0;                //开启行政规划解析
        kuaidi100Vip demo = new kuaidi100Vip();
        return demo.synQueryData(siteid, com, num, phone, from, to, resultv2);
    }

    /**
     * 实时查询快递单号
     *
     * @param com      快递公司编码
     * @param num      快递单号
     * @param phone    手机号
     * @param from     出发地城市
     * @param to       目的地城市
     * @param resultv2 开通区域解析功能：0-关闭；1-开通
     * @return
     */
    public String synQueryData(String siteid, String com, String num, String phone, String from, String to, int resultv2) throws YosException {

        StringBuilder param = new StringBuilder("{");
        param.append("\"com\":\"").append(com).append("\"");
        param.append(",\"num\":\"").append(num).append("\"");
        param.append(",\"phone\":\"").append(phone).append("\"");
        param.append(",\"from\":\"").append(from).append("\"");
        param.append(",\"to\":\"").append(to).append("\"");
        if (1 == resultv2) {
            param.append(",\"resultv2\":1");
        } else {
            param.append(",\"resultv2\":0");
        }
        param.append("}");

        String customer = Parameter.get(siteid, "kuaidi100_customer");
        String key = Parameter.get(siteid, "kuaidi100_key");

        Map<String, String> params = new HashMap<String, String>();
        params.put("customer", customer);
        String sign = MD5Utils.encode(param + key + customer);
        params.put("sign", sign);
        params.put("param", param.toString());

        return this.post(params);
    }

    /**
     * 发送post请求
     */
    public String post(Map<String, String> params) {
        StringBuffer response = new StringBuffer();

        BufferedReader reader = null;
        try {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (builder.length() > 0) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                builder.append('=');
                builder.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);

            URL url = new URL("http://poll.kuaidi100.com/poll/query.do");
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(bytes);

            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));

            String line = "";
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return response.toString();
    }
}

/**
 * md5加密
 */
class MD5Utils {
    private static MessageDigest mdigest = null;
    private static final char[] digits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static MessageDigest getMdInst() {
        if (null == mdigest) {
            try {
                mdigest = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return mdigest;
    }

    public static String encode(String s) {
        if (null == s) {
            return "";
        }

        try {
            byte[] bytes = s.getBytes();
            getMdInst().update(bytes);
            byte[] md = getMdInst().digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++) {
                byte byte0 = md[i];
                str[k++] = digits[byte0 >>> 4 & 0xf];
                str[k++] = digits[byte0 & 0xf];
            }
            return new String(str);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
