package utility.bankdocking.boc.tool;

import org.dom4j.Element;
import utility.bankdocking.boc.domain.PayerInfo;
import utility.bankdocking.boc.domain.TradeInfoResponseDetail;
import utility.bankdocking.boc.tool.Tool;

import java.util.ArrayList;
import java.util.List;

public class ElementResolve {

	public static List<TradeInfoResponseDetail> elementResolve(Element element){
		List<TradeInfoResponseDetail> list =new ArrayList<TradeInfoResponseDetail>();
		List<Element> rs = element.elements("b2e0035-rs");
		for(Element rdnode : rs){
			TradeInfoResponseDetail tradeInfoResponseDetail =new TradeInfoResponseDetail();
			String vchnum = rdnode.elementText("vchnum"); //凭证编号（交易流水号）
			if(Tool.isNotNull(vchnum)){
				tradeInfoResponseDetail.setVchnum(vchnum);
			}
			String transid = rdnode.elementText("transid");  //记录标识号(9位)
			if(Tool.isNotNull(transid)){
				tradeInfoResponseDetail.setTransid(transid);
			}
			String insid = rdnode.elementText("insid"); //客户业务编号后12位
			if(Tool.isNotNull(insid)){
				tradeInfoResponseDetail.setInsid(insid);
			}
			String txndate = rdnode.elementText("txndate");  //交易日期
			if(Tool.isNotNull(txndate)){
				tradeInfoResponseDetail.setTxndate(txndate);
			}
			String txntime = rdnode.elementText("txntime"); //交易时间
			if(Tool.isNotNull(txntime)){
				tradeInfoResponseDetail.setTxntime(txntime);
			}
			String txnamt = rdnode.elementText("txnamt"); //金额
			if(Tool.isNotNull(txnamt)){
				tradeInfoResponseDetail.setTxnamt(Double.parseDouble(txnamt));
			}
			String acctbal = rdnode.elementText("acctbal"); //交易后余额
			if(Tool.isNotNull(acctbal)){
				tradeInfoResponseDetail.setAcctbal(Double.parseDouble(acctbal));
			}
			String avlbal = rdnode.elementText("avlbal"); //可用余额
			if(Tool.isNotNull(avlbal)){
				tradeInfoResponseDetail.setAvlbal(Double.parseDouble(avlbal));
			}
			String frzamt = rdnode.elementText("frzamt"); //冻结金额
			if(Tool.isNotNull(frzamt)){
				tradeInfoResponseDetail.setFrzamt(Double.parseDouble(frzamt));
			}
			String overdramt = rdnode.elementText("overdramt"); //透支额度
			if(Tool.isNotNull(overdramt)){
				tradeInfoResponseDetail.setOverdramt(Double.parseDouble(overdramt));
			}
			String avloverdramt = rdnode.elementText("avloverdramt"); //可用透支额度
			if(Tool.isNotNull(avloverdramt)){
				tradeInfoResponseDetail.setAvloverdramt(Double.parseDouble(avloverdramt));
			}

			String trncur = rdnode.elementText("trncur"); //货币名称
			if(Tool.isNotNull(trncur)){
				tradeInfoResponseDetail.setTrncur(trncur);
			}
			String transtype = rdnode.elementText("transtype"); //业务类型
			if(Tool.isNotNull(transtype)){
				tradeInfoResponseDetail.setTranstype(transtype);
			}

			String useinfo = rdnode.elementText("useinfo");  //用途
			if(Tool.isNotNull(useinfo)){
				tradeInfoResponseDetail.setUseinfo(useinfo);
			}
			String furinfo = rdnode.elementText("furinfo"); //交易附言
			if(Tool.isNotNull(furinfo)){
				tradeInfoResponseDetail.setFurinfo(furinfo);
			}
			String direction = rdnode.elementText("direction");  //来往账标识（1-来账，2-往账）
			if(Tool.isNotNull(direction)){
				tradeInfoResponseDetail.setDirection(direction);
			}
			String vouchtp = rdnode.elementText("vouchtp");  //凭证类型
			if(Tool.isNotNull(vouchtp)){
				tradeInfoResponseDetail.setVouchtp(vouchtp);
			}
			String vouchnum = rdnode.elementText("vouchnum");  //凭证号码
			if(Tool.isNotNull(vouchnum)){
				tradeInfoResponseDetail.setVouchnum(vouchnum);
			}
			String fxrate = rdnode.elementText("fxrate");  //汇率
			if(Tool.isNotNull(direction)){
				tradeInfoResponseDetail.setFxrate(fxrate);
			}
			String interinfo = rdnode.elementText("interinfo"); //整合信息
			if(Tool.isNotNull(interinfo)){
				tradeInfoResponseDetail.setInterinfo(interinfo);
			}
			String channelflg = rdnode.elementText("channelflg"); //渠道标识
			if(Tool.isNotNull(channelflg)){
				tradeInfoResponseDetail.setChannelflg(channelflg);
			}
			String commnum = rdnode.elementText("commnum");  //商户号
			if(Tool.isNotNull(direction)){
				tradeInfoResponseDetail.setCommnum(commnum);
			}
			String reserve1 = rdnode.elementText("reserve1"); //预留项1
			if(Tool.isNotNull(reserve1)){
				tradeInfoResponseDetail.setReserve1(reserve1);
			}
			String reserve2 = rdnode.elementText("reserve2");//预留项2
			if(Tool.isNotNull(reserve2)){
				tradeInfoResponseDetail.setReserve2(reserve2);
			}
			String reserve3 = rdnode.elementText("reserve3");//预留项3
			if(Tool.isNotNull(reserve3)){
				tradeInfoResponseDetail.setReserve3(reserve3);
			}
			Element fractn = rdnode.element("fractn");
			PayerInfo payerInfo =new PayerInfo();
			String ibknum = fractn.elementText("ibknum");//付款人开户行号
			if(Tool.isNotNull(ibknum)){
				payerInfo.setIbknum(ibknum);
			}
			String ibkname = fractn.elementText("ibkname");//付款人开户行名
			if(Tool.isNotNull(ibkname)){
				payerInfo.setIbkname(ibkname);
			}
			String actacn = fractn.elementText("actacn");//付款人开户账号
			if(Tool.isNotNull(actacn)){
				payerInfo.setActacn(actacn);
			}
			String acntname = fractn.elementText("acntname");//付款人开户名称
			if(Tool.isNotNull(acntname)){
				payerInfo.setAcntname(acntname);
			}
			String outref = fractn.elementText("outref");//汇款行业务编号
			if(Tool.isNotNull(outref)){
				payerInfo.setOutref(outref);
			}
			tradeInfoResponseDetail.setPayerInfo(payerInfo);
			System.out.println("流水号："+tradeInfoResponseDetail.getVchnum());
			list.add(tradeInfoResponseDetail);

		}
		return list;
	}
}
