package restcontroller.sysmanage.develop.helpdocs;

import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;

public class helpdocs extends Controller {
    public helpdocs(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "帮助文档查询", apiversion = R.ID10024701.v1.class)
    public String query() throws YosException {
        String ownertable = content.getString("ownertable");
        long ownerid = content.getLongValue("ownerid");
        String type = content.getStringValue("type");
        String doctype = content.getStringValue("doctype");

        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_helpdocs");
        querySQL.setWhere("ownertable", ownertable);
        if (ownerid > 0) {
            querySQL.setWhere("ownerid", ownerid);
        }
        if (!type.equals("")) {
            querySQL.setWhere("type", type);
        }
        if (!doctype.equals("")) {
            querySQL.setWhere("doctype", doctype);
        }
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "查询帮助文档", apiversion = R.ID10024901.v1.class)
    public String getHelpDoc() throws YosException {
        JSONArray systemappids;
        if (content.containsKey("systemappids")) {
            systemappids = content.getJSONArray("systemappids");
            if (systemappids.size() == 0) {
                systemappids = dbConnect.runSqlQuery("select systemappid from sys_systemapp ").toJsonArray("systemappid");
            }
        } else if (content.containsKey("roleids")) {
            JSONArray roleidArray = content.getJSONArray("roleids");
            if (roleidArray.size() == 0) {
                systemappids = dbConnect.runSqlQuery("select systemappid from sys_systemapp ").toJsonArray("systemappid");
            } else {
                ArrayList<Long> roleidList = new ArrayList<>();
                for (Object o : roleidArray) {
                    roleidList.add(Long.parseLong(o.toString()));
                }
                SQLFactory sqlFactory = new SQLFactory("sql:select distinct systemappid from sys_roleappoptionauth where roleid in $roleids$");
                sqlFactory.addParameter_in("roleids", roleidList);
                Rows rows = sqlFactory.runSqlQuery(dbConnect);
                systemappids = rows.toJsonArray("systemappid");
            }
        } else {
            SQLFactory sqlFactory = new SQLFactory("sql:select distinct systemappid from sys_roleappoptionauth where roleid in $roleids$");
            sqlFactory.addParameter_in("roleids", User.getUserRoleIDs(this, userid));
            Rows rows = sqlFactory.runSqlQuery(dbConnect);
            systemappids = rows.toJsonArray("systemappid");
        }

        StringBuilder doc = new StringBuilder();

        QuerySQL systemAppDocQuerySQL = SQLFactory.createQuerySQL(this, "sys_systemapp");
        systemAppDocQuerySQL.addQueryFields("sys_system.systemid", "sys_system.systemname", "sys_systemclient.systemclientid", "sys_systemclient.systemclientname", "sys_systemmodule.systemmoduleid", "sys_systemmodule.systemmodulename", "sys_systemapp.systemappid", "sys_systemapp.systemappname", "sys_helpdocs.content");
        systemAppDocQuerySQL.addJoinTable(JOINTYPE.inner, "sys_systemmodule", "sys_systemmodule", "sys_systemmodule.systemmoduleid=sys_systemapp.systemmoduleid");
        systemAppDocQuerySQL.addJoinTable(JOINTYPE.inner, "sys_systemclient", "sys_systemclient", "sys_systemclient.systemclientid=sys_systemmodule.systemclientid");
        systemAppDocQuerySQL.addJoinTable(JOINTYPE.inner, "sys_system", "sys_system", "sys_system.systemid=sys_systemclient.systemid");
        systemAppDocQuerySQL.addJoinTable(JOINTYPE.left, "sys_helpdocs", "sys_helpdocs", "sys_helpdocs.ownertable='sys_systemapp' and sys_helpdocs.ownerid=sys_systemapp.systemappid and sys_helpdocs.doctype='markdown' and sys_helpdocs.type='help' ");
        systemAppDocQuerySQL.setWhere("systemappid", systemappids);
        systemAppDocQuerySQL.setOrderBy("sys_system.sequence,sys_systemclient.systemclientid,sys_systemmodule.sequence,sys_systemapp.sequence");
        Rows systemAppClientdocRows = systemAppDocQuerySQL.query();

        ArrayList<Long> systemids = new ArrayList<>();
        ArrayList<Long> systemclientids = new ArrayList<>();
        ArrayList<Long> systemmoduleids = new ArrayList<>();

        for (Row systemAppClientdocRow : systemAppClientdocRows) {
            long systemid = systemAppClientdocRow.getLong("systemid");
            String systemname = systemAppClientdocRow.getString("systemname");
            long systemclientid = systemAppClientdocRow.getLong("systemclientid");
            String systemclientname = systemAppClientdocRow.getString("systemclientname");
            long systemmoduleid = systemAppClientdocRow.getLong("systemmoduleid");
            String systemmodulename = systemAppClientdocRow.getString("systemmodulename");
            long systemappid = systemAppClientdocRow.getLong("systemappid");
            String systemappname = systemAppClientdocRow.getString("systemappname");
            String content = systemAppClientdocRow.getString("content");

            if (!systemids.contains(systemid)) {
                Rows rows = dbConnect.runSqlQuery("select content from sys_helpdocs where ownertable='sys_system' and ownerid=" + systemid + " and doctype='markdown' and type='help'");
                if (rows.isEmpty() || rows.get(0).getString("content").equals("")) {
                    doc.append("# " + systemname + "\n" + "系统描述说明").append("\n");
                } else {
                    doc.append(rows.get(0).getString("content")).append("\n");
                }
                systemids.add(systemid);
            }
            if (!systemclientids.contains(systemclientid)) {
                Rows rows = dbConnect.runSqlQuery("select content from sys_helpdocs where ownertable='sys_systemclient' and ownerid=" + systemclientid + " and doctype='markdown' and type='help'");
                if (rows.isEmpty() || rows.get(0).getString("content").equals("")) {
                    doc.append("## " + systemclientname + "\n" + "操作端描述说明").append("\n");
                } else {
                    doc.append(rows.get(0).getString("content")).append("\n");
                }
                systemclientids.add(systemclientid);
            }
            if (!systemmoduleids.contains(systemmoduleid)) {
                Rows rows = dbConnect.runSqlQuery("select content from sys_helpdocs where ownertable='sys_systemmodule' and ownerid=" + systemmoduleid + " and doctype='markdown' and type='help'");
                if (rows.isEmpty() || rows.get(0).getString("content").equals("")) {
                    doc.append("### " + systemmodulename + "\n" + "模块描述说明").append("\n");
                } else {
                    doc.append(rows.get(0).getString("content")).append("\n");
                }
                systemmoduleids.add(systemmoduleid);
            }
            if (content == null || content.equals("")) {
                doc.append("#### " + systemappname + "\n" + "应用描述说明").append("\n");
            } else {
                doc.append(content).append("\n");
            }
        }
        return getSucReturnObject().setData(doc).toString();
    }

    @API(title = "帮助文档查询", apiversion = R.ID10024801.v1.class)
    public String insertOrUpdate() throws YosException {
        long sys_helpdocsid = content.getLongValue("sys_helpdocsid");
        String ownertable = content.getString("ownertable");
        long ownerid = content.getLongValue("ownerid");
        String type = content.getStringValue("type");
        String doctype = content.getStringValue("doctype");
        String content_str = content.getStringValue("content", true);

        if (SQLFactory.createQuerySQL(this, "sys_helpdocs").setUniqueid(sys_helpdocsid).query().isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_helpdocs");
            insertSQL.setValue("sys_helpdocsid", createTableID("sys_helpdocs"));
            insertSQL.setValue("ownertable", ownertable);
            insertSQL.setValue("ownerid", ownerid);
            insertSQL.setValue("type", type);
            insertSQL.setValue("doctype", doctype);
            insertSQL.setValue("content", content_str);
            insertSQL.insert();
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_helpdocs");
            updateSQL.setValue("content", content_str);
            updateSQL.setUniqueid(sys_helpdocsid);
            updateSQL.update();
        }
        return getSucReturnObject().toString();
    }

}
