package common.servlet;

import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.ReturnObject;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.parameter;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import utility.tools.Encryption;
import utility.tools.WebRequest;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import common.YosException;

public class Servlet extends HttpServlet {

    private static final int MEMORY_THRESHOLD = 1024 * 1024 * 3;  // 3MB
    private static final int MAX_FILE_SIZE = 1024 * 1024 * 40; // 40MB
    private static final int MAX_REQUEST_SIZE = 1024 * 1024 * 50; // 50MB

    /**
     * servlet API接口方法请求入口
     *
     * @param request
     * @param response
     * @return
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json");

        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(MEMORY_THRESHOLD);
        factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setFileSizeMax(MAX_FILE_SIZE);
        upload.setSizeMax(MAX_REQUEST_SIZE);
        upload.setHeaderEncoding("ISO8859_1");

        String RequestContent = "";
        List<FileItem> formItems = null;
        try {
            formItems = upload.parseRequest(request);
            if (formItems == null) {
                writeErrResponse(response, "参数不可为空");
                return;
            }
            for (FileItem item : formItems) {
                if (item.isFormField()) {
                    if (item.getFieldName().equalsIgnoreCase("requestContent")) {
                        RequestContent = new String(item.getString().getBytes("ISO8859_1"), "utf-8");
                        formItems.remove(item);
                        break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        /**
         * 验证请求正文是否为规范的SONObject格式
         */
        JSONObject requestcontent = null;
        try {
            requestcontent = JSONObject.parseObject(RequestContent);
        } catch (Exception e) {
            writeErrResponse(response, "请求正文格式错误，必须为JSONObject格式");
            return;
        }

        String result = "";
        try {
            long apiid = requestcontent.getLongValue("id");
            int apiversion = requestcontent.getIntValue("version");
            YOSAPI yosapi;
            if (apiid <= 0) {
                yosapi = YOSAPI.getApi("restcontroller." + requestcontent.getString("classname"), requestcontent.getString("method"));
            } else {
                yosapi = YOSAPI.getApi(apiid, apiversion);
            }
            YOSAPI.YosRequest yosRequest = new YOSAPI.YosRequest();
            yosRequest.setRequestKey(Encryption.Encode_MD5(RequestContent));
            yosRequest.setAccesstoken(requestcontent.getOrDefault("accesstoken", "").toString());
            yosRequest.setContent(requestcontent.getJSONObject("content"));
            yosRequest.setFileItems(formItems);

            result = yosapi.action(yosRequest).toString();
        } catch (YosException e) {
            e.printStackTrace();
            writeErrResponse(response, e.toString());
        }
        PrintWriter writer = response.getWriter();
        writer.println(result);
        writer.flush();
    }

    private boolean istokeninuserlist(String accesstoken, HttpServletRequest request) throws YosException {
        DBConnect dbConnect = new DBConnect();
        SQLFactory factory = new SQLFactory(this, "持久化账号列表查询");
        factory.addParameter("accesstoken", accesstoken);
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());
        if (rows.isEmpty()) {
            return false;
        } else {
            for (Row row : rows) {
                long usersiteid = row.getLong("usersiteid");
                row.put("logintime", BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime()));
                row.put("ip", WebRequest.getRequestIP(request));
                row.put("useragent", WebRequest.getUserAgent(request));
                parameter.usersiteIdList.put(usersiteid, row);
                parameter.tokenlist.put(accesstoken, usersiteid);
            }
            return true;
        }
    }

    /**
     * 记录请求数
     *
     * @param key
     * @param fromdb
     * @param time
     */
    private void saveCallMethodMsg(String key, boolean fromdb, long time) {
        long callmethodTimes = parameter.callmethodTimes.containsKey(key) ? parameter.callmethodTimes.get(key) : 0L;

        //更新请求总数
        parameter.callmethodTimes.put(key, callmethodTimes + 1L);

        //最新请求时间
        parameter.lastcallmethodtime.put(key, Calendar.getInstance().getTime());

        //从缓存获取的次数
        long callmethod_fromcacheTimes = parameter.callmethod_fromcacheTimes.containsKey(key) ? parameter.callmethod_fromcacheTimes.get(key) : 0L;
        if (!fromdb) {
            /**
             * 方法请求从缓存获取次数
             */
            parameter.callmethod_fromcacheTimes.put(key, callmethod_fromcacheTimes + 1L);
        } else {
            /**
             * 方法请求查询最新耗时
             */
            parameter.callmethodLastTimeLong.put(key, time);


            long totaltimes = callmethodTimes - callmethod_fromcacheTimes;

            /**
             * 方法请求查询平均时间
             */
            long callmethodTimeLong = parameter.callmethodTimeLong.containsKey(key) ? parameter.callmethodTimeLong.get(key) : 0L;

            parameter.callmethodTimeLong.put(key, (callmethodTimeLong * totaltimes + time) / (totaltimes + 1));
        }
    }

    private void writeErrResponse(HttpServletResponse response, String errmsg) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(new ReturnObject().getErrObject().setErrMsg(errmsg));
        writer.flush();
    }
}
