package common.mq;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.*;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

import javax.jms.*;
import javax.jms.Message;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;

public class ClientMQTT {

    public static HashMap<Long, MqttClient> connectionMap = new HashMap<>();

    /**
     * 主题订阅
     *
     * @param qos 服务器接收消息的质量
     */
    public static void subscribe(long sys_mqid, ArrayList<String> topicList, int qos) {
        try {
            if (connectionMap.containsKey(sys_mqid)) {
                for (String topics : topicList) {
                    connectionMap.get(sys_mqid).subscribe(topics, qos);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 主题订阅
     *
     * @param topics 主题层级分隔符—“/”：用于分割主题层级，/分割后的主题，这是消息主题层级设计中很重要的符号
     *               单层通配符—-“+”：单层通配符只能匹配一层主题。e.g: aaaa/+ 可以匹配 aaaa/bbbb ，但是不能匹配aaaa/bbbb/cccc。 单独的+号可以匹配单层的所有推送
     *               多层通配符—-“#”：多层通配符，多层通配符可以匹配于多层主题。比如: aaaa/# 不但可以匹配aaaa/bbbb，还可以匹配aaaa/bbbb/cccc/dddd。 也就是说，多层通配符可以匹配符合通配符之前主题层级的所有子集主题。单独的#匹配所有的消息主题
     *               通配符 —-“$”:通配符“$”表示匹配一个字符，只要不是放在主题的最开头，即：xx/xx/xx$
     * @param qos
     */
    public static void subscribe(long sys_mqid, String topics, int qos) {
        ArrayList<String> list = new ArrayList<>();
        list.add(topics);
        subscribe(sys_mqid, list, qos);
    }

    /**
     * 取消主题订阅
     *
     * @param topic
     */
    public static void unsubscribe(long sys_mqid, String topic) {
        try {
            if (connectionMap.containsKey(sys_mqid)) {
                connectionMap.get(sys_mqid).unsubscribe(topic);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 根据指令队列进行消息发送
     *
     * @param w_function_queueid
     * @return
     */
    public static void publish(long w_function_queueid) {
        try {
            Rows rows = new DBConnect().runSqlQuery("select t1.topic,t1.params,t1.msgid,t2.serialnumber,t2.isfeedback from w_function_queue t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid where t1.w_function_queueid=" + w_function_queueid);
            for (Row row : rows) {
                String topic = row.getString("topic");
                JSONObject params = row.getJSONObject("params");
                String msgid = row.getString("msgid");
                String serialnumber = row.getString("serialnumber");
                boolean isfeedback = row.getBoolean("isfeedback");

                MQDatas.MQData mqData = new MQDatas().createMQData(Calendar.getInstance().getTimeInMillis());
                mqData.setMsgid(msgid);
                for (String key : params.keySet()) {
                    mqData.put(key, params.get(key));
                }
                if (publish(serialnumber, topic, mqData)) {
                    if (isfeedback) {
                        new DBConnect().runSqlUpdate("update w_function_queue set issend=1,sendcount=sendcount+1,lastsendtime=now() where w_function_queueid=" + w_function_queueid);
                    } else {
                        //如果设备不需要指令反馈，发送即默认为已接收
                        new DBConnect().runSqlUpdate("update w_function_queue set issend=1,sendcount=1,isreceive=1,receivetime='" + mqData.getTs() + "',lastsendtime=now() where w_function_queueid=" + w_function_queueid);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 通过主题发布消息
     *
     * @param topic  推送的主题
     * @param mqData
     */
    public static boolean publish(String clientid, String topic, MQDatas.MQData mqData) throws Exception {
        return publish(clientid, topic, mqData, 1, false);
    }

    /**
     * 通过主题发布消息
     *
     * @param clientid 客户端ID
     * @param topic    推送的主题
     * @param mqData   推送的消息内容
     * @param qos      服务器接收消息的质量
     * @param retain   消息是否保持，true则最后一条消息将一直保留。订阅端每次连接后都会获取最后一条消息
     */
    public static boolean publish(String clientid, String topic, MQDatas.MQData mqData, int qos, boolean retain) {
        try {
            long sys_mqid = getConnectClientMQID(clientid);
            if (connectionMap.containsKey(sys_mqid) && connectClientIDMap.containsValue(clientid) && sys_mqid > 0) {
                MqttMessage mqttMessage = new MqttMessage();
                mqttMessage.setQos(qos);
                mqttMessage.setRetained(retain);
                byte[] msg = msgConvert(topic, mqData);
                mqttMessage.setPayload(msg);
                connectionMap.get(sys_mqid).publish(topic, mqttMessage);
                if (Parameter.get("system_topic_log").equalsIgnoreCase("true")) {
                    BaseClass baseClass = new BaseClass();
                    InsertSQL rowInsert = SQLFactory.createInsertSQL(baseClass.dbConnect, "w_device_topics_log");
                    rowInsert.setValue("w_device_topics_logid", baseClass.createTableID("w_device_topics_log"));
                    rowInsert.setValue("topic", topic);
                    rowInsert.setValue("content", new String(msg, StandardCharsets.UTF_8));
                    rowInsert.setDateValue("createdate");
                    rowInsert.insert();

                    baseClass.dbConnect.runSqlUpdate("delete t1 from w_device_topics_log t1 \n" +
                            "left join (select w_device_topics_logid from w_device_topics_log where topic='" + topic + "' order by w_device_topics_logid desc limit 10) t2 on t1.w_device_topics_logid=t2.w_device_topics_logid\n" +
                            "where t1.topic='" + topic + "' and t2.w_device_topics_logid is null");
                }
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 发布消息协议转换
     *
     * @param topic
     * @param mqData
     * @return
     */
    private static byte[] msgConvert(String topic, MQDatas.MQData mqData) {
        try {
            Rows w_deviceRows = new DBConnect().runSqlQuery("select t3.issystem,t3.jarpath from w_device_topics t1 " +
                    "inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid " +
                    "inner join sys_msgprotocol t3 on t2.sys_msgprotocolid=t3.sys_msgprotocolid and t3.protocoltype='mqtt' " +
                    "where t2.isused=1 and t1.topic='" + topic + "'");
            for (Row w_deviceRow : w_deviceRows) {
                boolean issystem = w_deviceRow.getBoolean("issystem");
                if (issystem) {
                    JSONObject object = new JSONObject();
                    object.put("ts", mqData.getTs());
                    object.put("msgid", mqData.getMsgid());
                    object.put("d", JSONObject.toJSON(mqData));
                    return object.toJSONString().getBytes(StandardCharsets.UTF_8);
                } else {
                    String jarpath = w_deviceRow.getString("jarpath");
                    if (System.getProperty("os.name").contains("Windows")) {
                        jarpath = "file:/" + jarpath;
                    } else {
                        jarpath = "file://" + jarpath;
                    }
                    Class<?> MsgProtocol = Class.forName(
                            "MsgProtocol",
                            true,
                            new URLClassLoader(new URL[]{new URL(jarpath)}, ClientMQTT.class.getClassLoader())
                    );
                    Object instance = MsgProtocol.newInstance();
                    Method method = MsgProtocol.getDeclaredMethod("publish", String.class, MQDatas.MQData.class);
                    return (byte[]) method.invoke(instance, topic, mqData);
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return JSONObject.toJSONString(mqData).getBytes(StandardCharsets.UTF_8);
    }

    /**
     * 当前在线的客户端
     */
    private static HashMap<String, String> connectClientIDMap = new HashMap<>();
    /**
     * 当前在线的客户端所在消息服务器
     */
    private static HashMap<String, Long> connectClientIDMQIDMap = new HashMap<>();

    /**
     * 初始化订阅
     */
    public static void MQinit() {
        try {
            DBConnect dbConnect = new DBConnect();
            Rows sys_mqRows = dbConnect.runSqlQuery("select jmxaddress,password,username,address,sys_mqid from sys_mq");
            for (Row sys_mqRow : sys_mqRows) {
                try {
                    String address = sys_mqRow.getString("address");
                    String jmxaddress = sys_mqRow.getString("jmxaddress");
                    String username = sys_mqRow.getString("username");
                    String password = sys_mqRow.getString("password");
                    long sys_mqid = sys_mqRow.getLong("sys_mqid");
                    MqttClient mqttClient = new MqttClient(address, clientid, new MemoryPersistence());
                    mqttClient.setCallback(new MQMessage(sys_mqid));

                    MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                    mqttConnectOptions.setCleanSession(true);
                    mqttConnectOptions.setKeepAliveInterval(10);
                    mqttConnectOptions.setConnectionTimeout(15);
                    mqttConnectOptions.setUserName(username);
                    mqttConnectOptions.setPassword(password.toCharArray());

                    mqttClient.connect(mqttConnectOptions);
                    //mqttClient.subscribe("wateraffairs/#", 1);
                    mqttClient.subscribe("wateraffairs/+/+/data", 1);
                    mqttClient.subscribe("wateraffairs/+/+/rec", 1);
                    connectionMap.put(sys_mqid, mqttClient);
                    Thread.sleep(1000L);
                    JmxService(sys_mqid, username, password, jmxaddress);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, Integer> onlineClientid = new HashMap<>();

    /**
     * 必须为内网访问
     *
     * @param sys_mqid
     * @param userName
     * @param password
     * @param brokerURL
     */
    private static void JmxService(Long sys_mqid, String userName, String password, String brokerURL) {
        new Thread() {
            @Override
            public void run() {
                super.run();
                try {
                    ConnectionFactory factory = new ActiveMQConnectionFactory(userName, password, brokerURL);
                    Connection connection = factory.createConnection();
                    connection.setClientID(clientid + "连接" + sys_mqid + "监控:" + Calendar.getInstance().getTimeInMillis());
                    connection.start();

                    final Session session = connection.createSession(false/*支持事务*/, Session.AUTO_ACKNOWLEDGE);

                    /*
                     *客户端上线离线监控
                     */
                    ActiveMQTopic test = AdvisorySupport.getConnectionAdvisoryTopic();
                    MessageConsumer consumer = session.createConsumer(test);
                    consumer.setMessageListener(new MessageListener() {
                        public void onMessage(Message message) {
                            if (message instanceof ActiveMQMessage) {
                                ActiveMQMessage msg = (ActiveMQMessage) message;
                                if (msg.getDataStructure() instanceof ConnectionInfo) {
                                    ConnectionInfo info = (ConnectionInfo) msg.getDataStructure();
                                    System.out.println(BaseClass.getDateTime_Str() + "设备上线 serialnumber:" + info.getClientId());
                                    connectClientIDMap.put(info.getConnectionId().getValue(), info.getClientId());
                                    connectClientIDMQIDMap.put(info.getClientId(), sys_mqid);
                                    try {
                                        onlineClientid.put(info.getClientId(), onlineClientid.getOrDefault(info.getClientId(), 0) + 1);
                                        if (onlineClientid.getOrDefault(info.getClientId(), 0) == 1) {
                                            // System.out.println(BaseClass.getDateTime_Str() + "设备上线 serialnumber:" + info.getClientId());

                                            new DBConnect().runSqlUpdate("update w_device set status='在线',lastconnecttime=now() where serialnumber='" + info.getClientId() + "'");
                                            new Thread() {
                                                @Override
                                                public void run() {
                                                    super.run();
                                                    try {
                                                        Thread.sleep(1000L);
                                                        //检查有无未发送的指令，如果有则发送
                                                        Rows rows = new DBConnect().runSqlQuery("select w_function_queueid from w_function_queue t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid where t1.invalid=0 and t1.isreceive=0 and t2.serialnumber='" + info.getClientId() + "'");
                                                        for (Row row : rows) {
                                                            publish(row.getLong("w_function_queueid"));
                                                            Thread.sleep(100L);
                                                        }
                                                    } catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }.start();
                                            MQMessage.deviceMsgStatusInit(info.getClientId());
                                        }
                                    } catch (YosException e) {
                                        e.printStackTrace();
                                    }
                                } else if (msg.getDataStructure() instanceof RemoveInfo) {
                                    RemoveInfo info = (RemoveInfo) msg.getDataStructure();
                                    try {
                                        if (connectClientIDMap.containsKey(info.getObjectId().toString())) {
                                            String serialnumber = connectClientIDMap.get(info.getObjectId().toString());
                                            System.out.println(BaseClass.getDateTime_Str() + "设备离线 serialnumber:" + serialnumber);
                                            onlineClientid.put(serialnumber, onlineClientid.getOrDefault(serialnumber, 0) - 1);
                                            if (onlineClientid.get(serialnumber) <= 0) {
                                                onlineClientid.remove(serialnumber);
                                                connectClientIDMQIDMap.remove(serialnumber);
                                                //System.out.println(BaseClass.getDateTime_Str() + "设备离线 serialnumber:" + serialnumber);
                                                ArrayList<String> sqlist = new ArrayList<>();
                                                sqlist.add("update w_device set status='离线',lastconnecttime=now() where serialnumber='" + serialnumber + "'");
                                                sqlist.add("update w_function_queue t1 inner join w_device t2 on t1.w_deviceid=t2.w_deviceid set t1.invalid=1 where t1.isreceive=0 and t1.invalid=0 and t1.sendcount>=2 and t2.serialnumber='" + serialnumber + "'");
                                                new DBConnect().runSqlUpdate(sqlist);
                                                MQMessage.deviceMsgStatusInit(serialnumber);
                                            }
                                        }
                                    } catch (YosException e) {
                                        e.printStackTrace();
                                    }
                                    connectClientIDMap.remove(info.getObjectId().toString());
                                }
                            }
                        }
                    });
                    /*
                     *消息消费监听
                     */
//                    ActiveMQTopic activeMQTopic = AdvisorySupport.getMessageConsumedAdvisoryTopic(new ActiveMQTopic());
//                    System.err.println(activeMQTopic.getTopicName());
//                    MessageConsumer c = session.createConsumer(session.createTopic("wateraffairs/+/+/cmd.MessageConsumed"));
//                    c.setMessageListener(new MessageListener() {
//                        @Override
//                        public void onMessage(Message message) {
//                            System.err.println("消息接收：" + message);
//                            try {
//                                // 获取消息被消费的通知消息内容
//                                TextMessage textMessage = (TextMessage) message;
//                                System.out.println(textMessage.getText());
//                                String messageId = textMessage.getStringProperty("originalMessageId");
//                                String consumerId = textMessage.getStringProperty("consumerId");
//
//                                // 处理消息被消费的通知
//                                System.out.println("Message ID: " + messageId + ", Consumer ID: " + consumerId);
//                            } catch (Exception e) {
//                                e.printStackTrace();
//                            }
//                        }
//                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private static String clientid = "WAServer";

    public static void disconnect(long sys_mqid) {
        try {
            if (connectionMap.containsKey(sys_mqid)) {
                connectionMap.get(sys_mqid).disconnect();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取当前在线的客户端id
     *
     * @return
     */
    public static Collection<String> connectClientIDMap() {
        return connectClientIDMap.values();
    }

    /**
     * 获取当前在线的客户端所在消息服务器ID
     *
     * @return
     */
    public static long getConnectClientMQID(String clientid) {
        return connectClientIDMQIDMap.getOrDefault(clientid, 0L);
    }
}
