/*
 * Decompiled with CFR 0.152.
 */
package utility.email;

import beans.parameter.Parameter;
import common.BaseClass;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import utility.email.EmailContent;

public class Email
extends BaseClass {
    Session session = null;
    Transport transport = null;
    MimeMessage message = null;

    public Email(String siteid, String subject, String[] tos) throws Exception {
        this.init(siteid, subject, tos);
    }

    public Email(String siteid, String subject, String to) throws Exception {
        this.init(siteid, subject, new String[]{to});
    }

    public Email(String siteid, String subject, ArrayList<String> tolist) throws Exception {
        this.init(siteid, subject, tolist.toArray(new String[0]));
    }

    private void init(String siteid, String subject, String[] tos) throws Exception {
        Properties prop = new Properties();
        prop.setProperty("mail.host", Parameter.get(siteid, "mail_host"));
        prop.setProperty("mail.transport.protocol", Parameter.get(siteid, "mail_transport_protocol"));
        prop.setProperty("mail.smtp.auth", Parameter.get(siteid, "mail_smtp_auth").equals("1") ? "true" : "false");
        this.session = Session.getInstance((Properties)prop);
        this.message = new MimeMessage(this.session);
        this.message.setFrom(Parameter.get(siteid, "mail_sendfrom"));
        ArrayList<InternetAddress> address = new ArrayList<InternetAddress>();
        for (String to : tos) {
            address.add(new InternetAddress(to));
        }
        this.message.setRecipients(Message.RecipientType.TO, address.toArray(new Address[0]));
        this.message.setSubject(subject);
    }

    public void send(String siteid, EmailContent emailContent) throws Exception {
        this.message.setContent((Multipart)emailContent);
        this.transport = this.session.getTransport();
        this.transport.connect(Parameter.get(siteid, "mail_host"), Parameter.get(siteid, "mail_user"), Parameter.get(siteid, "mail_password"));
        this.transport.sendMessage((Message)this.message, this.message.getAllRecipients());
        this.transport.close();
    }
}

