/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.helpdocs;

import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import java.util.ArrayList;
import restcontroller.R;

public class helpdocs
extends Controller {
    public helpdocs(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u5e2e\u52a9\u6587\u6863\u67e5\u8be2", apiversion=R.ID10024701.v1.class)
    public String query() throws YosException {
        String ownertable = this.content.getString("ownertable");
        long ownerid = this.content.getLongValue("ownerid");
        String type = this.content.getStringValue("type");
        String doctype = this.content.getStringValue("doctype");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_helpdocs", new String[0]);
        querySQL.setWhere("ownertable", ownertable);
        if (ownerid > 0L) {
            querySQL.setWhere("ownerid", ownerid);
        }
        if (!type.equals("")) {
            querySQL.setWhere("type", type);
        }
        if (!doctype.equals("")) {
            querySQL.setWhere("doctype", doctype);
        }
        Rows rows = querySQL.query();
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u67e5\u8be2\u5e2e\u52a9\u6587\u6863", apiversion=R.ID10024901.v1.class)
    public String getHelpDoc() throws YosException {
        JSONArray systemappids;
        if (this.content.containsKey("systemappids")) {
            systemappids = this.content.getJSONArray("systemappids");
            if (systemappids.size() == 0) {
                systemappids = this.dbConnect.runSqlQuery("select systemappid from sys_systemapp ").toJsonArray("systemappid");
            }
        } else if (this.content.containsKey("roleids")) {
            JSONArray roleidArray = this.content.getJSONArray("roleids");
            if (roleidArray.size() == 0) {
                systemappids = this.dbConnect.runSqlQuery("select systemappid from sys_systemapp ").toJsonArray("systemappid");
            } else {
                ArrayList<Long> roleidList = new ArrayList<Long>();
                for (Object o : roleidArray) {
                    roleidList.add(Long.parseLong(o.toString()));
                }
                SQLFactory sqlFactory = new SQLFactory("sql:select distinct systemappid from sys_roleappoptionauth where roleid in $roleids$");
                sqlFactory.addParameter_in("roleids", roleidList);
                Rows rows = sqlFactory.runSqlQuery(this.dbConnect);
                systemappids = rows.toJsonArray("systemappid");
            }
        } else {
            SQLFactory sqlFactory = new SQLFactory("sql:select distinct systemappid from sys_roleappoptionauth where roleid in $roleids$");
            sqlFactory.addParameter_in("roleids", User.getUserRoleIDs(this, this.userid));
            Rows rows = sqlFactory.runSqlQuery(this.dbConnect);
            systemappids = rows.toJsonArray("systemappid");
        }
        StringBuilder doc = new StringBuilder();
        QuerySQL systemAppDocQuerySQL = SQLFactory.createQuerySQL(this, "sys_systemapp", new String[0]);
        systemAppDocQuerySQL.addQueryFields("sys_system.systemid", "sys_system.systemname", "sys_systemclient.systemclientid", "sys_systemclient.systemclientname", "sys_systemmodule.systemmoduleid", "sys_systemmodule.systemmodulename", "sys_systemapp.systemappid", "sys_systemapp.systemappname", "sys_helpdocs.content");
        systemAppDocQuerySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_systemmodule", "sys_systemmodule", "sys_systemmodule.systemmoduleid=sys_systemapp.systemmoduleid");
        systemAppDocQuerySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_systemclient", "sys_systemclient", "sys_systemclient.systemclientid=sys_systemmodule.systemclientid");
        systemAppDocQuerySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_system", "sys_system", "sys_system.systemid=sys_systemclient.systemid");
        systemAppDocQuerySQL.addJoinTable(BaseClass.JOINTYPE.left, "sys_helpdocs", "sys_helpdocs", "sys_helpdocs.ownertable='sys_systemapp' and sys_helpdocs.ownerid=sys_systemapp.systemappid and sys_helpdocs.doctype='markdown' and sys_helpdocs.type='help' ");
        systemAppDocQuerySQL.setWhere("systemappid", systemappids);
        systemAppDocQuerySQL.setOrderBy("sys_system.sequence,sys_systemclient.systemclientid,sys_systemmodule.sequence,sys_systemapp.sequence");
        Rows systemAppClientdocRows = systemAppDocQuerySQL.query();
        ArrayList<Long> systemids = new ArrayList<Long>();
        ArrayList<Long> systemclientids = new ArrayList<Long>();
        ArrayList<Long> systemmoduleids = new ArrayList<Long>();
        for (Row systemAppClientdocRow : systemAppClientdocRows) {
            Rows rows;
            long systemid = systemAppClientdocRow.getLong("systemid");
            String systemname = systemAppClientdocRow.getString("systemname");
            long systemclientid = systemAppClientdocRow.getLong("systemclientid");
            String systemclientname = systemAppClientdocRow.getString("systemclientname");
            long systemmoduleid = systemAppClientdocRow.getLong("systemmoduleid");
            String systemmodulename = systemAppClientdocRow.getString("systemmodulename");
            long systemappid = systemAppClientdocRow.getLong("systemappid");
            String systemappname = systemAppClientdocRow.getString("systemappname");
            String content = systemAppClientdocRow.getString("content");
            if (!systemids.contains(systemid)) {
                rows = this.dbConnect.runSqlQuery("select content from sys_helpdocs where ownertable='sys_system' and ownerid=" + systemid + " and doctype='markdown' and type='help'");
                if (rows.isEmpty() || rows.get(0).getString("content").equals("")) {
                    doc.append("# " + systemname + "\n\u7cfb\u7edf\u63cf\u8ff0\u8bf4\u660e").append("\n");
                } else {
                    doc.append(rows.get(0).getString("content")).append("\n");
                }
                systemids.add(systemid);
            }
            if (!systemclientids.contains(systemclientid)) {
                rows = this.dbConnect.runSqlQuery("select content from sys_helpdocs where ownertable='sys_systemclient' and ownerid=" + systemclientid + " and doctype='markdown' and type='help'");
                if (rows.isEmpty() || rows.get(0).getString("content").equals("")) {
                    doc.append("## " + systemclientname + "\n\u64cd\u4f5c\u7aef\u63cf\u8ff0\u8bf4\u660e").append("\n");
                } else {
                    doc.append(rows.get(0).getString("content")).append("\n");
                }
                systemclientids.add(systemclientid);
            }
            if (!systemmoduleids.contains(systemmoduleid)) {
                rows = this.dbConnect.runSqlQuery("select content from sys_helpdocs where ownertable='sys_systemmodule' and ownerid=" + systemmoduleid + " and doctype='markdown' and type='help'");
                if (rows.isEmpty() || rows.get(0).getString("content").equals("")) {
                    doc.append("### " + systemmodulename + "\n\u6a21\u5757\u63cf\u8ff0\u8bf4\u660e").append("\n");
                } else {
                    doc.append(rows.get(0).getString("content")).append("\n");
                }
                systemmoduleids.add(systemmoduleid);
            }
            if (content == null || content.equals("")) {
                doc.append("#### " + systemappname + "\n\u5e94\u7528\u63cf\u8ff0\u8bf4\u660e").append("\n");
                continue;
            }
            doc.append(content).append("\n");
        }
        return this.getSucReturnObject().setData(doc).toString();
    }

    @API(title="\u5e2e\u52a9\u6587\u6863\u67e5\u8be2", apiversion=R.ID10024801.v1.class)
    public String insertOrUpdate() throws YosException {
        long sys_helpdocsid = this.content.getLongValue("sys_helpdocsid");
        String ownertable = this.content.getString("ownertable");
        long ownerid = this.content.getLongValue("ownerid");
        String type = this.content.getStringValue("type");
        String doctype = this.content.getStringValue("doctype");
        String content_str = this.content.getStringValue("content", true);
        if (((QuerySQL)SQLFactory.createQuerySQL(this, "sys_helpdocs", new String[0]).setUniqueid(sys_helpdocsid)).query().isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_helpdocs");
            insertSQL.setValue("sys_helpdocsid", this.createTableID("sys_helpdocs"));
            insertSQL.setValue("ownertable", ownertable);
            insertSQL.setValue("ownerid", ownerid);
            insertSQL.setValue("type", type);
            insertSQL.setValue("doctype", doctype);
            insertSQL.setValue("content", content_str);
            insertSQL.insert();
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_helpdocs");
            updateSQL.setValue("content", content_str);
            updateSQL.setUniqueid(sys_helpdocsid);
            updateSQL.update();
        }
        return this.getSucReturnObject().toString();
    }
}

