/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import com.alibaba.fastjson.JSON;
import com.mysql.cj.jdbc.result.ResultSetMetaData;
import com.mysql.cj.result.Field;
import common.BaseClass;
import common.YosException;
import common.YosLogger;
import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnectPool;
import common.data.db.SQLLog;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class DBConnect
implements YosLogger {
    private boolean createsqllog = false;
    private String databasekey;
    private ArrayList<SQLLog> sqlLogList = new ArrayList();
    public static HashMap<String, String> dbprodnamemap = new HashMap();

    public DBConnect() {
        this.databasekey = "default";
    }

    public DBConnect(String databasekey) {
        this.databasekey = databasekey;
    }

    public String getDBName() throws YosException {
        if (this.databasekey.equals("default")) {
            return this.runSqlQuery(0, "select database() as dbname").getString("dbname");
        }
        return this.runSqlQuery(0, "select dbname from sys_datasource where datakey='" + this.databasekey + "'").getString("dbname");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBProduct() throws YosException {
        String name = "";
        DBConnectPool.YosConnection yosConnection = new DBConnectPool().getConnect(this.databasekey);
        try {
            name = yosConnection.getConnection().getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            new DBConnectPool().close(yosConnection);
        }
        return name;
    }

    public void setCreatesqllog(boolean createsqllog) {
        this.createsqllog = createsqllog;
    }

    public ArrayList<SQLLog> getSqlLogList() {
        return this.sqlLogList;
    }

    public void clearSqlLogList() {
        this.sqlLogList.clear();
    }

    public Row runSqlQuery(int index, SQLFactory sqlFactory) throws YosException {
        return this.runSqlQuery(sqlFactory).get(index);
    }

    public Row runSqlQuery(int index, String SQL) throws YosException {
        return this.runSqlQuery(SQL).get(index);
    }

    public Rows runSqlQuery(SQLFactory sqlFactory) throws YosException {
        return this.runSqlQuery(sqlFactory.getSQL(this));
    }

    private String getDBProdName(Connection conn) {
        try {
            if (!dbprodnamemap.containsKey(this.databasekey)) {
                dbprodnamemap.put(this.databasekey, conn.getMetaData().getDatabaseProductName());
            }
            return dbprodnamemap.get(this.databasekey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Rows runSqlQuery(String SQL) throws YosException {
        long starttimes = Calendar.getInstance().getTimeInMillis();
        DBConnectPool.YosConnection yosConnection = new DBConnectPool().getConnect(this.databasekey);
        Connection conn = yosConnection.getConnection();
        if (conn == null) {
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25"));
            }
            throw new YosException(this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
        String DBProdName = this.getDBProdName(conn);
        Rows rows = new Rows();
        ResultSet resultSet = null;
        ResultSet found_rowsResultSet = null;
        PreparedStatement statement = null;
        long total = -1L;
        long pageTotal = -1L;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();
            java.sql.ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            if (DBProdName.equals("MySQL") && SQL.contains("SQL_CALC_FOUND_ROWS")) {
                statement = conn.prepareStatement("SELECT FOUND_ROWS()");
                found_rowsResultSet = statement.executeQuery();
                while (found_rowsResultSet.next()) {
                    total = found_rowsResultSet.getLong(1);
                }
            }
            ArrayList<String> colNameList = new ArrayList<String>();
            HashMap<String, FieldMeta> getFieldMetaMap = new HashMap<String, FieldMeta>();
            for (int i = 0; i < colCount; ++i) {
                Field[] fields;
                FieldMeta fieldmeta = new FieldMeta();
                fieldmeta.setTable_name(rsmd.getTableName(i + 1));
                fieldmeta.setColumn_name(rsmd.getColumnName(i + 1));
                fieldmeta.setPrecision(rsmd.getPrecision(i + 1));
                fieldmeta.setScale(rsmd.getScale(i + 1));
                if (DBProdName.equals("MySQL") && (fields = ((ResultSetMetaData)rsmd).getFields()).length > i) {
                    fieldmeta.setTable_alias(fields[i].getTableName());
                }
                String Columnlabel = rsmd.getColumnLabel(i + 1);
                fieldmeta.setColumn_label(Columnlabel);
                colNameList.add(Columnlabel);
                switch (rsmd.getColumnTypeName(i + 1).toLowerCase()) {
                    case "int": 
                    case "smallint": {
                        fieldmeta.setFieldtype(Integer.class);
                        break;
                    }
                    case "bigint": {
                        fieldmeta.setFieldtype(Long.class);
                        break;
                    }
                    case "float": 
                    case "numeric": 
                    case "decimal": {
                        fieldmeta.setFieldtype(BigDecimal.class);
                        break;
                    }
                    case "date": 
                    case "datetime": {
                        fieldmeta.setFieldtype(Date.class);
                        break;
                    }
                    case "boolean": {
                        fieldmeta.setFieldtype(Boolean.class);
                        break;
                    }
                    case "json": {
                        fieldmeta.setFieldtype(JSON.class);
                        break;
                    }
                    default: {
                        fieldmeta.setFieldtype(String.class);
                    }
                }
                getFieldMetaMap.put(Columnlabel, fieldmeta);
            }
            boolean addrowindex = !colNameList.contains("rowindex");
            int rowindex = 1;
            long pageNumber = -1L;
            long pageSize = -1L;
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; ++i) {
                    Object value;
                    String key = (String)colNameList.get(i);
                    Class clazz = ((FieldMeta)getFieldMetaMap.get(key)).getFieldtype();
                    if (clazz == Integer.class) {
                        value = resultSet.getInt(colNameList.get(i));
                    } else if (clazz == Long.class) {
                        value = resultSet.getLong(colNameList.get(i));
                    } else if (clazz == BigDecimal.class) {
                        value = resultSet.getBigDecimal(colNameList.get(i));
                    } else if (clazz == Boolean.class) {
                        value = resultSet.getBoolean(colNameList.get(i));
                    } else if (clazz == JSON.class) {
                        value = JSON.parse((String)resultSet.getString(colNameList.get(i)));
                    } else if (clazz == Date.class) {
                        value = resultSet.getString(colNameList.get(i));
                        if (value != null) {
                            value = ((String)value).replace(" 00:00:00.0", "");
                        }
                    } else {
                        Object objvalue = resultSet.getObject(colNameList.get(i));
                        Object object = value = objvalue == null ? "" : objvalue;
                    }
                    if ("total".equals(key)) {
                        total = total < 0L ? (Long)value : total;
                        continue;
                    }
                    if ("pageTotal".equals(key)) {
                        if (value instanceof Long) {
                            pageTotal = pageTotal < 0L ? (Long)value : pageTotal;
                            continue;
                        }
                        if (value instanceof BigDecimal) {
                            pageTotal = pageTotal < 0L ? ((BigDecimal)value).longValue() : pageTotal;
                            continue;
                        }
                        if (value == null) continue;
                        pageTotal = pageTotal < 0L ? Long.parseLong(value.toString()) : pageTotal;
                        continue;
                    }
                    if ("pageNumber".equals(key)) {
                        pageNumber = (Long)value;
                        continue;
                    }
                    if ("pageSize".equals(key)) {
                        pageSize = (Long)value;
                        continue;
                    }
                    row.put(key, value);
                }
                if (addrowindex) {
                    if (pageNumber > 0L && pageSize > 0L) {
                        row.put("rowindex", (pageNumber - 1L) * pageSize + (long)rowindex++);
                    } else {
                        row.put("rowindex", rowindex++);
                    }
                }
                rows.add(row);
            }
            if (total > 0L) {
                rows.totalRows = total;
            }
            if (pageTotal > 0L) {
                rows.totalPage = pageTotal;
            } else if (pageSize > 0L) {
                rows.totalPage = new Double(Math.ceil((double)total / (double)pageSize)).longValue();
            }
            if (rows.totalRows == 0L) {
                rows.totalRows = rows.size();
                rows.totalPage = 1L;
            }
            rows.setFieldList(colNameList);
            rows.setFieldMetaMap(getFieldMetaMap);
        }
        catch (SQLException e) {
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
            }
            throw new YosException(this.databasekey + "\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + SQL + System.lineSeparator() + e.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw new YosException(e.getMessage());
                }
            }
            if (found_rowsResultSet != null) {
                try {
                    found_rowsResultSet.close();
                }
                catch (SQLException e) {
                    throw new YosException(e.getMessage());
                }
            }
            this.close(yosConnection, statement);
        }
        if (this.createsqllog) {
            this.sqlLogList.add(new SQLLog(SQL, Calendar.getInstance().getTimeInMillis() - starttimes, rows.size()));
        }
        return rows;
    }

    public void runSqlUpdate(SQLFactory sqlFactory) throws YosException {
        this.runSqlUpdate(sqlFactory.getSQL());
    }

    public int runSqlUpdate(String SQL) throws YosException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SQL);
        return this.runSqlUpdate(list);
    }

    public int runSqlUpdate(ArrayList<String> SQLlist) throws YosException {
        int affectedrows = 0;
        long starttimes = Calendar.getInstance().getTimeInMillis();
        DBConnectPool.YosConnection yosConnection = new DBConnectPool().getConnect(this.databasekey);
        Connection conn = yosConnection.getConnection();
        if (conn == null) {
            if (this.createsqllog) {
                for (String SQL : SQLlist) {
                    this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25"));
                }
            }
            throw new YosException(this.databasekey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
        PreparedStatement statement = null;
        try {
            for (String sql : SQLlist) {
                statement = conn.prepareStatement(sql);
                affectedrows += statement.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            String errmsg = e.getMessage();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                throw new YosException(e1.getMessage());
            }
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(JSON.toJSON(SQLlist).toString(), this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
            }
            if (errmsg.startsWith("Duplicate entry") && errmsg.endsWith(".PRIMARY'")) {
                errmsg = errmsg.replace("Duplicate entry '", "").replace("' for key '", ",").replace(".PRIMARY'", "");
                String[] s = errmsg.split(",");
                throw new YosException("\u8868" + s[1] + "\u4e3b\u952e ID\u3010" + s[0] + "\u3011\u91cd\u590d\uff01");
            }
            if (errmsg.startsWith("Duplicate entry")) {
                errmsg = errmsg.replace("Duplicate entry '", "").replace("' for key '", ",").replace("'", "");
                String[] s = errmsg.split(",");
                throw new YosException("\u6570\u636e\u3010" + s[0] + "\u3011\u89e6\u53d1\u4e86\u552f\u4e00\u7d22\u5f15" + s[1]);
            }
            if (errmsg.startsWith("DataVersion conflict")) {
                throw new YosException("DataVersion conflict");
            }
            throw new YosException(this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + JSON.toJSON(SQLlist) + System.lineSeparator() + errmsg);
        }
        finally {
            this.close(yosConnection, statement);
        }
        if (this.createsqllog) {
            this.sqlLogList.add(new SQLLog(JSON.toJSON(SQLlist).toString(), Calendar.getInstance().getTimeInMillis() - starttimes, affectedrows));
        }
        return affectedrows;
    }

    private void close(DBConnectPool.YosConnection yosConnection, PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        new DBConnectPool().close(yosConnection);
    }

    public String getDateTime_Str() {
        return BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime());
    }
}

