/*
 * Decompiled with CFR 0.152.
 */
package beans.attachment;

import beans.datacontrllog.DataContrlLog;
import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import java.util.ArrayList;
import java.util.HashMap;
import utility.huawei.obs.BucketFile;

public class Attachment {
    public static Rows get(Controller controller, String ownertable, Long ownerid) throws YosException {
        return Attachment.get(controller, ownertable, ownerid, null);
    }

    public static RowsMap get(Controller controller, String ownertable, ArrayList<Long> ownerids) throws YosException {
        return Attachment.get(controller, ownertable, ownerids, null);
    }

    public static Rows get(Controller controller, String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> id = new ArrayList<Long>();
        id.add(ownerid);
        return Attachment.get(controller, ownertable, id, usetype).getOrDefault(String.valueOf(ownerid), new Rows());
    }

    public static RowsMap get(Controller controller, String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "linksid", "siteid", "ownerid", "ownertable", "usetype", "createdate", "attachmentid");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_attachment", "sys_attachment", "siteid=:siteid and attachmentid=:attachmentid", "document", "postfix", "serialnumber", "url", "contentlength", "isfolder", "parentid", "folderpath");
        querySQL.setWhere("ownertable", ownertable);
        querySQL.setWhere("ownerid", ownerids);
        if (usetype != null) {
            querySQL.setWhere("usetype", usetype);
        }
        querySQL.setOrderBy("linksid");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = Attachment.getSub(controller, rows.toArrayList("attachmentid", new ArrayList()));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("ownerid");
    }

    public static Rows get(Controller controller, Long attachmentid) throws YosException {
        ArrayList<Long> id = new ArrayList<Long>();
        id.add(attachmentid);
        return Attachment.get(controller, id);
    }

    public static Rows get(Controller controller, ArrayList<Long> attachmentids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "linksid", "siteid", "ownerid", "ownertable", "usetype", "createdate", "attachmentid");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_attachment", "sys_attachment", "siteid=:siteid and attachmentid=:attachmentid", "document", "postfix", "serialnumber", "url", "contentlength", "isfolder", "parentid", "folderpath");
        querySQL.setWhere("attachmentid", attachmentids);
        querySQL.setOrderBy("linksid");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = Attachment.getSub(controller, attachmentids);
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows;
    }

    public static Rows getSub(Controller controller, Long attachmentid) throws YosException {
        ArrayList<Long> id = new ArrayList<Long>();
        id.add(attachmentid);
        return Attachment.getSub(controller, id).getOrDefault(String.valueOf(attachmentid), new Rows());
    }

    public static RowsMap getSub(Controller controller, ArrayList<Long> attachmentids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment", "attachmentid", "serialnumber", "url", "type", "contentlength", "parentid", "isfolder", "postfix", "document", "folderpath");
        querySQL.setWhere("parentid", attachmentids);
        querySQL.setOrderBy("attachmentid");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = Attachment.getSub(controller, rows.toArrayList("attachmentid", new ArrayList()));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("parentid");
    }

    public static void main(String[] args) throws YosException {
        System.err.println(Attachment.get(new Controller(new JSONObject()), 38197L).toJsonArray());
    }

    public static long getCount(Controller controller, String ownertable, Long ownerid) throws YosException {
        return Attachment.getCount(controller, ownertable, ownerid, null);
    }

    public static long getCount(Controller controller, String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> id = new ArrayList<Long>();
        id.add(ownerid);
        return Attachment.getCount(controller, ownertable, id, usetype).getOrDefault(ownerid, 0L);
    }

    public static HashMap<Long, Long> getCount(Controller controller, String ownertable, ArrayList<Long> ownerid) throws YosException {
        return Attachment.getCount(controller, ownertable, ownerid, null);
    }

    public static HashMap<Long, Long> getCount(Controller controller, String ownertable, ArrayList<Long> ownerid, String usetype) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "ownerid");
        querySQL.addQueryFields(" attachmentcount", "count(0)");
        querySQL.setWhere("ownertable", ownertable);
        querySQL.setWhere("ownerid", ownerid);
        if (usetype != null) {
            querySQL.setWhere("usetype", usetype);
        }
        querySQL.addGroupBy("ownerid");
        Rows rows = querySQL.query();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (Row row : rows) {
            map.put(row.getLong("ownerid"), row.getLong("attachmentcount"));
        }
        return map;
    }

    public static Row getParent(Controller controller, long attachmentid) throws YosException {
        Rows parentRows;
        Rows rows = Attachment.get(controller, attachmentid);
        if (rows.isNotEmpty() && (parentRows = Attachment.get(controller, rows.get(0).getLong("parentid"))).isNotEmpty()) {
            return parentRows.get(0);
        }
        return new Row();
    }

    public static synchronized void RefreshFolderPath(Controller controller, long attachmentid) throws YosException {
        String folderpath = "0/";
        Row parentRow = Attachment.getParent(controller, attachmentid);
        if (!parentRow.isEmpty()) {
            folderpath = parentRow.getString("folderpath") + parentRow.getLong("attachmentid") + "/";
        }
        controller.dbConnect.runSqlUpdate("update sys_attachment set folderpath='" + folderpath + "' where attachmentid=" + attachmentid);
        SQLFactory sqlFactory = new SQLFactory(new Attachment(), "\u9644\u4ef6\u6587\u4ef6\u8def\u5f84\u521b\u5efa");
        sqlFactory.addParameter("attachmentid", attachmentid);
        controller.dbConnect.runSqlUpdate(sqlFactory.getSQL());
    }

    public static void delete(Controller controller, String ownertable, long ownerid) throws YosException {
        Rows rows = Attachment.get(controller, ownertable, ownerid);
        for (Row row : rows) {
            Attachment.delete(controller, row.getLong("attachmentid"));
        }
    }

    public static void delete(Controller controller, long attachmentid) throws YosException {
        if (controller.dbConnect.runSqlQuery("select *from sys_site_parameter where appfolderid='" + attachmentid + "' or salematerialfolderid='" + attachmentid + "'").isNotEmpty()) {
            throw new YosException(false, "\u7cfb\u7edf\u6587\u4ef6\u5939\u4e0d\u53ef\u5220\u9664");
        }
        String siteid = Attachment.get(controller, attachmentid).get(0).getString("siteid");
        Rows rows = Attachment.getSub(controller, attachmentid);
        ArrayList<String> sqlist = new ArrayList<String>();
        for (Row row : rows) {
            String objectname = row.getString("serialnumber");
            String type = row.getString("type");
            switch (Parameter.get("system_attachment_type")) {
                case "huaweiobs": {
                    try {
                        BucketFile bucketFile = new BucketFile(siteid);
                        if ("hls".equals(type)) {
                            bucketFile.deleteFolder(objectname);
                        } else {
                            bucketFile.deleteFile(objectname);
                        }
                        bucketFile.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "localhost": {
                    break;
                }
            }
            sqlist.add("delete from sys_attachment where (attachmentid='" + row.getString("attachmentid") + "' or parentid='" + row.getString("attachmentid") + "')");
            sqlist.add("delete from sys_attachment_links where attachmentid='" + row.getString("attachmentid") + "'");
            Rows attrows = controller.dbConnect.runSqlQuery("select t2.document,t1.ownertable,t1.ownerid from sys_attachment_links t1 inner join sys_attachment t2 on t1.siteid=t2.siteid and t1.attachmentid=t2.attachmentid where t1.attachmentid=" + row.getString("attachmentid"));
            for (Row attrow : attrows) {
                sqlist.add(DataContrlLog.createLog(controller, attrow.getString("ownertable"), attrow.getLong("ownerid"), "\u5220\u9664\u9644\u4ef6", "\u5220\u9664\u9644\u4ef6" + attrow.getString("document")).getSQL());
            }
        }
        controller.dbConnect.runSqlUpdate(sqlist);
    }
}

