package common.uibuilder;

import beans.systemapp.SystemApp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import common.YosException;

import java.util.ArrayList;
import java.util.HashMap;

public class AppUI {
    public long systemappid;
    public long apiid;
    public int apiversion;
    public String maintable;

    private ArrayList<AppControl> views = new ArrayList<>();

    public static HashMap<AppControl.viewtype, Integer> ControlIDs = new HashMap<>();

    public AppUI(long systemappid) {
        ControlIDs.clear();
        this.systemappid = systemappid;
    }

    public void setApiID(long apiid) {
        this.apiid = apiid;
    }

    public void setApiID(long apiid, int apiversion) {
        this.apiid = apiid;
        this.apiversion = apiversion;
    }

    public void setMainTable(String maintable) {
        this.maintable = maintable;
    }

    public void addView(AppControl appControl) {
        boolean ishave = false;
        int i = 0;
        for (AppControl v : views) {
            if (v.id.equals(appControl.id)) {
                views.set(i, appControl);
                ishave = true;
            }
            i++;
        }
        if (!ishave) {
            views.add(appControl);
        }
    }

    public JSON getUI() throws YosException {
        JSONObject appObject = new JSONObject(true);
        appObject.put("systemappid", systemappid);
        appObject.put("systemapp", SystemApp.getSystemApp(systemappid));
        appObject.put("label", SystemApp.getSystemAppName(systemappid));
        appObject.put("apiid", apiid);
        appObject.put("apiversion", apiversion);
        appObject.put("maintable", maintable);
        appObject.put("views", views);
        return appObject;
    }
}
