package objectregister;

import common.YosException;
import common.data.InsertSQL;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_language implements YosObject {
    @Override
    public String table_comment() {
        return "语言注册表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("languageid", "数据ID");
    }

    @Override
    public void DataInit() throws YosException {
        DBConnect dbConnect = new DBConnect();
        if (dbConnect.runSqlQuery("select * from sys_language").isEmpty()) {
            {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_language");
                insertSQL.setValue("languagecode", "ZH");
                insertSQL.setValue("languagename", "简体中文");
                insertSQL.setValue("isused", true);
                insertSQL.insert();
            }
            {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_language");
                insertSQL.setValue("languagecode", "EN");
                insertSQL.setValue("languagename", "English");
                insertSQL.setValue("isused", true);
                insertSQL.insert();
            }
            {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_language");
                insertSQL.setValue("languagecode", "RU");
                insertSQL.setValue("languagename", "Русский язык");
                insertSQL.setValue("isused", false);
                insertSQL.insert();
            }
        }
        if (dbConnect.runSqlQuery("select * from sys_optiontype where typename='language'").isEmpty()) {
            ArrayList<String> sqlist = new ArrayList<>();

            InsertSQL optiontypeInsert = SQLFactory.createInsertSQL(dbConnect, "sys_optiontype");
            optiontypeInsert.setValue("typename", "language");
            optiontypeInsert.setValue("issql", true);
            optiontypeInsert.setValue("issubvaluemag", false);
            optiontypeInsert.setValue("remarks", "系统语言选择");
            optiontypeInsert.setValue("issystem", true);
            sqlist.add(optiontypeInsert.getSQL());

            InsertSQL optiontypemxInsert = SQLFactory.createInsertSQL(dbConnect, "sys_optiontypemx");
            optiontypemxInsert.setValue("optiontypeid", optiontypeInsert.getUniqueid());
            optiontypemxInsert.setValue("value", "select languagecode,languagename from sys_language where isused=1");
            optiontypemxInsert.setValue("isused", true);
            optiontypemxInsert.setValue("issystem", true);
            sqlist.add(optiontypemxInsert.getSQL());

            dbConnect.runSqlUpdate(sqlist);
        }
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("languagecode", "语言代码", 50));
        list.add(new VarcharCol("languagename", "语言描述", 500));
        list.add(new SmallIntCol("isused", "是否启用", 1));
        return list;
    }
}
