package restcontroller.sysmanage.develop.payorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

public class payorder extends Controller {
    /**
     * 构造函数
     *
     * @param content
     */
    public payorder(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "付费订单列表")
    public String list() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.orderno like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t3.enterprisename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("startdate") && !"".equals(whereObject.getString("startdate"))) {
                where.append(" and(");
                where.append("t1.createdate >='").append(whereObject.getString("startdate")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("enddate") && !"".equals(whereObject.getString("enddate"))) {
                where.append(" and(");
                where.append("t1.createdate <='").append(whereObject.getString("enddate")).append(" 23:59:59' ");
                where.append(")");
            }
            if (whereObject.containsKey("ispaid") && !"".equals(whereObject.getString("ispaid"))) {
                where.append(" and(");
                where.append("t1.ispaid ='").append(whereObject.getString("ispaid")).append("' ");
                where.append(")");
            }
        }
        if (sys_enterpriseid > 0) {
            where.append(" and t1.createuserid in (SELECT userid from sys_enterprise_hr WHERE sys_enterpriseid=" + sys_enterpriseid + " and  siteid='" + siteid + "')");
        }

        SQLFactory sqlFactory = new SQLFactory(this, "付费订单_列表", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "详细")
    public String detail() throws YosException {
        Long sys_payorderid = content.getLongValue("sys_payorderid");
        SQLFactory sqlFactory = new SQLFactory(this, "付费订单_详细");
        sqlFactory.addParameter("sys_payorderid", sys_payorderid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            String systemappids = row.getString("systemappids");
            JSONArray array = JSONArray.parseArray(systemappids);
            if (array != null) {
                row.put("systemappids", array);
                sqlFactory = new SQLFactory(this, "查询系统模块列表");
                sqlFactory.addParameter_in("systemappid", array.toArray());
                String sql = sqlFactory.getSQL();
                Rows systemappRows = dbConnect.runSqlQuery(sql);
                row.put("systemapp", systemappRows);
            } else {
                row.put("systemapp", new Rows());
            }

        }
        Row detailRow = rows.isNotEmpty() ? rows.get(0) : new Row();
        return getSucReturnObject().setData(detailRow).toString();
    }

    @API(title = "详细账号列表")
    public String detail_userlist() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t2.accountno like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        Long sys_payorderid = content.getLongValue("sys_payorderid");
        SQLFactory sqlFactory = new SQLFactory(this, "付费订单_详细账号列表", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("sys_payorderid", sys_payorderid);
        sqlFactory.addParameter_SQL("where", where);
        String sql = sqlFactory.getSQL();
        Rows rows = dbConnect.runSqlQuery(sql);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "绑定商户退款单号")
    public String bindOutRefundNo() throws YosException {
        String out_refund_no = content.getString("out_refund_no");
        Long sys_payorderid = content.getLongValue("sys_payorderid");
        Rows rows = dbConnect.runSqlQuery("SELECT * from sys_payorder WHERE sys_payorderid='" + sys_payorderid + "' and siteid='" + siteid + "'");
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("订单不存在").toString();
        }
        if (rows.get(0).getLong("ispaid") != 1) {
            return getErrReturnObject().setErrMsg("订单状态不是已付费").toString();
        }
        String orderno = rows.get(0).getString("orderno");

        JSONObject jsonObject = WeChatHelper.refund(out_refund_no);
        if (jsonObject == null) {
            return getErrReturnObject().setErrMsg("退款单号不存在").toString();
        }

        if (jsonObject.getString("status").equals("SUCCESS") && jsonObject.getString("out_trade_no").contains(orderno)) {
            dbConnect.runSqlUpdate(" UPDATE sys_payorder SET out_refund_no='" + out_refund_no + "',ispaid=4  WHERE sys_payorderid=" + sys_payorderid + " and siteid='" + siteid + "'");
        } else {
            return getErrReturnObject().setErrMsg("绑定失败，请检查单号是否正确").toString();
        }
        return getSucReturnObject().toString();
    }
}
