package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_mqttlogintrack implements YosObject {
    @Override
    public String table_comment() {
        return "MQTT登陆状态跟踪表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_mqttlogintrackid", "MQTT登陆状态跟踪ID");
    }

    @Override
    public void DataInit() throws YosException {

    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("clientid", "客户id", 500));
        list.add(new VarcharCol("connectionid", "连接id", 500));
        list.add(new VarcharCol("action", "动作", 50));
        list.add(new DateTimeCol("createdate", "动作时间"));
        return list;
    }
}
