/**
 *
 */
package common.data;

import com.alibaba.fastjson.JSONObject;
import com.mchange.v2.util.PropertiesUtils;
import common.Controller;
import common.YosException;
import common.data.db.DBConnect;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

/**
 *
 * @author SJW
 *
 */
public class SQLFactory {
    /**
     * SQL模板缓存map,第一次读取模板文件后将内容存在此Map中。减少文件的读取次数，如模板调整需重启服务生效。
     */
    private static HashMap<String, String> modelmap = new HashMap<String, String>();

    /**
     * 需要加载的SQL模板名称
     */
    private String SQLMODELNAME;
    private String SQLMODELNAME_KEY;
    private Object o = null;
    private SQLProcess sqlProcess = null;
    /**
     * SQL参数Map
     */
    HashMap<String, Object> parametermap;
    /**
     * SQL参数Map
     */
    HashMap<String, String[]> parametermap_array;
    /**
     * SQL参数Map
     */
    HashMap<String, ArrayList> parametermap_arrayList;
    /**
     * SQL参数Map
     */
    HashMap<String, String> parametermap_SQL;
    HashMap<String, ArrayList> parametermap_SQL_arrayList;

    public boolean queryforpage = false;
    int pageSize = 0;
    int pageNumber = 0;
    int rowindex = 0;
    String orderfields = "";
    String sqlstr;

    /**
     * 构造函数
     *
     * @param SQLMODELNAME 需要加载的SQL模板名称,该模版必须在公共模版文件夹内,如果文本以"sql:"开头表示为SQL语句。
     */
    public SQLFactory(String SQLMODELNAME) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
            this.SQLMODELNAME_KEY = this.SQLMODELNAME;
        }
    }

    public SQLFactory(Object o, String SQLMODELNAME) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    @Deprecated
    public SQLFactory(String SQLMODELNAME, int rowindex) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
            this.SQLMODELNAME_KEY = this.SQLMODELNAME;
        }
        this.rowindex = rowindex;
    }


    @Deprecated
    public SQLFactory(String SQLMODELNAME, int rowindex, String orderfields) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
            this.SQLMODELNAME_KEY = this.SQLMODELNAME;
        }
        this.rowindex = rowindex;
        if (orderfields == null || orderfields.equals("")) {
            this.orderfields = "''";
        } else {
            this.orderfields = orderfields;
        }
    }

    @Deprecated
    public SQLFactory(Object o, String SQLMODELNAME, int rowindex) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.rowindex = rowindex;
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    @Deprecated
    public SQLFactory(String SQLMODELNAME, int pageSize, int pageNumber, String orderfields) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
            this.SQLMODELNAME_KEY = this.SQLMODELNAME;
        }
        queryforpage = true;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        if (orderfields == null || orderfields.equals("")) {
            this.orderfields = "''";
        } else {
            this.orderfields = orderfields;
        }
    }

    @Deprecated
    public SQLFactory(Object o, String SQLMODELNAME, int pageSize, int pageNumber, String orderfields) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        queryforpage = true;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        if (orderfields == null || orderfields.equals("")) {
            this.orderfields = "''";
        } else {
            this.orderfields = orderfields;
        }
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    @Deprecated
    public SQLFactory(Object o, String SQLMODELNAME, int rowindex, String orderfields) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.rowindex = rowindex;
        if (orderfields == null || orderfields.equals("")) {
            this.orderfields = "''";
        } else {
            this.orderfields = orderfields;
        }
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    /**
     * 获取SQL模板，第一次获取时判断是否存在于SQL模板缓存modelmap中，
     * 如存
     * 在，则直接取出，如不存在，则读取SQL模板文件，并将其存入modelmap
     *
     * @return
     */
    private String getSQLModel() throws YosException {
        if (SQLMODELNAME.equals("SQL")) {
            return sqlstr;
        }
        if (!SQLMODELNAME.contains(".sql") && !SQLMODELNAME.contains(".SQL")) {
            SQLMODELNAME = SQLMODELNAME + ".sql";
        }
        StringBuffer SQL = new StringBuffer();
        if (!modelmap.containsKey(SQLMODELNAME_KEY)) {
            InputStream is = null;
            InputStreamReader isr = null;
            try {
                if (o != null) {
                    is = o.getClass().getResourceAsStream(SQLMODELNAME);
                } else {
                    is = PropertiesUtils.class.getClassLoader().getResourceAsStream(SQLMODELNAME);
                }
                isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                char[] ch = new char[2048];
                int byteRead = 0;
                while ((byteRead = isr.read(ch)) != -1) {
                    String str = new String(ch, 0, byteRead);
                    SQL.append(str);
                }
            } catch (IOException e) {
                e.printStackTrace();
                throw new YosException(SQLMODELNAME + "读取失败");
            } finally {
                try {
                    isr.close();
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new YosException(e.getMessage());
                }
            }
            /**
             * 将示例代码去除
             */
            if (SQL.toString().contains("--demo_begin")) {
                SQL = SQL.replace(SQL.indexOf("--demo_begin"), SQL.lastIndexOf("--demo_end") + "--demo_end".length(),
                        "");
            }
            if (!"".equals(SQL.toString().trim())) {

                modelmap.put(SQLMODELNAME_KEY, SQL.toString().trim());
            }
        }
        return modelmap.get(SQLMODELNAME_KEY);
    }

    /**
     * 为SQL实例添加文本类型参数值
     *
     * @param key
     * @param value
     */
    public void addParameter(String key, Object value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, value);
    }

    /**
     * 为SQL实例添加文本类型参数值
     *
     * @param key
     * @param value
     */
    public void addParameter(String key, StringBuffer value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, value.toString());
    }

    /**
     * 为SQL实例添加文本类型的参数值，传入数组将自动转成 in语句的后续参数如('1','2','3')
     *
     * @param key
     * @param value
     */
    public void addParameter_in(String key, String[] value) {
        if (this.parametermap_array == null) {
            this.parametermap_array = new HashMap<>();
        }
        this.parametermap_array.put(key, value);
    }

    /**
     * 为SQL实例添加文本类型的参数值，传入数组将自动转成 in语句的后续参数如('1')
     *
     * @param key
     * @param value
     */
    public void addParameter_in(String key, String value) {
        addParameter_in(key, new String[]{value});
    }

    /**
     * 为SQL实例添加文本类型的参数值，传入数组将自动转成 in语句的后续参数如('1')
     *
     * @param key
     * @param value
     */
    public void addParameter_in(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList) value;
            ArrayList<String> newlist = new ArrayList<>();
            for (Object o : list) {
                newlist.add(o.toString());
            }
            addParameter_in(key, newlist);
        } else if (value.getClass().isArray()) {
            ArrayList<String> newlist = new ArrayList<>();
            Object[] Objectarray = (Object[]) value;
            for (Object object : Objectarray) {
                newlist.add(object.toString());
            }
            addParameter_in(key, newlist);
        } else {
            addParameter_in(key, String.valueOf(value));
        }
    }

    /**
     * 为SQL实例添加文本类型的参数值，传入数组将自动转成 in语句的后续参数如('1','2','3')
     *
     * @param key
     * @param value
     */
    public void addParameter_in(String key, ArrayList value) {
        if (this.parametermap_arrayList == null) {
            this.parametermap_arrayList = new HashMap<>();
        }
        this.parametermap_arrayList.put(key, value);
    }

    /**
     * 为SQL实例添加参数值，传入值将直拼接在sql中，成为sql语句的一部分而非参数
     *
     * @param key
     * @param value
     */
    public void addParameter_SQL(String key, String value) {
        if (this.parametermap_SQL == null) {
            this.parametermap_SQL = new HashMap<>();
        }
        this.parametermap_SQL.put(key, value);
    }

    /**
     * 为SQL实例添加参数值，传入值将直拼接在sql中，成为sql语句的一部分而非参数
     *
     * @param key
     * @param value
     */
    public void addParameter_SQL(String key, StringBuffer value) {
        addParameter_SQL(key, value.toString());
    }


    public void addParameter_SQL_in(String key, ArrayList value) {
        if (this.parametermap_SQL_arrayList == null) {
            this.parametermap_SQL_arrayList = new HashMap<>();
        }
        this.parametermap_SQL_arrayList.put(key, value);
    }

    /**
     * 为SQL实例添加int类型的参数值，
     *
     * @param key
     * @param value
     */
    public void addParameter(String key, boolean value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap<>();
        }
        this.parametermap.put(key, value ? 1 : 0);
    }


    private String getSQLBase(boolean withroledatalimit) throws YosException {
        String str = getSQLModel();
        if (this.parametermap != null) {
            for (String key : this.parametermap.keySet()) {
                String sqlkey = "$" + key + "$";
                Object value = this.parametermap.get(key);
                if (value == null || "null".equalsIgnoreCase(value.toString())) {
                    str = str.replace(sqlkey, "NULL");
                } else {
                    str = str.replace(sqlkey, "'" + value + "'");
                }
            }
        }
        if (this.parametermap_array != null) {
            for (String key : this.parametermap_array.keySet()) {
                String sqlkey = "$" + key + "$";
                String[] values = this.parametermap_array.get(key);
                if (values == null || values.length == 0) {
                    str = str.replace(sqlkey, "('')");
                } else {
                    StringBuilder instr = new StringBuilder();
                    for (String value : values) {
                        if (instr.toString().equals("")) {
                            if (String.valueOf(value).equalsIgnoreCase("null")) {
                                instr = new StringBuilder("NULL");
                            } else {
                                instr = new StringBuilder("'" + value + "'");
                            }
                        } else {
                            if (String.valueOf(value).equalsIgnoreCase("null")) {
                                instr.append(",NULL");
                            } else {
                                instr.append(",'").append(value).append("'");
                            }
                        }
                    }
                    str = str.replace(sqlkey, "(" + instr + ")");
                }
            }
        }
        if (this.parametermap_arrayList != null) {
            for (String key : this.parametermap_arrayList.keySet()) {
                String sqlkey = "$" + key + "$";
                ArrayList values = this.parametermap_arrayList.get(key);
                if (values == null || values.size() == 0) {
                    str = str.replace(sqlkey, "('')");
                } else {
                    StringBuilder instr = new StringBuilder();
                    for (Object value : values) {
                        if (instr.toString().equals("")) {
                            if (String.valueOf(value).equalsIgnoreCase("null")) {
                                instr = new StringBuilder("NULL");
                            } else {
                                instr = new StringBuilder("'" + value + "'");
                            }
                        } else {
                            if (String.valueOf(value).equalsIgnoreCase("null")) {
                                instr.append(",NULL");
                            } else {
                                instr.append(",'").append(value).append("'");
                            }
                        }
                    }
                    str = str.replace(sqlkey, "(" + instr + ")");
                }
            }
        }
        if (this.parametermap_SQL != null) {
            for (String key : this.parametermap_SQL.keySet()) {
                String sqlkey = "$" + key + "$";
                String value = this.parametermap_SQL.get(key);
                str = str.replace(sqlkey, value);
            }
        }
        if (this.parametermap_SQL_arrayList != null) {
            for (String key : this.parametermap_SQL_arrayList.keySet()) {
                String sqlkey = "$" + key + "$";
                ArrayList values = this.parametermap_SQL_arrayList.get(key);
                if (values == null || values.size() == 0) {
                    str = str.replace(sqlkey, "()");
                } else {
                    StringBuilder instr = new StringBuilder();
                    for (Object value : values) {
                        if (instr.toString().equals("")) {
                            instr = new StringBuilder("" + value);
                        } else {
                            instr.append(",").append(value);
                        }
                    }
                    str = str.replace(sqlkey, "(" + instr + ")");
                }
            }
        }

        if (queryforpage && o instanceof Controller) {
            Controller controller = (Controller) o;
            long tableid = controller.content.getLongValue("tableid");
            boolean istablefilter = str.contains("$tablefilter$") && tableid > 0;
            boolean issimplesort = controller.content.containsKey("simplesort") && tableid > 0;
            if ((istablefilter || issimplesort)) {
                if (!FieldsMetaMap.containsKey(SQLMODELNAME_KEY)) {
                    FieldsMetaMap.put(SQLMODELNAME_KEY, controller.dbConnect.runSqlQuery(str.replace("$tablefilter$", " 1=2 ")).getFieldMetaMap());
                }
            }
            StringBuffer filtersql = new StringBuffer(" 1=1 ");
            if (istablefilter) {
                if (controller.content.containsKey("where") && controller.content.getJSONObject("where").containsKey("tablefilter")) {
                    JSONObject tablefilter = controller.content.getJSONObject("where").getJSONObject("tablefilter");

                    //过滤字段名称
                    for (String columnname : tablefilter.keySet()) {
                        String filtervalue = tablefilter.getStringValue(columnname);//过滤值
                        if (!filtervalue.equals("") && FieldsMetaMap.get(SQLMODELNAME_KEY).containsKey(columnname)) {
                            String table_alias = FieldsMetaMap.get(SQLMODELNAME_KEY).get(columnname).getTable_alias();//表别名
                            Rows tablecolRows = controller.dbConnect.runSqlQuery("select distinct filter from sys_systemapp_tablecols where filter in (1,2) and tableid=" + tableid + " and columnname='" + columnname + "'");
                            if (!table_alias.equals("") && tablecolRows.isNotEmpty()) {
                                Class fieldclazztype = FieldsMetaMap.get(SQLMODELNAME_KEY).get(columnname).getFieldtype();//字段类型
                                int filter = tablecolRows.get(0).getInteger("filter");//1 精确搜索 2 模糊搜索
                                if (fieldclazztype == Integer.class || fieldclazztype == Long.class || fieldclazztype == Float.class || fieldclazztype == Double.class || fieldclazztype == Date.class) {
                                    if (filter == 1) {
                                        filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("='").append(filtervalue).append("'");
                                    } else if (filter == 2) {
                                        if (filtervalue.startsWith(">=")) {
                                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append(">='").append(filtervalue.replaceFirst(">=", "")).append("'");
                                        } else if (filtervalue.startsWith("<=")) {
                                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("<='").append(filtervalue.replaceFirst("<=", "")).append("'");
                                        } else if (filtervalue.startsWith(">")) {
                                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append(">'").append(filtervalue.replaceFirst(">", "")).append("'");
                                        } else if (filtervalue.startsWith("<")) {
                                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("<'").append(filtervalue.replaceFirst("<", "")).append("'");
                                        } else {
                                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("='").append(filtervalue.replaceFirst("=", "")).append("'");
                                        }
                                    }
                                } else {
                                    if (filter == 1) {
                                        filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("='").append(filtervalue).append("'");
                                    } else if (filter == 2) {
                                        filtersql.append(" and ").append(table_alias).append(".").append(columnname).append(" like '%").append(filtervalue).append("%'");
                                    }
                                }
                            }
                        }
                    }
                }
            }
            str = str.replace("$tablefilter$", " ( " + filtersql + " ) ");//如果where参数没有被替换，则默认替换成1=1
            if (issimplesort) {
                JSONObject simplesortObject = controller.content.getJSONObject("simplesort");
                if (!simplesortObject.isEmpty()) {
                    for (String fieldname : simplesortObject.keySet()) {
                        if (FieldsMetaMap.get(SQLMODELNAME_KEY).containsKey(fieldname)) {
                            boolean isasc = simplesortObject.getBooleanValue(fieldname);//是否正序
                            String table_alias = FieldsMetaMap.get(SQLMODELNAME_KEY).get(fieldname).getTable_alias();//表别名
                            Rows tablecolRows = controller.dbConnect.runSqlQuery("select sortable from sys_systemapp_tablecols where sortable=1 and tableid=" + tableid + " and columnname='" + fieldname + "'");
                            if (!table_alias.equals("") && tablecolRows.isNotEmpty()) {
                                this.orderfields = table_alias + "." + fieldname + (isasc ? " asc" : " desc");
                            }
                        }
                    }
                }
            }
        }
        if (withroledatalimit) {
            try {
                if (this.o != null && this.o.getClass().getSuperclass().getName().equals("common.Controller")) {
//                    Class clz = Class.forName("common.data.SQLProcess");
//                    Constructor cla = clz.getDeclaredConstructor(Object.class, String.class, String.class);
//                    Object obj = cla.newInstance(o, this.SQLMODELNAME_KEY == null ? "" : this.SQLMODELNAME_KEY, str);
//                    Method method = obj.getClass().getDeclaredMethod("getSQL");
//                    str = (String) method.invoke(obj);
                    if (sqlProcess == null) {
                        sqlProcess = new SQLProcess(o, this.SQLMODELNAME_KEY == null ? "" : this.SQLMODELNAME_KEY, str);
                        str = sqlProcess.getSQL();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    //SQLMODELNAME_KEY,<fieldname,FieldMeta>
    private static HashMap<String, HashMap<String, FieldMeta>> FieldsMetaMap = new HashMap<>();


    /**
     * 将当前对象转换成有效的SQL语句
     *
     */
    public String getSQL() throws YosException {
        return getSQL(true);
    }

    public String getSQL(boolean withroledatalimit) throws YosException {
        String str = getSQLBase(withroledatalimit);
        if (queryforpage) {
            str = str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderfields + " )rowindex,");
            str = str + " )select * from p2dbconnectstring t1 inner join (select count(0)total,CEILING(count(0)/(" + pageSize + "*1.0)) pageTotal from p2dbconnectstring) t2 on 1=1 where rowindex>(" + pageNumber + "-1)*" + pageSize + " and rowindex<=" + pageNumber + "*" + pageSize;
        } else if (rowindex > 0) {
            if (orderfields.equals("")) {
                orderfields = "1=1";
            }
            str = str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderfields + " )rowindex,");
            str = str + " )select * from p2dbconnectstring t1 inner join (select count(0)total from p2dbconnectstring) t2 on 1=1 where rowindex=" + rowindex;
        }
        return str;
    }

    public String getSQL(DBConnect dbConnect) throws YosException {
        return getSQL(dbConnect,true);
    }

    public String getSQL(DBConnect dbConnect, boolean withroledatalimit) throws YosException {
        String str = getSQLBase(withroledatalimit);
        if (queryforpage) {
            if (dbConnect.getDBProduct().equals("MySQL")) {
                str = str.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                str = str + " order by " + orderfields + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else {
                str = str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderfields + " )rowindex,");
                str = str + " )select * from p2dbconnectstring t1 inner join (select count(0)total,CEILING(count(0)/(" + pageSize + "*1.0)) pageTotal from p2dbconnectstring) t2 on 1=1 where rowindex>(" + pageNumber + "-1)*" + pageSize + " and rowindex<=" + pageNumber + "*" + pageSize;
            }
        } else if (rowindex > 0) {
            if (orderfields.equals("")) {
                orderfields = "1=1";
            }
            str = str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderfields + " )rowindex,");
            str = str + " )select * from p2dbconnectstring t1 inner join (select count(0)total from p2dbconnectstring) t2 on 1=1 where rowindex=" + rowindex;
        }
        return str;
    }

    public Rows runSqlQuery(DBConnect dbConnect) throws YosException {
        return dbConnect.runSqlQuery(this);
    }

    public void runSqlUpdate(DBConnect dbConnect) throws YosException {
        dbConnect.runSqlUpdate(this);
    }

    public Object getOjbect() {
        return o;
    }


    public static InsertSQL createInsertSQL(DBConnect dbConnect, String tablename) throws YosException {
        return new InsertSQL(dbConnect, tablename);
    }

    public static InsertSQL createInsertSQL(Controller controller, String tablename) throws YosException {
        return new InsertSQL(controller, tablename);
    }

    public static UpdateSQL createUpdateSQL(DBConnect dbConnect, String tablename) throws YosException {
        return new UpdateSQL(dbConnect, tablename);
    }

    public static UpdateSQL createUpdateSQL(Controller controller, String tablename) throws YosException {
        return new UpdateSQL(controller, tablename);
    }


    public static DeleteSQL createDeleteSQL(DBConnect dbConnect, String tablename) throws YosException {
        return new DeleteSQL(dbConnect, tablename);
    }

    public static DeleteSQL createDeleteSQL(Controller controller, String tablename) throws YosException {
        return new DeleteSQL(controller, tablename);
    }

    public static QuerySQL createQuerySQL(DBConnect dbConnect, String tablename, String... fieldnames) throws YosException {
        return new QuerySQL(dbConnect, tablename, fieldnames);
    }

    public static QuerySQL createQuerySQL(Controller controller, String tablename, String... fieldnames) throws YosException {
        return new QuerySQL(controller, tablename, fieldnames);
    }

}
