package common.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 接口注解，接口方法中带有此注解时，在获取方法返回值时会将返回值进行缓存处理，下次请求时如果请求体一样，则会从缓存中获取数据
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface CACHEING {
    /**
     * 缓存有效时间
     *
     * @return
     */
    int life() default 2;//缓存有效时间;
}
