package common;

import common.annotation.Param;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class DataFunction {
    public Controller controller;
    public DBConnect dbConnect;
    public String functionname;
    public String type;
    public String datakey;
    private String sqlstr;
    private boolean queryforpage;
    private int pageNumber = 1;
    private int pageSize = 20;
    public String ownertable = "";
    public Long ownerid = 0L;

    private HashMap<String, Field> classfieldMap = new HashMap<>();


    private HashMap<String, Object> sys_parametermap = new HashMap<>();
    private HashMap<String, Object> parametermap = new HashMap<>();
    private HashMap<String, String[]> parametermap_array = new HashMap<>();

    public static DataFunction get(Controller controller, String functionname, String ownertable, Long ownerid) throws YosException {
        DataFunction dataFunction = get(controller, functionname);
        dataFunction.ownertable = ownertable;
        dataFunction.ownerid = ownerid;
        return dataFunction;
    }

    public static DataFunction get(Controller controller, String functionname) throws YosException {
        DataFunction dataFunction = get(controller.dbConnect, functionname);
        dataFunction.controller = controller;
        return dataFunction;
    }

    public static DataFunction get(DBConnect dbConnect, String functionname, String ownertable, Long ownerid) throws YosException {
        DataFunction dataFunction = get(dbConnect, functionname);
        dataFunction.ownertable = ownertable;
        dataFunction.ownerid = ownerid;
        return dataFunction;
    }


    public static DataFunction get(DBConnect dbConnect, String functionname) throws YosException {
        DataFunction dataFunction = null;
        QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "sys_datafunction");
        querySQL.setWhere("functionname", functionname);
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            String classname = rows.get(0).getString("classname");
            try {
                Class<?> clz = null;
                if (classname.equals("")) {
                    clz = Class.forName("common.DataFunction");
                } else {
                    clz = Class.forName("function." + classname);
                }
                Constructor<?> cla = clz.getDeclaredConstructor();
                dataFunction = (DataFunction) cla.newInstance();
                dataFunction.getClass().getMethod("init", DBConnect.class, Row.class).invoke(dataFunction, dbConnect, rows.get(0));
            } catch (Exception e) {
                e.printStackTrace();
                throw new YosException(e.getMessage());
            }
        }
        return dataFunction;
    }

    public void init(Controller controller, Row sys_datafunctionRow) throws YosException {
        this.controller = controller;
        init(controller.dbConnect, sys_datafunctionRow);
    }

    public void init(DBConnect dbConnect, Row sys_datafunctionRow) throws YosException {
        /*
         *获取当前对象参数信息
         */
        Field[] fields = this.getClass().getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(Param.class)) {
                classfieldMap.put(field.getName(), field);
            }
        }
        this.dbConnect = dbConnect;
        this.functionname = sys_datafunctionRow.getString("functionname");
        this.type = sys_datafunctionRow.getString("type");
        this.datakey = sys_datafunctionRow.getString("datakey");
        this.sqlstr = sys_datafunctionRow.getString("sqlstr");
        this.queryforpage = sys_datafunctionRow.getBoolean("queryforpage");
        if (!sys_datafunctionRow.getBoolean("isused")) {
            dbConnect.runSqlUpdate("update sys_datafunction set isused=1 where functionname='" + functionname + "'");
        }
        Rows param_rows = dbConnect.runSqlQuery("select param,value from sys_datafunction_params where sys_datafunctionid=" + sys_datafunctionRow.getLong("sys_datafunctionid"));
        for (Row param_row : param_rows) {
            String key = param_row.getString("param");
            String value = param_row.getString("value");
            sys_parametermap.put(key, value);
            parametermap.put(key, value);
            try {
                if (classfieldMap.containsKey(key)) {
                    Field field = classfieldMap.get(key);
                    field.setAccessible(true);

                    switch (field.getType().getSimpleName()) {
                        case "String": {
                            field.set(this, value);
                            break;
                        }
                        case "Integer": {
                            field.set(this, Integer.parseInt(value));
                            break;
                        }
                        case "Long": {
                            field.set(this, Long.parseLong(value));
                            break;
                        }
                        case "Double": {
                            field.set(this, Double.parseDouble(value));
                            break;
                        }
                        case "Boolean": {
                            field.set(this, value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("Y"));
                            break;
                        }
                        default:
                            break;
                    }
                }
            } catch (Exception e) {

            }
        }
    }


    public int action() throws YosException {
        if (!sqlstr.equals("")) {
            return dbConnect.runSqlUpdate(getSQL());
        }
        return 0;
    }

    public String getSQL() throws YosException {
        if (!sqlstr.equals("")) {
            for (String parameter : parametermap.keySet()) {
                String value = String.valueOf(parametermap.get(parameter));
                String key = "$" + parameter + "$";
                if (value == null || "null".equalsIgnoreCase(value)) {
                    sqlstr = sqlstr.replace(key, "NULL");
                } else {
                    sqlstr = sqlstr.replace(key, "'" + value + "'");
                }
            }
            for (String parameter : parametermap_array.keySet()) {
                String sqlkey = "$" + parameter + "$";
                String[] values = this.parametermap_array.get(parameter);
                if (values == null || values.length == 0) {
                    sqlstr = sqlstr.replace(sqlkey, "('')");
                } else {
                    StringBuilder instr = new StringBuilder();
                    for (String value : values) {
                        if (instr.toString().equals("")) {
                            if (String.valueOf(value).equalsIgnoreCase("null")) {
                                instr = new StringBuilder("NULL");
                            } else {
                                instr = new StringBuilder("'" + value + "'");
                            }
                        } else {
                            if (String.valueOf(value).equalsIgnoreCase("null")) {
                                instr.append(",NULL");
                            } else {
                                instr.append(",'").append(value).append("'");
                            }
                        }
                    }
                    sqlstr = sqlstr.replace(sqlkey, "(" + instr + ")");
                }
            }

            if (controller != null) {
                sqlstr = sqlstr.replaceAll("(?i):sys_enterpriseid", "'" + controller.sys_enterpriseid + "'");
                sqlstr = sqlstr.replaceAll("(?i):userid", "'" + controller.userid + "'");
                sqlstr = sqlstr.replaceAll("(?i):hrid", "'" + controller.hrid + "'");
                sqlstr = sqlstr.replaceAll("(?i):departmentid", "'" + controller.departmentid + "'");
                sqlstr = sqlstr.replaceAll("(?i):siteid", "'" + controller.siteid + "'");
            }

            if (datakey.equals("") || datakey.equalsIgnoreCase("default")) {
                if (type.equals("query") && queryforpage) {
                    sqlstr = sqlstr.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                    sqlstr = sqlstr + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;
                }
            } else if (datakey.equalsIgnoreCase("sqliteCache")) {

            } else if (type.equals("query") && queryforpage) {
                sqlstr = sqlstr.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                sqlstr = sqlstr + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;
            }
        }
        return sqlstr;
    }

    public Rows getList() throws YosException {
        if (!sqlstr.equals("")) {
            return dbConnect.runSqlQuery(getSQL());
        } else {
            return new Rows();
        }
    }

    /**
     * @param key
     * @param value
     */
    public void addParameter(String key, Object value) {
        //如果数据函数已经设置默认参数，则不再接收参数传入
        if (sys_parametermap.getOrDefault(key, "").equals("")) {
            if (value instanceof ArrayList) {
                ArrayList list = (ArrayList) value;
                String[] values = new String[list.size()];
                for (int i = 0; i < values.length; i++) {
                    values[i] = list.get(i).toString();
                }
                parametermap_array.put(key, values);
            } else if (value.getClass().isArray()) {
                Object[] Objectarray = (Object[]) value;
                String[] values = new String[Objectarray.length];
                for (int i = 0; i < values.length; i++) {
                    values[i] = Objectarray[i].toString();
                }
                parametermap_array.put(key, values);
            } else {
                parametermap.put(key, value);
            }
            try {
                if (classfieldMap.containsKey(key)) {
                    Field field = classfieldMap.get(key);
                    field.setAccessible(true);

                    switch (field.getType().getSimpleName()) {
                        case "String": {
                            field.set(this, value.toString());
                            break;
                        }
                        case "Integer": {
                            field.set(this, Integer.parseInt(value.toString()));
                            break;
                        }
                        case "Long": {
                            field.set(this, Long.parseLong(value.toString()));
                            break;
                        }
                        case "Double": {
                            field.set(this, Double.parseDouble(value.toString()));
                            break;
                        }
                        case "Boolean": {
                            field.set(this, value.toString().equalsIgnoreCase("true") || value.toString().equals("1") || value.toString().equalsIgnoreCase("Y"));
                            break;
                        }
                        default:
                            break;
                    }
                }
            } catch (Exception e) {

            }
        }
    }

    public Object getParamValue(String param) {
        if (parametermap.containsKey(param)) {
            return parametermap.get(param);
        }
        if (parametermap_array.containsKey(param)) {
            return parametermap_array.get(param);
        }
        return null;
    }
}
