package beans.workreport;

import beans.department.Department;
import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

public class WorkReport {
    /**
     * 工作汇报内容查询
     *
     * @param controller
     * @param sys_workreportpresetid 预设工作id
     * @return 工作明细
     * @throws YosException
     */
    public static Row getWorkReportContent(Controller controller, long sys_workreportpresetid) throws YosException {
        Rows rows = controller.dbConnect.runSqlQuery("select title,content,issql,editable from sys_workreportpreset where sys_workreportpresetid='" + sys_workreportpresetid + "'");
        if (rows.isNotEmpty()) {
            Row row = rows.get(0);
            if (row.getBoolean("issql")) {
                String sqlstr = row.getString("content");

                if (sqlstr.contains(":hrid")) {
                    sqlstr = sqlstr.replace(":hrid", String.valueOf(controller.hrid));
                }
                if (sqlstr.contains(":userid")) {
                    sqlstr = sqlstr.replace(":userid", String.valueOf(controller.userid));
                }
                if (sqlstr.contains(":sys_enterpriseid")) {
                    sqlstr = sqlstr.replace(":sys_enterpriseid", String.valueOf(controller.sys_enterpriseid));
                }
                if (sqlstr.contains(":departmentid")) {
                    sqlstr = sqlstr.replace(":departmentid", String.valueOf(controller.departmentid));
                }
                if (sqlstr.contains(":subuserids")) {
                    ArrayList<Long> sublist = User.getSubUserIds(controller);
                    sublist.add(controller.userid);
                    sqlstr = sqlstr.replace(":subuserids", sublist.toString().replace("[", "(").replace("]", ")"));
                }
                if (sqlstr.contains(":subhrids")) {
                    ArrayList<Long> sublist = User.getSubHrIds(controller);
                    sublist.add(controller.hrid);
                    sqlstr = sqlstr.replace(":subhrids", sublist.toString().replace("[", "(").replace("]", ")"));
                }
                if (sqlstr.contains(":subsys_enterpriseids")) {
                    ArrayList<Long> sublist = User.getSubEnterpriseids(controller);
                    if (sublist.isEmpty()) {
                        sqlstr = sqlstr.replace(":subsys_enterpriseids", "(null)");
                    } else {
                        sqlstr = sqlstr.replace(":subsys_enterpriseids", sublist.toString().replace("[", "(").replace("]", ")"));
                    }
                }
                if (sqlstr.contains(":subdepartmentids")) {
                    ArrayList<Long> sublist = Department.getSubDepartmentIds(controller);
                    sublist.add(controller.departmentid);
                    sqlstr = sqlstr.replace(":subdepartmentids", sublist.toString().replace("[", "(").replace("]", ")"));
                }
                if (!sqlstr.equals("")) {
                    Rows contentrows = controller.dbConnect.runSqlQuery(sqlstr);
                    row.put("content", contentrows);
                } else {
                    row.put("content", new JSONArray());
                }
            } else {
                JSONArray contentArray = new JSONArray();

                JSONObject contentObject = new JSONObject();
                contentObject.put("rowindex", 1);
                contentObject.put("content", row.getString("content"));

                contentArray.add(contentObject);

                row.put("content", contentArray);
            }
            row.remove("issql");
            return row;
        }
        return new Row();
    }
}
