/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import common.YosException;
import common.data.FieldMeta;
import common.data.Row;
import common.data.RowsMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Rows
extends ArrayList<Row> {
    private static final long serialVersionUID = 1L;
    public long totalRows = 0L;
    public long totalPage = 0L;
    public String listqueryid = "";
    private ArrayList<String> fieldlist;
    private HashMap<String, FieldMeta> fieldMetaMap;
    private HashMap<String, BigDecimal> minValueMap = new HashMap();
    private HashMap<String, BigDecimal> maxValueMap = new HashMap();

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public Row getRow(int index) {
        return this.get(index);
    }

    @Override
    public Row get(int index) {
        if (index + 1 > this.size()) {
            return null;
        }
        return (Row)super.get(index);
    }

    public Row getLastRow() {
        return this.get(this.size() - 1);
    }

    public Rows removeColumn(String ... columns) {
        for (Row row : this) {
            for (String column : columns) {
                row.remove(column);
            }
        }
        return this;
    }

    public JSONArray toJsonArray() {
        return (JSONArray)JSON.toJSON((Object)this);
    }

    public JSONArray toJsonArray(String column) {
        return this.toJsonArray(column, true);
    }

    public JSONArray toJsonArray(String column, boolean isdistinct) {
        ArrayList list = this.toArrayList(column, new ArrayList(), isdistinct);
        return (JSONArray)JSONArray.toJSON(list);
    }

    public String[] toArray(String column) {
        return this.toArrayList(column, true).toArray(new String[0]);
    }

    public String[] toArray(String column, boolean isdistinct) {
        return this.toArrayList(column, isdistinct).toArray(new String[0]);
    }

    public ArrayList<String> toArrayList(String column) {
        return this.toArrayList(column, true);
    }

    public ArrayList<String> toArrayList(String column, boolean isdistinct) {
        ArrayList<String> list = new ArrayList<String>();
        for (Row row : this) {
            list.add(row.getString(column));
        }
        return isdistinct ? new ArrayList<String>(new LinkedHashSet(list)) : list;
    }

    public <T> T[] toArray(String column, T[] array) {
        return this.toArray(column, array, true);
    }

    public <T> T[] toArray(String column, T[] array, boolean isdistinct) {
        return this.toArrayList(column, new ArrayList(), isdistinct).toArray(array);
    }

    public <T> ArrayList<T> toArrayList(String column, ArrayList<T> list) {
        return this.toArrayList(column, list, true);
    }

    public <T> ArrayList<T> toArrayList(String column, ArrayList<T> list, boolean isdistinct) {
        for (Row row : this) {
            Object value = row.get(column);
            list.add(value);
        }
        return isdistinct ? new ArrayList(new LinkedHashSet(list)) : list;
    }

    public ArrayList<ArrayList<Object>> toListList() {
        ArrayList<ArrayList<Object>> list = new ArrayList<ArrayList<Object>>();
        for (Row row : this) {
            list.add(row.toList(this.getFieldList()));
        }
        return list;
    }

    public RowsMap toRowsMap(String fieldname) {
        RowsMap map = new RowsMap();
        for (Row row : this) {
            String key = row.getString(fieldname);
            Rows subrows = map.getOrDefault(key, new Rows());
            subrows.add(row);
            map.put(key, subrows);
        }
        return map;
    }

    public RowsMap toRowsMap(String[] fieldnames) {
        RowsMap map = new RowsMap();
        for (Row row : this) {
            StringBuilder key = new StringBuilder();
            for (String fieldname : fieldnames) {
                key.append(row.getString(fieldname));
            }
            Rows subrows = map.getOrDefault(key.toString(), new Rows());
            subrows.add(row);
            map.put(key.toString(), subrows);
        }
        return map;
    }

    public String toXml() {
        Document document = DocumentHelper.createDocument();
        if (this.size() > 0) {
            Iterator it = this.get(0).keySet().iterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            Element root = document.addElement("rows");
            for (int i = 0; i < this.size(); ++i) {
                Row row = this.getRow(i);
                Element element = root.addElement("row" + i);
                for (String key : list) {
                    Object value = row.get(key);
                    Element e = element.addElement(key);
                    if (value == null) {
                        e.addText("null");
                        continue;
                    }
                    e.addText(row.get(key).toString());
                }
            }
        }
        return document.asXML();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public void setFieldList(ArrayList<String> fieldlist) {
        this.fieldlist = fieldlist;
    }

    public ArrayList<String> getFieldList() {
        return this.fieldlist;
    }

    public HashMap<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public FieldMeta getFieldMeta(String fieldname) {
        return this.fieldMetaMap.get(fieldname);
    }

    public ArrayList<String> getTableNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FieldMeta fieldMeta : this.fieldMetaMap.values()) {
            if (arrayList.contains(fieldMeta.getTable_name())) continue;
            arrayList.add(fieldMeta.getTable_name());
        }
        return arrayList;
    }

    public void setFieldMetaMap(HashMap<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    @Deprecated
    public void setFieldTypeMap(HashMap<String, Class> keytypemap) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap();
        }
        for (String fieldname : keytypemap.keySet()) {
            FieldMeta fieldMeta = null;
            fieldMeta = this.fieldMetaMap.containsKey(fieldname) ? this.fieldMetaMap.get(fieldname) : new FieldMeta();
            fieldMeta.setFieldtype(keytypemap.get(fieldname));
            this.fieldMetaMap.put(fieldname, fieldMeta);
        }
    }

    public void sortby(final String fieldname) {
        final Class fieldclazztype = this.getFieldMeta(fieldname).getFieldtype();
        this.sort(new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                if (fieldclazztype == Integer.class) {
                    return Integer.compare(o1.getInteger(fieldname), o2.getInteger(fieldname));
                }
                if (fieldclazztype == Long.class) {
                    return Long.compare(o1.getLong(fieldname), o2.getLong(fieldname));
                }
                if (fieldclazztype == Double.class) {
                    return Double.compare(o1.getDouble(fieldname), o2.getDouble(fieldname));
                }
                if (fieldclazztype == Float.class) {
                    return Float.compare(o1.getFloat(fieldname), o2.getFloat(fieldname));
                }
                if (fieldclazztype == Date.class) {
                    return Long.compare(o1.getDate(fieldname).getTime(), o2.getDate(fieldname).getTime());
                }
                return o1.getString(fieldname).compareTo(o2.getString(fieldname));
            }
        });
    }

    public void translate_simple(String languagecode, String ... fieldnames) throws YosException {
        for (Row row : this) {
            row.translate_simple(languagecode, fieldnames);
        }
    }

    public void translate(String languagecode, String idcolumn, String ... fieldnames) throws YosException {
        for (Row row : this) {
            row.translate(languagecode, idcolumn, fieldnames);
        }
    }

    public BigDecimal sum(String column) {
        BigDecimal value = new BigDecimal("0");
        for (Row row : this) {
            if (!row.containsKey(column)) continue;
            value = value.add(row.getBigDecimal(column));
        }
        return value;
    }

    public BigDecimal min(String column) {
        if (this.minValueMap.containsKey(column)) {
            return this.minValueMap.get(column);
        }
        this.caculate(column);
        return this.minValueMap.get(column);
    }

    public BigDecimal max(String column) {
        if (this.maxValueMap.containsKey(column)) {
            return this.maxValueMap.get(column);
        }
        this.caculate(column);
        return this.maxValueMap.get(column);
    }

    private void caculate(String column) {
        BigDecimal minvalue = new BigDecimal("0");
        BigDecimal maxvalue = new BigDecimal("0");
        for (Row row : this) {
            if (!row.containsKey(column)) continue;
            BigDecimal value = row.getBigDecimal(column);
            minvalue = minvalue.min(value);
            maxvalue = maxvalue.max(value);
        }
        this.minValueMap.put(column, minvalue);
        this.maxValueMap.put(column, maxvalue);
    }

    public boolean contains(String fieldname, String value) {
        for (Row row : this) {
            if (!row.getString(fieldname).equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

