/*
 * Decompiled with CFR 0.152.
 */
package service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.ServiceController;
import common.YosException;
import common.data.DeleteSQL;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import java.util.ArrayList;

public class DataArchiving
extends ServiceController {
    @Override
    public void serviceRun() throws YosException {
        this.databaseinit();
        this.archiveData();
        this.archiveSiteData();
    }

    private void archiveData() throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select table_name,condition,foreign_table from sys_dataarchiving where issite=1 and isopen=1");
        for (Row row : rows) {
            ArrayList<String> sqllist = new ArrayList<String>();
            String table_name = row.getString("table_name");
            String condition = row.getString("condition");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");
            String database2 = this.dbConnect.getDBName() + "_archive";
            Rows dataRows = this.dbConnect.runSqlQuery("select * from " + table_name + " where (" + condition + ") limit 1000");
            for (Row dataRow : dataRows) {
                String uniquecolumnname = this.getuniquecolumnname(table_name);
                long dataid = dataRow.getLong(uniquecolumnname);
                String insertsql = dataRow.getInsertSQL(table_name).getSQL().replace(" " + table_name + " ", " " + database2 + "." + table_name + " ");
                String deletesql = ((DeleteSQL)SQLFactory.createDeleteSQL(this.dbConnect, table_name).setUniqueid(dataid)).getSQL();
                sqllist.add(insertsql);
                sqllist.add(deletesql);
                for (int i = 0; i < foreign_tables.size(); ++i) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    String foreign_table_name = foreign_table.getString("table_name");
                    String foreign_condition = foreign_table.getString("condition");
                    Rows foreign_dataRows = this.dbConnect.runSqlQuery("select " + foreign_table_name + ".* from " + foreign_table_name + " inner join " + table_name + " on " + foreign_condition + " where " + table_name + "." + uniquecolumnname + "=" + dataid);
                    for (Row foreign_dataRow : foreign_dataRows) {
                        String foreign_uniquecolumnname = this.getuniquecolumnname(foreign_table_name);
                        long foreign_dataid = dataRow.getLong(foreign_uniquecolumnname);
                        String foreign_insertsql = foreign_dataRow.getInsertSQL(foreign_table_name).getSQL().replace(" " + foreign_table_name + " ", " " + database2 + "." + foreign_table_name + " ");
                        String foreign_deletesql = ((DeleteSQL)SQLFactory.createDeleteSQL(this.dbConnect, foreign_table_name).setUniqueid(foreign_dataid)).getSQL();
                        sqllist.add(foreign_insertsql);
                        sqllist.add(foreign_deletesql);
                    }
                }
            }
            if (sqllist.isEmpty()) continue;
            this.dbConnect.runSqlUpdate(sqllist);
        }
    }

    private void archiveSiteData() throws YosException {
        ArrayList<String> siteids = this.dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = this.dbConnect.runSqlQuery("select table_name,condition,foreign_table from sys_dataarchiving where issite=1 and isopen=1");
        for (Row row : rows) {
            ArrayList<String> sqllist = new ArrayList<String>();
            String table_name = row.getString("table_name");
            String condition = row.getString("condition");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");
            for (String siteid : siteids) {
                String database2 = this.dbConnect.getDBName() + "_archive_" + siteid;
                Rows dataRows = this.dbConnect.runSqlQuery("select * from " + table_name + " where siteid='" + siteid + "' and (" + condition + ") limit 1000");
                for (Row dataRow : dataRows) {
                    String uniquecolumnname = this.getuniquecolumnname(table_name);
                    long dataid = dataRow.getLong(uniquecolumnname);
                    String insertsql = dataRow.getInsertSQL(table_name).getSQL().replace(" " + table_name + " ", " " + database2 + "." + table_name + " ");
                    String deletesql = ((DeleteSQL)SQLFactory.createDeleteSQL(this.dbConnect, table_name).setUniqueid(dataid)).getSQL();
                    sqllist.add(insertsql);
                    sqllist.add(deletesql);
                    for (int i = 0; i < foreign_tables.size(); ++i) {
                        JSONObject foreign_table = foreign_tables.getJSONObject(i);
                        String foreign_table_name = foreign_table.getString("table_name");
                        String foreign_condition = foreign_table.getString("condition");
                        Rows foreign_dataRows = this.dbConnect.runSqlQuery("select " + foreign_table_name + ".* from " + foreign_table_name + " inner join " + table_name + " on " + foreign_condition + " where " + table_name + "." + uniquecolumnname + "=" + dataid);
                        for (Row foreign_dataRow : foreign_dataRows) {
                            String foreign_uniquecolumnname = this.getuniquecolumnname(foreign_table_name);
                            long foreign_dataid = dataRow.getLong(foreign_uniquecolumnname);
                            String foreign_insertsql = foreign_dataRow.getInsertSQL(foreign_table_name).getSQL().replace(" " + foreign_table_name + " ", " " + database2 + "." + foreign_table_name + " ");
                            String foreign_deletesql = ((DeleteSQL)SQLFactory.createDeleteSQL(this.dbConnect, foreign_table_name).setUniqueid(foreign_dataid)).getSQL();
                            sqllist.add(foreign_insertsql);
                            sqllist.add(foreign_deletesql);
                        }
                    }
                }
            }
            if (sqllist.isEmpty()) continue;
            this.dbConnect.runSqlUpdate(sqllist);
        }
    }

    private void databaseinit() throws YosException {
        ArrayList<String> siteids = this.dbConnect.runSqlQuery("select siteid from sys_site").toArrayList("siteid");
        Rows rows = this.dbConnect.runSqlQuery("select issite,table_name,foreign_table from sys_dataarchiving where isopen=1");
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            JSONArray foreign_tables = row.getJSONArray("foreign_table");
            ArrayList<String> databaseList = new ArrayList<String>();
            if (row.getBoolean("issite").booleanValue()) {
                for (String siteid : siteids) {
                    databaseList.add(this.dbConnect.getDBName() + "_archive_" + siteid);
                }
            } else {
                databaseList.add(this.dbConnect.getDBName() + "_archive");
            }
            for (String database2 : databaseList) {
                this.createDataBase(database2, table_name);
                for (int i = 0; i < foreign_tables.size(); ++i) {
                    JSONObject foreign_table = foreign_tables.getJSONObject(i);
                    this.createDataBase(database2, foreign_table.getString("table_name"));
                }
            }
        }
    }

    private void createDataBase(String database2, String table_name) throws YosException {
        if (this.dbConnect.runSqlQuery("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'yosss'").isEmpty()) {
            this.dbConnect.runSqlUpdate("CREATE DATABASE `" + database2 + "` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_datasource");
            insertSQL.setValue("datakey", database2);
            insertSQL.setValue("dbname", database2);
            insertSQL.setValue("isdataarchive", 1);
            insertSQL.setValue("driver", "");
            insertSQL.setValue("username", "");
            insertSQL.setValue("password", "");
            insertSQL.setValue("url", "");
            insertSQL.insert();
        }
        ArrayList<String> sqllist = new ArrayList<String>();
        if (this.dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" + database2 + "' AND table_name = '" + table_name + "'").isEmpty()) {
            sqllist.add(this.dbConnect.runSqlQuery("SHOW CREATE table " + table_name).get(0).getString("Create Table"));
        } else {
            Rows tablecolrows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "'");
            for (Row tablecolrow : tablecolrows) {
                String column_name = tablecolrow.getString("column_name");
                String column_type = tablecolrow.getString("column_type");
                int numeric_precision = tablecolrow.getInteger("numeric_precision");
                int numeric_scale = tablecolrow.getInteger("numeric_scale");
                String type = this.getColumn_type(column_type, numeric_precision, numeric_scale);
                Rows cr = this.dbConnect.runSqlQuery("SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + database2 + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'");
                if (cr.isEmpty()) {
                    sqllist.add("alter table " + table_name + " add " + column_name + " " + type + " null;");
                    continue;
                }
                if (cr.get(0).getString("COLUMN_TYPE").equalsIgnoreCase(type)) continue;
                sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + " null;");
            }
        }
        if (!sqllist.isEmpty()) {
            new DBConnect(database2).runSqlUpdate(sqllist);
        }
    }

    private String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        }
        if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        }
        if (column_type.equals("integer")) {
            return "int";
        }
        return column_type;
    }
}

