package utility.email;

import beans.parameter.Parameter;
import common.BaseClass;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Properties;

public class Email extends BaseClass {
    Session session = null;
    Transport transport = null;
    MimeMessage message = null;

//
//    public static void main(String[] args) throws Exception {
//        Email email = new Email("订单发货通知", "13732579910@139.com");
//        EmailContent emailContent = new EmailContent();
//        emailContent.addText("尊敬的****：");
//        emailContent.addBr(3);
//        emailContent.addText(8, "您的订单已于2022-01-01 12:12:21 发货，请跟踪查收！发货详情见附件。");
//        //emailContent.addImage("https://www.baidu.com/img/flexible/logo/pc/result@2.png");
//        emailContent.addBr();
//        emailContent.addFile("http://maven.jeecg.org/nexus/content/repositories/jeecg/pinyin4j/pinyin4j-util/2.5.0/pinyin4j-util-2.5.0.jar");
//        email.send(emailContent);
//    }

    public Email(String siteid, String subject, String[] tos) throws Exception {
        init(siteid, subject, tos);
    }

    public Email(String siteid, String subject, String to) throws Exception {
        init(siteid, subject, new String[]{to});
    }

    public Email(String siteid, String subject, ArrayList<String> tolist) throws Exception {
        init(siteid, subject, tolist.toArray(new String[]{}));
    }

    private void init(String siteid, String subject, String[] tos) throws Exception {
        //使用JavaMail发送邮件的5个步骤
        Properties prop = new Properties();
        prop.setProperty("mail.host", Parameter.get(siteid, "mail_host"));
        prop.setProperty("mail.transport.protocol", Parameter.get(siteid, "mail_transport_protocol"));
        prop.setProperty("mail.smtp.auth", Parameter.get(siteid, "mail_smtp_auth").equals("1") ? "true" : "false");
        //1、创建session
        session = Session.getInstance(prop);
        //开启Session的debug模式，这样就可以查看到程序发送Email的运行状态
        //session.setDebug(properties.isdebug());
        message = new MimeMessage(session);
        //指明邮件的发件人
        message.setFrom(Parameter.get(siteid, "mail_sendfrom"));
        //指明邮件的收件人，现在发件人和收件人是一样的，那就是自己给自己发
        ArrayList<InternetAddress> address = new ArrayList<>();
        for (String to : tos) {
            address.add(new InternetAddress(to));
        }
        message.setRecipients(Message.RecipientType.TO, address.toArray(new Address[]{}));
        //邮件的标题
        message.setSubject(subject);
    }

    public void send(String siteid, EmailContent emailContent) throws Exception {
        message.setContent(emailContent);
        transport = session.getTransport();
        //3、使用邮箱的用户名和密码连上邮件服务器，发送邮件时，发件人需要提交邮箱的用户名和密码给smtp服务器，用户名和密码都通过验证之后才能够正常发送邮件给收件人。
        transport.connect(Parameter.get(siteid, "mail_host"), Parameter.get(siteid, "mail_user"),
                Parameter.get(siteid, "mail_password"));
        //返回创建好的邮件对象
        transport.sendMessage(message, message.getAllRecipients());
        transport.close();
    }
}
