package restcontroller.sysmanage.develop.version;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;

public class version extends Controller {
    public version(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "版本查询", apiversion = R.ID2024061815145101.v1.class)
    public String queryVersionList() throws YosException {
        Rows sys_versionRows = dbConnect.runSqlQuery("select * from sys_version");
        return getSucReturnObject().setData(sys_versionRows).toString();
    }

    @API(title = "版本新增修改", apiversion = R.ID2024061815195501.v1.class)
    public String insertormodifyVersion() throws YosException {
        long versionid = content.getLongValue("versionid");
        String version = content.getString("version");// 版本名称
        if (SQLFactory.createQuerySQL(this, "sys_version", "versionid").setUniqueid(versionid).query().isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_version");
            insertSQL.setValue("version", version);
            insertSQL.setValue("isdefault", false);
            insertSQL.insert();
        } else {
            if (dbConnect.runSqlQuery("select * from sys_version where isdefault=1 and versionid=" + versionid).isNotEmpty()) {
                return getErrReturnObject().setErrMsg("系统默认版本不可修改").toString();
            }
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_version");
            updateSQL.setValue("version", version);
            updateSQL.setUniqueid(versionid);
            updateSQL.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "版本删除", apiversion = R.ID2024061815291001.v1.class)
    public String deleteVersion() throws YosException {
        long versionid = content.getLongValue("versionid");
        if (dbConnect.runSqlQuery("select * from sys_version where isdefault=1 and versionid=" + versionid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统默认版本不可删除").toString();
        }
        if (dbConnect.runSqlQuery("select * from sys_version_sites where versionid=" + versionid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("该版本已被站点授权，不可删除").toString();
        }
        ArrayList<String> sqlist = new ArrayList<>();
        sqlist.add("delete from sys_version where versionid=" + versionid);
        sqlist.add("delete from sys_version_area where versionid=" + versionid);
        dbConnect.runSqlUpdate(sqlist);
        return getSucReturnObject().toString();
    }


    @API(title = "版本应用范围查询", apiversion = R.ID2024061815153901.v1.class)
    public String queryVersion_area() throws YosException {
        long versionid = content.getLong("versionid");

        Rows sys_version_areaRows = null;
        if (dbConnect.runSqlQuery("select * from sys_version where isdefault=1 and versionid=" + versionid).isNotEmpty()) {
            sys_version_areaRows = dbConnect.runSqlQuery("select t1.systemid,t1.systemname ,'system' as type from sys_system t1 where t1.systemid!=0");
        } else {
            SQLFactory sys_version_areaSqlFactory = new SQLFactory(this, "版本功能授权范围查询");
            sys_version_areaSqlFactory.addParameter("versionid", versionid);
            sys_version_areaRows = dbConnect.runSqlQuery(sys_version_areaSqlFactory.getSQL());
        }
        JSONArray systemArray = new JSONArray();

        RowsMap systemRowsMap = sys_version_areaRows.toRowsMap("systemid");
        for (String systemid : systemRowsMap.keySet()) {
            JSONObject systemObject = new JSONObject();
            Rows systemRows = systemRowsMap.get(systemid);
            for (Row systemRow : systemRows) {
                systemObject.put("systemid", systemRow.getLong("systemid"));
                systemObject.put("systemname", systemRow.getString("systemname"));
                if (systemRow.getString("type").equals("system")) {
                    systemObject.put("type", systemRow.getString("type"));
                    systemObject.put("sys_version_areaid", systemRow.getLong("sys_version_areaid"));
                    break;
                }
            }
            JSONArray clientArray = new JSONArray();
            RowsMap systemClientRowsMap = systemRows.toRowsMap("systemclientid");
            for (String systemclientid : systemClientRowsMap.keySet()) {
                if (systemclientid.equals("0")) {
                    continue;
                }
                JSONObject clientObject = new JSONObject();
                Rows clientRows = systemClientRowsMap.get(systemclientid);
                for (Row clientRow : clientRows) {
                    if (clientRow.getLong("systemclientid") > 0) {
                        clientObject.put("systemid", clientRow.getLong("systemid"));
                        clientObject.put("systemname", clientRow.getString("systemname"));
                        clientObject.put("systemclientid", clientRow.getLong("systemclientid"));
                        clientObject.put("systemclientname", clientRow.getString("systemclientname"));
                        if (clientRow.getString("type").equals("client")) {
                            clientObject.put("type", clientRow.getString("type"));
                            clientObject.put("sys_version_areaid", clientRow.getLong("sys_version_areaid"));
                            break;
                        }
                    }
                }

                JSONArray moduleArray = new JSONArray();
                RowsMap systemModuleRowsMap = clientRows.toRowsMap("systemmoduleid");
                for (String systemmoduleid : systemModuleRowsMap.keySet()) {
                    JSONObject moduleObject = new JSONObject();
                    Rows moduleRows = systemModuleRowsMap.get(systemmoduleid);
                    for (Row moduleRow : moduleRows) {
                        if (moduleRow.getLong("systemmoduleid") > 0) {
                            moduleObject.put("systemid", moduleRow.getLong("systemid"));
                            moduleObject.put("systemname", moduleRow.getString("systemname"));
                            moduleObject.put("systemclientid", moduleRow.getLong("systemclientid"));
                            moduleObject.put("systemclientname", moduleRow.getString("systemclientname"));
                            moduleObject.put("systemmoduleid", moduleRow.getLong("systemmoduleid"));
                            moduleObject.put("systemmodulename", moduleRow.getString("systemmodulename"));
                            if (moduleRow.getString("type").equals("module")) {
                                moduleObject.put("type", moduleRow.getString("type"));
                                moduleObject.put("sys_version_areaid", moduleRow.getLong("sys_version_areaid"));
                                break;
                            }
                        }
                    }
                    JSONArray appArray = new JSONArray();
                    RowsMap systemAppRowsMap = moduleRows.toRowsMap("systemappid");
                    for (String systemappid : systemAppRowsMap.keySet()) {
                        JSONObject appObject = new JSONObject();
                        Rows appRows = systemAppRowsMap.get(systemappid);
                        for (Row appRow : appRows) {
                            if (appRow.getLong("systemappid") > 0) {
                                appObject.put("systemid", appRow.getLong("systemid"));
                                appObject.put("systemname", appRow.getString("systemname"));
                                appObject.put("systemclientid", appRow.getLong("systemclientid"));
                                appObject.put("systemclientname", appRow.getString("systemclientname"));
                                appObject.put("systemmoduleid", appRow.getLong("systemmoduleid"));
                                appObject.put("systemmodulename", appRow.getString("systemmodulename"));
                                appObject.put("systemappid", appRow.getLong("systemappid"));
                                appObject.put("systemappname", appRow.getString("systemappname"));
                                if (appRow.getString("type").equals("app")) {
                                    appObject.put("type", appRow.getString("type"));
                                    appObject.put("sys_version_areaid", appRow.getLong("sys_version_areaid"));
                                    break;
                                }
                            }
                        }
                        if (!appObject.isEmpty()) {
                            appArray.add(appObject);
                        }
                    }
                    if (appArray.size() > 0) {
                        moduleObject.put("app", appArray);
                    }
                    if (!moduleObject.isEmpty()) {
                        moduleArray.add(moduleObject);
                    }
                }
                if (moduleArray.size() > 0) {
                    clientObject.put("module", moduleArray);
                }
                if (!clientObject.isEmpty()) {
                    clientArray.add(clientObject);
                }
            }
            if (clientArray.size() > 0) {
                systemObject.put("client", clientArray);
            }
            systemArray.add(systemObject);
        }

        return getSucReturnObject().setData(systemArray).toString();
    }

    @API(title = "版本应用范围新增", apiversion = R.ID2024061815220301.v1.class)
    public String insertVersionArea() throws YosException {
        long versionid = content.getLongValue("versionid");// 系统版本ID
        if (dbConnect.runSqlQuery("select * from sys_version where isdefault=1 and versionid=" + versionid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统默认版本不可修改").toString();
        }
        ArrayList<String> sqlist = new ArrayList<>();
        JSONArray area = content.getJSONArray("area");
        for (int i = 0; i < area.size(); i++) {
            JSONObject areaObject = area.getJSONObject(i);
            long systemid = areaObject.getLongValue("systemid");// 系统ID
            long systemclientid = areaObject.getLongValue("systemclientid");// 操作端ID
            long systemmoduleid = areaObject.getLongValue("systemmoduleid");// 模块ID
            long systemappid = areaObject.getLongValue("systemappid");// 应用ID
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_version_area");
            insertSQL.setValue("versionid", versionid);
            if (systemid > 0) {
                insertSQL.setValue("systemid", systemid);
            } else if (systemclientid > 0) {
                insertSQL.setValue("systemclientid", systemclientid);
            } else if (systemmoduleid > 0) {
                insertSQL.setValue("systemmoduleid", systemmoduleid);
            } else if (systemappid > 0) {
                insertSQL.setValue("systemappid", systemappid);
            }
            sqlist.add(insertSQL.getSQL());
        }
        dbConnect.runSqlUpdate(sqlist);

        sqlist.clear();
        SQLFactory sys_version_areaSqlFactory = new SQLFactory(this, "版本功能授权范围查询");
        sys_version_areaSqlFactory.addParameter("versionid", versionid);
        Rows sys_version_areaRows = dbConnect.runSqlQuery(sys_version_areaSqlFactory.getSQL());
        RowsMap typeMap = sys_version_areaRows.toRowsMap("type");
        {
            Rows systemRows = typeMap.get("system");
            RowsMap systemidRows = sys_version_areaRows.toRowsMap("systemid");
            for (Row systemRow : systemRows) {
                String systemid = systemRow.getString("systemid");
                for (Row systemidRow : systemidRows.get(systemid)) {
                    if (!systemidRow.getString("type").equals("system")) {
                        sqlist.add("delete from sys_version_area where sys_version_areaid=" + systemidRow.getString("sys_version_areaid"));
                    }
                }
            }
        }
        {
            Rows clientRows = typeMap.get("client");
            RowsMap systemclientidRows = sys_version_areaRows.toRowsMap("systemclientid");
            for (Row clientRow : clientRows) {
                String systemclientid = clientRow.getString("systemclientid");
                for (Row systemclientidRow : systemclientidRows.get(systemclientid)) {
                    if (!systemclientidRow.getString("type").equals("client")) {
                        sqlist.add("delete from sys_version_area where sys_version_areaid=" + systemclientidRow.getString("sys_version_areaid"));
                    }
                }
            }
        }
        {
            Rows moduleRows = typeMap.get("module");
            RowsMap systemmoduleidRows = sys_version_areaRows.toRowsMap("systemmoduleid");
            for (Row moduleRow : moduleRows) {
                String systemmoduleid = moduleRow.getString("systemmoduleid");
                for (Row systemmoduleidRow : systemmoduleidRows.get(systemmoduleid)) {
                    if (!systemmoduleidRow.getString("type").equals("module")) {
                        sqlist.add("delete from sys_version_area where sys_version_areaid=" + systemmoduleidRow.getString("sys_version_areaid"));
                    }
                }
            }
        }
        dbConnect.runSqlUpdate(sqlist);
        return getSucReturnObject().toString();
    }

    @API(title = "版本应用范围删除", apiversion = R.ID2024061815293401.v1.class)
    public String deleteVersionArea() throws YosException {
        long versionid = content.getLongValue("versionid");// 系统版本ID
        long sys_version_areaid = content.getLongValue("sys_version_areaid");
        dbConnect.runSqlUpdate("delete from sys_version_area where sys_version_areaid=" + sys_version_areaid);
        return getSucReturnObject().toString();
    }

    @API(title = "版本应用授权选择查询", apiversion = R.ID2024061919394501.v1.class)
    public String queryareaapp() throws YosException {
        long versionid = content.getLong("versionid");
        if (versionid <= 0 || dbConnect.runSqlQuery("select * from sys_version where isdefault=1 and versionid=" + versionid).isNotEmpty()) {
            return getSucReturnObject().setData(new Rows()).toString();
        }

        JSONArray resultArray = new JSONArray();
        SQLFactory sys_version_areaSqlFactory = new SQLFactory(this, "版本功能授权范围查询");
        sys_version_areaSqlFactory.addParameter("versionid", versionid);
        Rows sys_version_areaRows = dbConnect.runSqlQuery(sys_version_areaSqlFactory.getSQL());


        ArrayList<Long> systemidList = new ArrayList<>();
        systemidList.add(-1L);
        ArrayList<Long> systemclientidList = new ArrayList<>();
        systemclientidList.add(-1L);
        ArrayList<Long> systemmoduleidList = new ArrayList<>();
        systemmoduleidList.add(-1L);
        ArrayList<Long> systemappidList = new ArrayList<>();
        systemappidList.add(-1L);

        ArrayList<Long> systemidList_up = new ArrayList<>();
        systemidList_up.add(-1L);
        ArrayList<Long> systemclientidList_up = new ArrayList<>();
        systemclientidList_up.add(-1L);
        ArrayList<Long> systemmoduleidList_up = new ArrayList<>();
        systemmoduleidList_up.add(-1L);
        ArrayList<Long> systemappidList_up = new ArrayList<>();
        systemappidList_up.add(-1L);

        for (Row sys_version_areaRow : sys_version_areaRows) {
            systemidList_up.add(sys_version_areaRow.getLong("systemid"));
            systemclientidList_up.add(sys_version_areaRow.getLong("systemclientid"));
            systemmoduleidList_up.add(sys_version_areaRow.getLong("systemmoduleid"));
            systemappidList_up.add(sys_version_areaRow.getLong("systemappid"));

            String type = sys_version_areaRow.getString("type");
            switch (type) {
                case "system": {
                    long systemid = sys_version_areaRow.getLong("systemid");
                    systemidList.add(systemid);
                    break;
                }
                case "client": {
                    long systemclientid = sys_version_areaRow.getLong("systemclientid");
                    systemclientidList.add(systemclientid);
                    break;
                }
                case "module": {
                    long systemmoduleid = sys_version_areaRow.getLong("systemmoduleid");
                    systemmoduleidList.add(systemmoduleid);
                    break;
                }
                case "app": {
                    long systemappid = sys_version_areaRow.getLong("systemappid");
                    systemappidList.add(systemappid);
                    break;
                }
                default:
                    break;
            }
        }
        SQLFactory sys_version_areaSelectSqlFactory = new SQLFactory(this, "版本功能授权选择查询");
        sys_version_areaSelectSqlFactory.addParameter_in("systemid", systemidList);
        sys_version_areaSelectSqlFactory.addParameter_in("systemclientid", systemclientidList);
        sys_version_areaSelectSqlFactory.addParameter_in("systemmoduleid", systemmoduleidList);
        sys_version_areaSelectSqlFactory.addParameter_in("systemappid", systemappidList);

        sys_version_areaSelectSqlFactory.addParameter_in("systemid_up", systemidList_up);
        sys_version_areaSelectSqlFactory.addParameter_in("systemclientid_up", systemclientidList_up);
        sys_version_areaSelectSqlFactory.addParameter_in("systemmoduleid_up", systemmoduleidList_up);
        sys_version_areaSelectSqlFactory.addParameter_in("systemappid_up", systemappidList_up);
        Rows sys_version_areaSelectRows = dbConnect.runSqlQuery(sys_version_areaSelectSqlFactory.getSQL());
        sys_version_areaSelectRows.sortby("systemid", "systemclientid", "systemmoduleid", "systemappid");
        return getSucReturnObject().setData(sys_version_areaSelectRows).toString();
    }

    @API(title = "版本授权站点查询", apiversion = R.ID2024061815151501.v1.class)
    public String queryVersion_site() throws YosException {
        long versionid = content.getLong("versionid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_version_sites").setTableAlias("t1");
        querySQL.addJoinTable(JOINTYPE.inner, "sys_site", "t2", "t1.siteid=t2.siteid");
        querySQL.addQueryFields("t1.versionid,t1.sys_version_sitesid,t2.siteid,t2.sitename");
        querySQL.setWhere("t1.versionid", versionid);
        Rows sys_version_sitesRows = querySQL.query();
        return getSucReturnObject().setData(sys_version_sitesRows).toString();
    }

    @API(title = "版本站点授权", apiversion = R.ID2024062008540801.v1.class)
    public String insertVersion_site() throws YosException {
        int versionid = content.getInteger("versionid");// 系统版本ID
        String siteid = content.getString("siteid");
        boolean isauth = content.getBoolean("isauth");
        if (isauth) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_version_sites");
            insertSQL.setValue("versionid", versionid);
            insertSQL.setValue("siteid", siteid);
            insertSQL.setWhere("not exists(select * from sys_version_sites t where t.versionid=" + versionid + " and t.siteid='" + siteid + "')");
            insertSQL.insert();
        } else {
            dbConnect.runSqlUpdate("delete from sys_version_sites where versionid=" + versionid + " and siteid='" + siteid + "'");
        }
        return getSucReturnObject().toString();
    }

}
