package objectregister;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.InsertSQL;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_report_config implements YosObject {
    @Override
    public String table_comment() {
        return "报表参数设置";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new YosObject.UniqueCol("sys_report_configid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new YosObject.VarcharCol("reporttype", "报表类型", 50, "积木报表"));
        arrayList.add(new YosObject.JsonCol("config", "报表配置"));
        return arrayList;
    }

    @Override
    public void DataInit() throws YosException {
        DBConnect dbConnect = new DBConnect();
        if (dbConnect.runSqlQuery("select * from sys_report_config where reporttype='积木报表'").isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_report_config");
            insertSQL.setValue("reporttype", "积木报表");

            JSONObject configObject = new JSONObject();
            JSONObject jeecgObject = new JSONObject();
            JSONObject jmreportObject = new JSONObject();
            {
                JSONArray printPaperArray = new JSONArray();
                {
                    JSONObject printPaper1Object = new JSONObject();
                    printPaper1Object.put("title", "自定义打印纸张1");
                    JSONArray sizeArray = new JSONArray();
                    sizeArray.add("180");
                    sizeArray.add("300");
                    printPaper1Object.put("size", sizeArray);
                    printPaperArray.add(printPaper1Object);
                }
                jmreportObject.put("printPaper", printPaperArray);
            }
            {
                jmreportObject.put("exportDisabled", false);
            }
            {
                jmreportObject.put("autoSave", true);
            }
            {
                jmreportObject.put("interval", 20000);
            }
            {
                jmreportObject.put("col", 100);
            }
            {
                JSONArray array = new JSONArray();
                array.add("10");
                array.add("20");
                array.add("30");
                array.add("40");
                jmreportObject.put("pageSize", array);
            }
            {
                jmreportObject.put("page-size-number", 1048576);
            }
            {
                jmreportObject.put("line", true);
            }

            jeecgObject.put("jmreport", jmreportObject);
            configObject.put("jeecg", jeecgObject);

            insertSQL.setValue("config", configObject);
            insertSQL.insert();

        }
        if (dbConnect.runSqlQuery("select * from sys_report_config where reporttype='Birt报表'").isEmpty()) {
            Rows rows = dbConnect.runSqlQuery("select paramvalue from sys_parameter where paramname='BIRT_VIEWER_WORKING_FOLDER'");

            JSONObject configObject = new JSONObject();
            configObject.put("BIRT_VIEWER_WORKING_FOLDER", rows.isEmpty() ? "" : rows.get(0).getString("paramvalue"));

            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_report_config");
            insertSQL.setValue("reporttype", "Birt报表");
            insertSQL.setValue("config", configObject);
            insertSQL.insert();
            dbConnect.runSqlUpdate("delete from sys_parameter where paramname='BIRT_VIEWER_WORKING_FOLDER'");
        }
        if (dbConnect.runSqlQuery("select * from sys_report_config where reporttype='润乾报表'").isEmpty()) {
            JSONObject configObject = new JSONObject();
            configObject.put("RAQ_VIEWER_WORKING_FOLDER", "");
            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_report_config");
            insertSQL.setValue("reporttype", "润乾报表");
            insertSQL.setValue("config", configObject);
            insertSQL.insert();
        }
    }
}
