package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_logintrack implements YosObject {
    @Override
    public String table_comment() {
        return "账号登录记录表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("logintrackid");
    }

    @Override
    public void DataInit() throws YosException {

    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new LongTextCol("requestcontent", "请求内容"));
        list.add(new DateTimeCol("createdate", "请求时间"));
        list.add(new SmallIntCol("successed", "请求结果", 0));
        list.add(new JsonCol("userids", "影响账号"));
        list.add(new VarcharCol("IPAddress", "IP地址", 200));
        list.add(new LongTextCol("useragent", "请求工具"));
        list.add(new VarcharCol("remarks", "备注信息", 200));
        list.add(new VarcharCol("sessionid", "sessionid", 200));
        return list;
    }
}
