package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_datacomment implements YosObject {

    @Override
    public String table_comment() {
        return "数据评论表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_datacommentid");
    }

    @Override
    public void DataInit() throws YosException {

    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("ownertable", "所属表", 50));
        list.add(new BigIntCol("ownerid", "所属数据id"));
        list.add(new VarcharCol("siteid", "站点ID", 50));
        list.add(new BigIntCol("createuserid", "评论人账号ID"));
        list.add(new VarcharCol("createby", "评论人", 50));
        list.add(new DateTimeCol("createdate", "评论时间"));
        list.add(new LongTextCol("content", "评论内容"));

        list.add(new BigIntCol("replyid", "回复对象评论ID"));
        list.add(new BigIntCol("replyuserid", "回复对象人员ID"));
        return list;
    }
}
