package beans.version;

import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.QuerySQL;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;
import java.util.List;

public class Version extends BaseClass {

    public static ArrayList<Long> getApps(Controller controller, Long... versionid) throws YosException {
        SQLFactory sqlFactory = new SQLFactory(new Version(), "版本功能授权范围查询");
        sqlFactory.addParameter_in("versionid", versionid);
        Rows rows = controller.dbConnect.runSqlQuery(sqlFactory.getSQL());
        return rows.toArrayList("systemappid", new ArrayList<>());
    }

    public static ArrayList<Long> getApps(Controller controller) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_version_sites", "versionid");
        querySQL.setSiteid(controller.siteid);
        List<Long> versionidList = querySQL.query().toArrayList("versionid", new ArrayList<>());
        if (versionidList.size() > 0) {
            return getApps(controller, versionidList.toArray(new Long[0]));
        } else {
            //如果站点没有授权版本，择默认授权所有应用
            return controller.dbConnect.runSqlQuery("select systemappid from sys_systemapp").toArrayList("systemappid", new ArrayList<>());
        }
    }
}
