package utility.zip;

import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class ZipUtil {

    public static void main(String[] args) {
        try {
            ZipUtil.unZip("/Users/shenjingwei/Downloads/web_update.zip", "/Users/shenjingwei/Downloads/web_update");
//            //ZipUtil.zipPath("/Users/shenjingwei/Desktop/yosweb/p2log", "/Users/shenjingwei/Desktop/yosweb/p2log.zip");
//            ZipUtil.zipPathFile();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int BUFFER_SIZE = 2048;

    public static boolean zipPath(String sourcePath, String zipFilePath) {
        boolean result = false;
        ZipArchiveEntry entry = null;
        ZipArchiveOutputStream zaos = null;
        InputStream is = null;
        try {
            File path = new File(sourcePath);
            if (path.exists() && path.isDirectory()) {
                File zipFile = new File(zipFilePath);
                zaos = new ZipArchiveOutputStream(zipFile);
                File[] fileList = path.listFiles();
                for (int i = 0; i < fileList.length; i++) {
                    File file = fileList[i];
                    if (file.isDirectory()) {
                        zipPathFile(file.getAbsolutePath(), "", zaos);
                    } else {
                        entry = new ZipArchiveEntry(file, file.getName());
                        zaos.setUseZip64(Zip64Mode.AsNeeded);
                        zaos.putArchiveEntry(entry);
                        is = new BufferedInputStream(new FileInputStream(file));
                        byte[] buffer = new byte[1024 * 5];
                        int len = -1;
                        while ((len = is.read(buffer)) != -1) {
                            zaos.write(buffer, 0, len);
                        }
                        is.close();
                        zaos.closeArchiveEntry();
                    }
                }
                result = true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (zaos != null) {
                    zaos.close();
                }
                if (is != null)
                    is.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    private static void zipPathFile(String sourcePath, String parentPath, ZipArchiveOutputStream zaos) throws Exception {
        File path = new File(sourcePath);
        ZipArchiveEntry entry = null;
        if (StringUtils.isBlank(parentPath)) {
            entry = new ZipArchiveEntry(path, path.getName());
        } else {
            entry = new ZipArchiveEntry(path, parentPath + File.separator + path.getName());
        }

        zaos.setUseZip64(Zip64Mode.AsNeeded);
        zaos.putArchiveEntry(entry);
        zaos.closeArchiveEntry();

        File[] fileList = path.listFiles();
        for (int i = 0; i < fileList.length; i++) {
            File file = fileList[i];
            if (file.isDirectory()) {
                if (StringUtils.isBlank(parentPath)) {
                    zipPathFile(file.getAbsolutePath(), path.getName(), zaos);
                } else {
                    zipPathFile(file.getAbsolutePath(), parentPath + File.separator + path.getName(), zaos);
                }
            } else {
                if (StringUtils.isBlank(parentPath)) {
                    entry = new ZipArchiveEntry(file, path.getName() + File.separator + file.getName());
                } else {
                    entry = new ZipArchiveEntry(file, parentPath + File.separator + path.getName() + File.separator + file.getName());
                }
                zaos.setUseZip64(Zip64Mode.AsNeeded);
                zaos.putArchiveEntry(entry);
                InputStream is = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[1024 * 5];
                int len = -1;
                while ((len = is.read(buffer)) != -1) {
                    zaos.write(buffer, 0, len);
                }
                is.close();
                zaos.closeArchiveEntry();
            }
        }
    }

    public static void zip(File[] files, String zipFilePath) {
        if (files != null && files.length > 0) {
            ZipArchiveOutputStream zaos = null;
            try {
                File zipFile = new File(zipFilePath);
                zaos = new ZipArchiveOutputStream(zipFile);
                zaos.setUseZip64(Zip64Mode.AsNeeded);
                for (File file : files) {
                    if (file != null) {
                        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(file, file.getName());
                        zaos.putArchiveEntry(zipArchiveEntry);
                        InputStream is = null;
                        try {
                            is = new BufferedInputStream(new FileInputStream(file));
                            byte[] buffer = new byte[1024 * 5];
                            int len = -1;
                            while ((len = is.read(buffer)) != -1) {
                                zaos.write(buffer, 0, len);
                            }
                            zaos.closeArchiveEntry();
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        } finally {
                            if (is != null)
                                is.close();
                        }
                    }
                }
                zaos.finish();
            } catch (Exception e) {
                throw new RuntimeException(e);
            } finally {
                try {
                    if (zaos != null) {
                        zaos.close();
                    }
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static List<String> unZip(String filePath, String destDir) throws Exception {
        File zipFile = new File(filePath);
        if (StringUtils.isBlank(destDir)) {
            destDir = zipFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        ZipArchiveInputStream is = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        List<String> fileNames = new ArrayList<String>();
        try {
            fileInputStream = new FileInputStream(zipFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream, BUFFER_SIZE);
            is = new ZipArchiveInputStream(bufferedInputStream);
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextZipEntry()) != null) {
                String filename = entry.getName();
                if (!filename.startsWith("__MACOSX")) {
                    fileNames.add(filename);
                    if (entry.isDirectory()) {
                        File directory = new File(destDir, filename);
                        if (!directory.exists()) {
                            directory.mkdirs();
                        }
                    } else {
                        OutputStream os = null;
                        FileOutputStream fileOutputStream = null;
                        try {
                            fileOutputStream = new FileOutputStream(new File(destDir, filename));
                            os = new BufferedOutputStream(fileOutputStream, BUFFER_SIZE);
                            IOUtils.copy(is, os);
                        } finally {
                            os.flush();
                            IOUtils.closeQuietly(fileOutputStream);
                            IOUtils.closeQuietly(os);
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(bufferedInputStream);
            IOUtils.closeQuietly(fileInputStream);
        }
        return fileNames;
    }
}
