package utility.wechat.wechatpay.POJO;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import utility.tools.WebRequest;

import java.util.Iterator;

public class CloseOrderRequest extends Base {
    private String appid;//应用ID
    private String mch_id;//商户号
    private String nonce_str;//随机字符串
    private String out_trade_no;//商户订单号

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMch_id() {
        return mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public String getNonce_str() {
        return nonce_str;
    }

    public void setNonce_str(String nonce_str) {
        this.nonce_str = nonce_str;
    }

    public String getOut_trade_no() {
        return out_trade_no;
    }

    public void setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
    }


    public CloseOrderResponse getOrderResponse(String mch_key) {
        String requestxml = asXml(mch_key);
        String res = new WebRequest().doPost(requestxml,"https://api.mch.weixin.qq.com/pay/unifiedorder");
        return getCloseOrderResponse(res);
    }

    private String asXml(String mch_key) {
        DOMElement request = new DOMElement("xml");
        request.addElement("appid").addText(appid);//应用ID
        request.addElement("mch_id").addText(mch_id);//商户ID
        request.addElement("nonce_str").addText(createNonce_str(out_trade_no + appid));//随机字符串
        request.addElement("out_trade_no").addText(out_trade_no);//商户订单号
        createSign(request,mch_key);
        return request.asXML();
    }

    private CloseOrderResponse getCloseOrderResponse(String response) {
        CloseOrderResponse orderResponse = new CloseOrderResponse();
        try {
            Document respones = DocumentHelper.parseText(response);
            Iterator<Element> it = respones.getRootElement().elementIterator();
            while (it.hasNext()) {
                Element element = it.next();
                String key = element.getName();
                String text = element.getText();
                switch (key) {
                    case "return_code": {
                        orderResponse.setReturn_code(text);
                        break;
                    }
                    case "return_msg": {
                        orderResponse.setReturn_msg(text);
                        break;
                    }
                    case "appid": {
                        orderResponse.setAppid(text);
                        break;
                    }
                    case "mch_id": {
                        orderResponse.setMch_id(text);
                        break;
                    }

                    case "nonce_str": {
                        orderResponse.setNonce_str(text);
                        break;
                    }
                    case "sign": {
                        orderResponse.setSign(text);
                        break;
                    }
                    case "result_code": {
                        orderResponse.setResult_code(text);
                        break;
                    }
                    case "result_msg": {
                        orderResponse.setResult_msg(text);
                        break;
                    }
                    case "err_code": {
                        orderResponse.setErr_code(text);
                        break;
                    }
                    case "err_code_des": {
                        orderResponse.setErr_code_des(text);
                        break;
                    }
                    default:
                        break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return orderResponse;
    }
}
