package restcontroller.sysmanage.develop.paymentrules;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

/**
 * 版本管理
 */
public class systempartition extends Controller {
    /**
     * 构造函数
     *
     * @param content
     */
    public systempartition(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "版本新增或更新")
    public String insertOrUpdate() throws YosException {
        String siteid = content.getString("siteid");
        Long sys_site_systempartitionid = content.getLongValue("sys_site_systempartitionid");
        JSONArray systemappids = content.getJSONArray("systemappids");

        SQLFactory sqlFactory = new SQLFactory(this, "版本_新增");
        if (sys_site_systempartitionid <= 0) {
            sys_site_systempartitionid = createTableID("sys_site_systempartition");
        } else {
            sqlFactory = new SQLFactory(this, "版本_更新");
        }
        sqlFactory.addParameter("sys_site_systempartitionid", sys_site_systempartitionid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("partitionname", content.getStringValue("partitionname"));
        sqlFactory.addParameter("systemappids", systemappids);
        dbConnect.runSqlUpdate(sqlFactory);

        content.put("sys_site_systempartitionid", sys_site_systempartitionid);
        return detail();
    }

    @API(title = "查询版本列表")
    public String list() throws YosException {
        String siteid = content.getString("siteid");
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.partitionname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "版本_列表", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            String systemappids = row.getString("systemappids");
            JSONArray array = JSONArray.parseArray(systemappids);
            row.put("systemappids", array);
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "版本详细")
    public String detail() throws YosException {
        String siteid = content.getString("siteid");
        Long sys_site_systempartitionid = content.getLongValue("sys_site_systempartitionid");

        SQLFactory sqlFactory = new SQLFactory(this, "版本_详细");
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("sys_site_systempartitionid", sys_site_systempartitionid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            String systemappids = row.getString("systemappids");
            JSONArray array = JSONArray.parseArray(systemappids);
            row.put("systemappids", array);

            sqlFactory = new SQLFactory(this, "查询系统模块列表");
            sqlFactory.addParameter_in("systemappid", array.toArray());
            String sql = sqlFactory.getSQL();
            Rows systemappRows = dbConnect.runSqlQuery(sql);
            row.put("systemapp", systemappRows);
        }
        Row detailRow = rows.isNotEmpty() ? rows.get(0) : new Row();

        return getSucReturnObject().setData(detailRow).toString();
    }

    @API(title = "版本删除")
    public String delete() throws YosException {
        String siteid = content.getString("siteid");
        Long sys_site_systempartitionid = content.getLongValue("sys_site_systempartitionid");
        //查询是否有账号付费订单
        if (dbConnect.runSqlQuery("SELECT 1 from sys_payorder WHERE sys_site_systempartitionid=" + sys_site_systempartitionid + " and siteid='" + siteid + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("存在付费信息，无法删除").toString();
        }
        if (dbConnect.runSqlQuery("SELECT 1 from sys_site_paymentrules WHERE sys_site_systempartitionid=6 and siteid='meida'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("存在付费规则，无法删除").toString();
        }

        dbConnect.runSqlUpdate("DELETE FROM sys_site_systempartition WHERE sys_site_systempartitionid=" + sys_site_systempartitionid + " and siteid='" + siteid + "'");

        return getSucReturnObject().toString();
    }

    @API(title = "版本明细删除")
    public String deleteMX() throws YosException {
        String siteid = content.getString("siteid");
        Long sys_site_systempartitionid = content.getLongValue("sys_site_systempartitionid");
        JSONArray systemappids = content.getJSONArray("systemappids");
        //查询是否有账号付费订单
        if (dbConnect.runSqlQuery("SELECT 1 from sys_payorder WHERE sys_site_systempartitionid=" + sys_site_systempartitionid + " and siteid='" + siteid + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("存在付费信息，无法删除").toString();
        }
        if (systemappids.size() == 0) {
            return getErrReturnObject().setErrMsg("请选择要删除的明细行").toString();
        }

        Rows rows = dbConnect.runSqlQuery("SELECT systemappids from sys_site_systempartition WHERE sys_site_systempartitionid=" + sys_site_systempartitionid + " and siteid='" + siteid + "'");
        JSONArray array = new JSONArray();
        if (rows.isNotEmpty()) {
            array = JSONArray.parseArray(rows.get(0).getString("systemappids"));
        }
        array.removeAll(systemappids);

        dbConnect.runSqlUpdate("UPDATE sys_site_systempartition SET systemappids='" + array + "' WHERE sys_site_systempartitionid=" + sys_site_systempartitionid + " and siteid='" + siteid + "'");

        return getSucReturnObject().toString();
    }

    @API(title = "查询系统模块")
    public String list_model() throws YosException {
        String siteid = content.getString("siteid");
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t2.systemmodulename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.systemappname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        if (pageSorting.equals("''")) {
            pageSorting = "t4.systemname desc,t3.systemclient,t2.systemmodulename desc";
        }
        Long sys_site_systempartitionid = content.getLongValue("sys_site_systempartitionid");
        JSONArray systemappids = new JSONArray();
        if (sys_site_systempartitionid > 0) {
            SQLFactory sqlFactory = new SQLFactory(this, "版本_详细");
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("sys_site_systempartitionid", sys_site_systempartitionid);
            Rows rows = dbConnect.runSqlQuery(sqlFactory);
            for (Row row : rows) {
                systemappids = JSONArray.parseArray(row.getString("systemappids"));
            }
        }

        SQLFactory sqlFactory = new SQLFactory(this, "查询系统模块", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter_in("systemappid", systemappids.toArray());
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);

        return getSucReturnObject().setData(rows).toString();
    }
}
