package beans.user;

import beans.department.Department;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.*;
import common.data.db.DBConnect;

import java.util.ArrayList;

public class User extends BaseClass {
    /**
     * 创建账号
     *
     * @param controller
     * @param name        账号名称
     * @param phonenumber 手机号
     * @param usertype    用户类型
     * @param roleids     角色id
     * @param remarks     备注
     * @return
     * @throws YosException
     */
    public static long createUser(Controller controller, String name, String phonenumber, int usertype, Long[] roleids, String remarks) throws YosException {
        return createUser(controller, "", name, phonenumber, usertype, roleids, remarks);
    }

    /**
     * 创建账号
     *
     * @param controller
     * @param name        账号名称
     * @param phonenumber 手机号
     * @param usertype    用户类型
     * @param roleids     角色id
     * @param remarks     备注
     * @return
     * @throws YosException
     */
    public static long createUser(Controller controller, String accountno, String name, String phonenumber, int usertype, Long[] roleids, String remarks) throws YosException {
        ArrayList<String> sqllist = new ArrayList<>();
        Rows userRows = controller.dbConnect.runSqlQuery("select * from sys_users where ifnull(phonenumber,'') !='' and  phonenumber='" + phonenumber + "'");
        long userid;
        if (userRows.isEmpty()) {
            String password_default = controller.dbConnect.runSqlQuery(0, "select password_default from sys_site_parameter where siteid='" + controller.siteid + "'").getString("password_default");
            userid = controller.createTableID("sys_users");
            SQLFactory addusersql = new SQLFactory(new User(), "账号新增");
            addusersql.addParameter("userid", userid);
            addusersql.addParameter("name", name);
            addusersql.addParameter("password", password_default);
            addusersql.addParameter("createby", controller.username);
            addusersql.addParameter("phonenumber", phonenumber);
            addusersql.addParameter("accountno", accountno.equals("") ? controller.makeFillCode(6, userid) : accountno);
            addusersql.addParameter("remarks", remarks);
            sqllist.add(addusersql.getSQL());
        } else {
            userid = userRows.get(0).getLong("userid");
        }
        SQLFactory addusersitesql = new SQLFactory(new User(), "账号站点添加");
        addusersitesql.addParameter("usersiteid", controller.createTableID("sys_usersite"));
        addusersitesql.addParameter("userid", userid);
        addusersitesql.addParameter("usertype", usertype);
        addusersitesql.addParameter("siteid", controller.siteid);
        addusersitesql.addParameter("createby", controller.username);
        sqllist.add(addusersitesql.getSQL());

        InsertSQL insertSQL = SQLFactory.createInsertSQL(controller, "sys_usersitelog");
        insertSQL.setValue("sys_usersitelogid", controller.createTableID("sys_usersitelog"));
        insertSQL.setValue("userid", userid);
        insertSQL.setValue("siteid", controller.siteid);
        insertSQL.setDateValue("begdate");
        insertSQL.setWhere(" not exists (select *from sys_usersite where userid=" + userid + " and siteid='" + controller.siteid + "')");
        sqllist.add(insertSQL.getSQL());

        for (long roleid : roleids) {
            SQLFactory sqlFactory = new SQLFactory(new User(), "账号角色添加");
            sqlFactory.addParameter("userid", userid);
            sqlFactory.addParameter("userroleid", controller.createTableID("sys_userrole"));
            sqlFactory.addParameter("roleid", roleid);//新用户默认角色
            sqlFactory.addParameter("createby", controller.username);
            sqlFactory.addParameter("changeuserid", controller.userid);
            sqllist.add(sqlFactory.getSQL());
        }
        controller.dbConnect.runSqlUpdate(sqllist);
        return userid;
    }


    public static long createUser(Controller controller, long sys_enterpriseid, String name, String phonenumber, boolean isleader, String position, int usertype, Long[] roleids, String remarks) throws YosException {
        return createUser(controller, sys_enterpriseid, "", name, phonenumber, isleader, position, usertype, roleids, remarks);
    }

    /**
     * 创建账号
     *
     * @param controller
     * @param sys_enterpriseid 企业id
     * @param name             姓名
     * @param phonenumber      手机号
     * @param isleader         是否负责人
     * @param position         职位
     * @param usertype         账号类型
     * @param roleids          角色id
     * @param remarks          备注
     * @return
     * @throws YosException
     */
    public static long createUser(Controller controller, long sys_enterpriseid, String accountno, String name, String phonenumber, boolean isleader, String position, int usertype, Long[] roleids, String remarks) throws YosException {
        if (!accountno.equals("")) {
            if (controller.dbConnect.runSqlQuery("select *from sys_users where accountno='" + accountno + "'").isNotEmpty()) {
                throw new YosException(false, "账号不可重复！");
            }
        }

        ArrayList<String> sqllist = new ArrayList<>();
        Rows userRows = controller.dbConnect.runSqlQuery("select * from sys_users where ifnull(phonenumber,'') !='' and phonenumber='" + phonenumber + "'");
        long userid;
        if (userRows.isEmpty()) {
            String password_default = controller.dbConnect.runSqlQuery(0, "select password_default from sys_site_parameter where siteid='" + controller.siteid + "'").getString("password_default");
            userid = controller.createTableID("sys_users");
            SQLFactory addusersql = new SQLFactory(new User(), "账号新增");
            addusersql.addParameter("userid", userid);
            addusersql.addParameter("name", name);
            addusersql.addParameter("password", password_default);
            addusersql.addParameter("createby", controller.username);
            addusersql.addParameter("phonenumber", phonenumber);
            addusersql.addParameter("accountno", accountno.equals("") ? controller.makeFillCode(6, userid) : accountno);
            addusersql.addParameter("remarks", remarks);
            sqllist.add(addusersql.getSQL());
        } else {
            userid = userRows.get(0).getLong("userid");
        }
        SQLFactory addusersitesql = new SQLFactory(new User(), "账号站点添加");
        addusersitesql.addParameter("usersiteid", controller.createTableID("sys_usersite"));
        addusersitesql.addParameter("userid", userid);
        addusersitesql.addParameter("usertype", usertype);
        addusersitesql.addParameter("siteid", controller.siteid);
        addusersitesql.addParameter("createby", controller.username);
        sqllist.add(addusersitesql.getSQL());

        for (long roleid : roleids) {
            SQLFactory sqlFactory = new SQLFactory(new User(), "账号角色添加");
            sqlFactory.addParameter("userid", userid);
            sqlFactory.addParameter("userroleid", controller.createTableID("sys_userrole"));
            sqlFactory.addParameter("roleid", roleid);//新用户默认角色
            sqlFactory.addParameter("createby", controller.username);
            sqlFactory.addParameter("changeuserid", controller.userid);
            sqllist.add(sqlFactory.getSQL());
        }

        long sys_enterprise_hrid = controller.createTableID("sys_enterprise_hr");
        SQLFactory addhrsql = new SQLFactory(new User(), "企业团队成员新增");
        addhrsql.addParameter("siteid", controller.siteid);
        addhrsql.addParameter("sys_enterprise_hrid", sys_enterprise_hrid);
        addhrsql.addParameter("sys_enterpriseid", sys_enterpriseid);
        addhrsql.addParameter("userid", userid);
        addhrsql.addParameter("name", name);
        addhrsql.addParameter("phonenumber", phonenumber);
        addhrsql.addParameter("isleader", isleader);
        addhrsql.addParameter("position", position);
        addhrsql.addParameter("remarks", "");
        addhrsql.addParameter("changeuserid", userid);
        sqllist.add(addhrsql.getSQL());
        controller.dbConnect.runSqlUpdate(sqllist);
        return userid;
    }

    /**
     * 获取我的下属账号id
     *
     * @param controller
     */
    public static ArrayList<Long> getSubUserIds(Controller controller) throws YosException {
        ArrayList<Long> userids = new ArrayList<>();
        if (controller.departmentid > 0) {
            ArrayList<Long> departmentids = Department.getSubDepartmentIds(controller);
            if (controller.isleader) {
                departmentids.add(controller.departmentid);
            }
            //查找自己是否为代理人
            QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_userteam");
            querySQL.addJoinTable(JOINTYPE.inner, "sys_hr", "sys_hr", "userid = :createuserid and siteid ='" + controller.siteid + "'", "userid", "hrid");
            querySQL.setWhere("userid", controller.userid).setWhere("isproxy", 1);
            Rows userteamRows = querySQL.query();
            for (Row userteamRow : userteamRows) {
                userids.add(userteamRow.getLong("userid"));
                userids.addAll(controller.dbConnect.runSqlQuery("select userid from sys_hr where siteid='" + controller.siteid + "' and reporthrid=" + userteamRow.getLong("hrid")).toArrayList("userid", new ArrayList<>()));
            }

            SQLFactory sqlFactory = new SQLFactory("sql:select userid from sys_hr where siteid='" + controller.siteid + "' and departmentid in $departmentid$ ");
            sqlFactory.addParameter_in("departmentid", departmentids);
            userids.addAll(sqlFactory.runSqlQuery(controller.dbConnect).toArrayList("userid", new ArrayList<>()));
            /*
            汇报对象是自己的
             */
            userids.addAll(controller.dbConnect.runSqlQuery("select userid from sys_hr where siteid='" + controller.siteid + "' and reporthrid=" + controller.hrid).toArrayList("userid", new ArrayList<>()));

            //排除本部门其他负责人
            for (Long id : Department.getLeaderUserids(controller)) {
                if (id != controller.userid) {
                    userids.remove(id);
                }
            }
            //排除代理人部门其他负责人
            for (Row userteamRow : userteamRows) {
                for (Long id : Department.getLeaderUserids(controller, userteamRow.getLong("departmentid"))) {
                    if (id != userteamRow.getLong("userid")) {
                        userids.remove(id);
                    }
                }
            }
        } else if (controller.sys_enterpriseid > 0 && controller.isleader) {
            userids.addAll(controller.dbConnect.runSqlQuery("select userid from sys_enterprise_hr where siteid='" + controller.siteid + "' and sys_enterpriseid=" + controller.sys_enterpriseid).toArrayList("userid", new ArrayList<>()));
        }
        userids.remove(controller.userid);
        return userids;
    }

    /**
     * 获取我的下属人员id
     *
     * @param controller
     */
    public static ArrayList<Long> getSubHrIds(Controller controller) throws YosException {
        ArrayList<Long> hrids = new ArrayList<>();
        if (controller.departmentid > 0) {
            ArrayList<Long> departmentids = Department.getSubDepartmentIds(controller);
            if (controller.isleader) {
                departmentids.add(controller.departmentid);
            }
            //查找自己是否为代理人
            QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_userteam");
            querySQL.addJoinTable(JOINTYPE.inner, "sys_hr", "sys_hr", "userid = :createuserid and siteid ='" + controller.siteid + "'", "hrid");
            querySQL.setWhere("userid", controller.userid).setWhere("isproxy", 1);
            Rows userteamRows = querySQL.query();
            for (Row userteamRow : userteamRows) {
                hrids.add(userteamRow.getLong("hrid"));
                hrids.addAll(controller.dbConnect.runSqlQuery("select hrid from sys_hr where siteid='" + controller.siteid + "' and reporthrid=" + userteamRow.getLong("hrid")).toArrayList("hrid", new ArrayList<>()));
            }

            SQLFactory sqlFactory = new SQLFactory("sql:select hrid from sys_hr where siteid='" + controller.siteid + "' and departmentid in $departmentid$ ");
            sqlFactory.addParameter_in("departmentid", departmentids);
            hrids.addAll(sqlFactory.runSqlQuery(controller.dbConnect).toArrayList("hrid", new ArrayList<>()));
            /*
            汇报对象是自己的
             */
            hrids.addAll(controller.dbConnect.runSqlQuery("select hrid from sys_hr where siteid='" + controller.siteid + "' and reporthrid=" + controller.hrid).toArrayList("userid", new ArrayList<>()));

            //排除本部门其他负责人
            for (Long id : Department.getLeaderUserids(controller)) {
                if (id != controller.userid) {
                    hrids.remove(id);
                }
            }
            //排除代理人部门其他负责人
            for (Row userteamRow : userteamRows) {
                for (Long id : Department.getLeaderUserids(controller, userteamRow.getLong("departmentid"))) {
                    if (id != userteamRow.getLong("hrid")) {
                        hrids.remove(id);
                    }
                }
            }
            hrids.remove(controller.hrid);
        }
        return hrids;
    }


    /**
     * 获取负责的企业id，包括，企业领域授权、客户团队
     *
     * @param controller
     * @return
     * @throws YosException
     */
    public static ArrayList<Long> getSubEnterpriseids(Controller controller) throws YosException {
        ArrayList<Long> subhridlist = getSubHrIds(controller);
        subhridlist.add(controller.hrid);

        //企业领域授权
        QuerySQL tradefieldQuerySQL = SQLFactory.createQuerySQL(controller, "sys_enterprise_tradefield", "sys_enterpriseid");
        tradefieldQuerySQL.setSiteid(controller.siteid).setWhere("hrid", subhridlist);
        ArrayList<Long> sublist = tradefieldQuerySQL.query().toArrayList("sys_enterpriseid", new ArrayList<>());

        ArrayList<Long> subuserlist = getSubUserIds(controller);
        subuserlist.add(controller.userid);

        //查询客户数据团队表
        QuerySQL datateamQuerySQL = SQLFactory.createQuerySQL(controller, "sys_datateam");
        datateamQuerySQL.addJoinTable(JOINTYPE.inner, "sa_customers", "sa_customers", "siteid=:siteid and sa_customersid=:ownerid");
        datateamQuerySQL.addQueryFields("sa_customers.sys_enterpriseid");
        datateamQuerySQL.setWhere("ownertable", "sa_customers").setWhere("userid", subuserlist).setWhere("isleader", 1);
        sublist.addAll(datateamQuerySQL.query().toArrayList("sys_enterpriseid", new ArrayList<>()));

        //查询经销商数据团队表
        QuerySQL datateamQuerySQL2 = SQLFactory.createQuerySQL(controller, "sys_datateam");
        datateamQuerySQL2.addJoinTable(JOINTYPE.inner, "sa_agents", "sa_agents", "siteid=:siteid and sa_agentsid=:ownerid");
        datateamQuerySQL2.addQueryFields("sa_agents.sys_enterpriseid");
        datateamQuerySQL2.setWhere("ownertable", "sa_agents").setWhere("userid", subuserlist).setWhere("isleader", 1);
        sublist.addAll(datateamQuerySQL2.query().toArrayList("sys_enterpriseid", new ArrayList<>()));

        return sublist;
    }

    /**
     * 返回账号相关信息，头像、姓名、部门、职位
     */
    public static RowsMap getUserExtendMsg(Controller controller, ArrayList<Long> userids) throws YosException {
        SQLFactory sqlFactory = new SQLFactory(new User(), "账号相关信息查询");
        sqlFactory.addParameter("siteid", controller.siteid);
        sqlFactory.addParameter_in("userid", userids);
        Rows rows = controller.dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            row.put("headpic", controller.getHeadPic(row.getLong("userid")));
        }
        return rows.toRowsMap("userid");
    }

    public static ArrayList<Long> getUserRoleIDs(Controller controller, long userid) throws YosException {
        return controller.dbConnect.runSqlQuery("select roleid from sys_userrole where siteid='" + controller.siteid + "' and userid=" + userid).toArrayList("roleid", new ArrayList<>());
    }


    /**
     * 获取用户的邮箱号
     *
     * @param userid
     * @return
     * @throws YosException
     */
    public static ArrayList<String> getUserMailAddress(Controller controller, long userid) throws YosException {
        Rows rows = controller.dbConnect.runSqlQuery("select distinct email from ( SELECT userid,email FROM sys_hr where siteid='" + controller.siteid + "' and userid='" + userid + "'and email like'%@%'and LENGTH(email)>2 union all select userid,email from sys_enterprise_hr where siteid='" + controller.siteid + "' and userid='" + userid + "'and email like'%@%'and LENGTH(email)>2)t");
        return rows.toArrayList("email");
    }

    public static ArrayList<String> getUserMailAddress(DBConnect dbConnect, String siteid, long userid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select distinct email from ( SELECT userid,email FROM sys_hr where siteid='" + siteid + "' and userid='" + userid + "'and email like'%@%'and LENGTH(email)>2 union all select userid,email from sys_enterprise_hr where siteid='" + siteid + "' and userid='" + userid + "'and email like'%@%'and LENGTH(email)>2)t");
        return rows.toArrayList("email");
    }

    public static ArrayList<String> getUserPhonenumber(Controller controller, long userid) throws YosException {
        Rows rows = controller.dbConnect.runSqlQuery("select phonenumber from sys_users where userid=" + userid);
        return rows.toArrayList("phonenumber");
    }

    public static ArrayList<String> getUserPhonenumber(DBConnect dbConnect, long userid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select phonenumber from sys_users where userid=" + userid);
        return rows.toArrayList("phonenumber");
    }


    public static ArrayList<Long> getUserSiteid(Controller controller, long userid) throws YosException {
        Rows rows = controller.dbConnect.runSqlQuery("select usersiteid from sys_usersite where siteid='" + controller.siteid + "' and userid=" + userid);
        return rows.toArrayList("usersiteid", new ArrayList<>());
    }


    /**
     * 数据快速过滤
     *
     * @param controller
     * @param ownertable 数据表名
     * @param alias      数据表别名
     * @throws YosException
     */
//    public static String getDataWhereStr(Controller controller, String ownertable, String alias) throws YosException {
//        boolean issitetable = controller.isSiteTable(ownertable);
//        String str = " 1=1 ";
//        if (controller.usertype == 0 && issitetable) {
//            //站点系统管理员,只对站点进行判断
//            str = alias + ".siteid='" + controller.siteid + "'";
//        } else if (controller.sys_enterpriseid == 0 && controller.isSaler()) {
//            //企业业务员
//            str = " exists(select sys_datateamid from sys_datateam where siteid='" + controller.siteid + "' and isleader=1 and userid=" + controller.userid + " and ownertable='" + ownertable + "' and ownerid=" + alias + "." + controller.getuniquecolumnname(ownertable) + " )";
//        } else if (controller.sys_enterpriseid == 0 && !controller.isSaler()) {
//            //企业普通账号
//            str = " exists(select sys_datateamid from sys_datateam where siteid='" + controller.siteid + "' and isleader=1 and userid=" + controller.userid + " and ownertable='" + ownertable + "' and ownerid=" + alias + "." + controller.getuniquecolumnname(ownertable) + " )";
//        } else if (controller.sys_enterpriseid > 0) {
//            //企业普通账号
//            str = " exists(select sys_datateamid from sys_datateam where siteid='" + controller.siteid + "' and isleader=1 and userid=" + controller.userid + " and ownertable='" + ownertable + "' and ownerid=" + alias + "." + controller.getuniquecolumnname(ownertable) + " )";
//        }
//        return str;
//    }
}
