/*
 * Decompiled with CFR 0.152.
 */
package utility.hardware;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import utility.tools.Math;

public class Memory {
    private long totalMemory;
    private long usedMemory;
    private double memoryUsagePercent;
    private long heapMaxMemory;
    private long heapUsedMemory;
    private double heapMemoryUsagePercent;
    private static Memory memory = new Memory();

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public double getMemoryUsagePercent() {
        return this.memoryUsagePercent;
    }

    public long getHeapMaxMemory() {
        return this.heapMaxMemory;
    }

    public long getHeapUsedMemory() {
        return this.heapUsedMemory;
    }

    public double getHeapMemoryUsagePercent() {
        return this.heapMemoryUsagePercent;
    }

    public static Memory get() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        long totalMemory = osBean.getTotalPhysicalMemorySize();
        long usedMemory = totalMemory - osBean.getFreePhysicalMemorySize();
        Memory.memory.totalMemory = totalMemory / 1024L / 1024L;
        Memory.memory.usedMemory = usedMemory / 1024L / 1024L;
        Memory.memory.memoryUsagePercent = Math.round((double)usedMemory / (double)totalMemory * 100.0, 2);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        long heapUsedMemory = heapMemoryUsage.getUsed();
        long heapMaxMemory = heapMemoryUsage.getMax();
        Memory.memory.heapMaxMemory = heapMaxMemory / 1024L / 1024L;
        Memory.memory.heapUsedMemory = heapUsedMemory / 1024L / 1024L;
        Memory.memory.heapMemoryUsagePercent = Math.round((double)heapUsedMemory / (double)heapMaxMemory * 100.0, 2);
        return memory;
    }
}

