package restcontroller.sysmanage.develop.webportal;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.InsertSQL;
import common.data.UpdateSQL;
import restcontroller.R;

public class webportal extends Controller {
    public webportal(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "网址查询", apiversion = R.ID10018001.v1.class)
    public String queryWebAddressList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_webportal order by classname,sequence");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "网址新增修改", apiversion = R.ID10018101.v1.class)
    public String insertormodifyWebAddress() throws YosException {
        long sys_webportalid = content.getLong("sys_webportalid");
        String classname = content.getString("classname");
        String systemname = content.getString("systemname");
        String url = content.getString("url", true);
        String remarks = content.getString("remarks");

        if (sys_webportalid <= 0 || dbConnect.runSqlQuery("select * from sys_webportal where sys_webportalid=" + sys_webportalid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_webportal");
            insertSQL.setValue("sys_webportalid", createTableID("sys_webportal"));
            insertSQL.setValue("classname", classname);
            insertSQL.setValue("systemname", systemname);
            insertSQL.setValue("url", url);
            insertSQL.setValue("remarks", remarks);
            insertSQL.insert();
        } else {
            UpdateSQL rowUpdate = SQLFactory.createUpdateSQL(this, "sys_webportal");
            rowUpdate.setValue("classname", classname);
            rowUpdate.setValue("systemname", systemname);
            rowUpdate.setValue("url", url);
            rowUpdate.setValue("remarks", remarks);
            rowUpdate.setWhere("sys_webportalid", sys_webportalid);
            rowUpdate.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "网址删除", apiversion = R.ID10018201.v1.class)
    public String deleteWebAddress() throws YosException {
        long sys_webportalid = content.getLong("sys_webportalid");
        dbConnect.runSqlUpdate("delete from sys_webportal where sys_webportalid=" + sys_webportalid);
        return getSucReturnObject().toString();
    }

}
